/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.otp;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.otp.AuthenticatorConverter;
import java.util.Map;

@DataObject(generateConverter=true)
public class Authenticator {
    private String identifier;
    private String key;
    private String algorithm;
    private long counter;
    private Integer authAttempts;
    boolean registration;

    public Authenticator(boolean registration) {
        this.registration = registration;
    }

    public Authenticator() {
    }

    public Authenticator(JsonObject json) {
        AuthenticatorConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Authenticator setIdentifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public Authenticator setKey(String key) {
        this.key = key;
        return this;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public Authenticator setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public long getCounter() {
        return this.counter;
    }

    public Authenticator setCounter(long counter) {
        this.counter = counter;
        return this;
    }

    public Integer getAuthAttempts() {
        return this.authAttempts;
    }

    public Authenticator setAuthAttempts(Integer authAttempts) {
        this.authAttempts = authAttempts;
        return this;
    }

    @GenIgnore
    public boolean isRegistration() {
        return this.registration;
    }

    @GenIgnore
    public Authenticator registered() {
        this.registration = false;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        AuthenticatorConverter.toJson(this, json);
        return json;
    }

    public String toString() {
        return this.toJson().encode();
    }
}

