/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.JWTOptions;
import io.vertx.ext.auth.PubSecKeyOptions;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.ext.auth.oauth2.OAuth2OptionsConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@DataObject
@JsonGen(publicConverter=false)
public class OAuth2Options {
    private static final Logger LOG = LoggerFactory.getLogger(OAuth2Options.class);
    private static final boolean BASIC_AUTHORIZATION = true;
    private static final String AUTHORIZATION_PATH = "/oauth/authorize";
    private static final String TOKEN_PATH = "/oauth/token";
    private static final String REVOCATION_PATH = "/oauth/revoke";
    private static final String SCOPE_SEPARATOR = " ";
    private static final boolean VALIDATE_ISSUER = true;
    private static final long JWK_DEFAULT_AGE = -1L;
    private List<String> supportedGrantTypes;
    private String authorizationPath;
    private String tokenPath;
    private String revocationPath;
    private String scopeSeparator;
    private boolean validateIssuer;
    private String logoutPath;
    private String userInfoPath;
    private JsonObject userInfoParams;
    private String introspectionPath;
    private String jwkPath;
    private long jwkMaxAge;
    private String tenant;
    private String site;
    private String clientId;
    private String clientSecret;
    private boolean useBasicAuthorization;
    private String clientAssertionType;
    private String clientAssertion;
    private String userAgent;
    private JsonObject headers;
    private List<PubSecKeyOptions> pubSecKeys;
    private JWTOptions jwtOptions;
    private JsonObject extraParams;
    private HttpClientOptions httpClientOptions = new HttpClientOptions();
    private List<JsonObject> jwks;
    private static final Pattern TENANT_PATTER = Pattern.compile("\\{(tenant|realm)}");

    public String getSite() {
        return this.site;
    }

    public OAuth2Options() {
        this.init();
    }

    public OAuth2Options(OAuth2Options other) {
        ArrayList<Object> list;
        this.tenant = other.getTenant();
        this.clientId = other.getClientId();
        this.clientSecret = other.getClientSecret();
        this.useBasicAuthorization = other.isUseBasicAuthorization();
        this.clientAssertionType = other.getClientAssertionType();
        this.clientAssertion = other.getClientAssertion();
        this.validateIssuer = other.isValidateIssuer();
        this.authorizationPath = other.getAuthorizationPath();
        this.tokenPath = other.getTokenPath();
        this.revocationPath = other.getRevocationPath();
        this.userInfoPath = other.getUserInfoPath();
        this.introspectionPath = other.getIntrospectionPath();
        this.scopeSeparator = other.getScopeSeparator();
        this.site = other.getSite();
        if (other.pubSecKeys == null) {
            this.pubSecKeys = null;
        } else {
            list = new ArrayList<PubSecKeyOptions>(other.pubSecKeys.size());
            for (PubSecKeyOptions pubSecKey : other.pubSecKeys) {
                list.add(new PubSecKeyOptions(pubSecKey));
            }
            this.pubSecKeys = list;
        }
        this.jwtOptions = other.jwtOptions == null ? null : new JWTOptions(other.jwtOptions);
        this.logoutPath = other.getLogoutPath();
        this.extraParams = other.extraParams == null ? null : other.extraParams.copy();
        this.userInfoParams = other.userInfoParams == null ? null : other.userInfoParams.copy();
        this.headers = other.headers == null ? null : other.headers.copy();
        this.jwkPath = other.getJwkPath();
        this.jwkMaxAge = other.getJwkMaxAgeInSeconds();
        this.httpClientOptions = other.httpClientOptions == null ? null : new HttpClientOptions(other.httpClientOptions);
        this.userAgent = other.getUserAgent();
        ArrayList<String> arrayList = this.supportedGrantTypes = other.supportedGrantTypes == null ? null : new ArrayList<String>(other.supportedGrantTypes);
        if (other.jwks == null) {
            this.jwks = null;
        } else {
            list = new ArrayList(other.jwks.size());
            for (JsonObject jwk : other.jwks) {
                list.add((PubSecKeyOptions)jwk.copy());
            }
            this.jwks = list;
        }
        this.replaceVariables(false);
    }

    private void init() {
        this.validateIssuer = true;
        this.authorizationPath = AUTHORIZATION_PATH;
        this.tokenPath = TOKEN_PATH;
        this.revocationPath = REVOCATION_PATH;
        this.scopeSeparator = SCOPE_SEPARATOR;
        this.jwtOptions = new JWTOptions();
        this.jwkMaxAge = -1L;
        this.useBasicAuthorization = true;
    }

    public OAuth2Options(JsonObject json) {
        this.init();
        OAuth2OptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
        this.replaceVariables(false);
    }

    public String getAuthorizationPath() {
        return this.authorizationPath;
    }

    public OAuth2Options setAuthorizationPath(String authorizationPath) {
        this.authorizationPath = authorizationPath;
        return this;
    }

    public String getTokenPath() {
        return this.tokenPath;
    }

    public OAuth2Options setTokenPath(String tokenPath) {
        this.tokenPath = tokenPath;
        return this;
    }

    public String getRevocationPath() {
        return this.revocationPath;
    }

    public OAuth2Options setRevocationPath(String revocationPath) {
        this.revocationPath = revocationPath;
        return this;
    }

    public OAuth2Options setSite(String site) {
        this.site = site;
        return this;
    }

    public String getClientId() {
        return this.clientId;
    }

    public OAuth2Options setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public OAuth2Options setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public OAuth2Options setUseBasicAuthorization(boolean useBasicAuthorization) {
        this.useBasicAuthorization = useBasicAuthorization;
        return this;
    }

    public boolean isUseBasicAuthorization() {
        return this.useBasicAuthorization;
    }

    public String getClientAssertionType() {
        return this.clientAssertionType;
    }

    public OAuth2Options setClientAssertionType(String clientAssertionType) {
        this.clientAssertionType = clientAssertionType;
        return this;
    }

    public String getClientAssertion() {
        return this.clientAssertion;
    }

    public OAuth2Options setClientAssertion(String clientAssertion) {
        this.clientAssertion = clientAssertion;
        return this;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public OAuth2Options setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public JsonObject getHeaders() {
        return this.headers;
    }

    public OAuth2Options setHeaders(JsonObject headers) {
        this.headers = headers;
        return this;
    }

    public List<PubSecKeyOptions> getPubSecKeys() {
        return this.pubSecKeys;
    }

    public OAuth2Options setPubSecKeys(List<PubSecKeyOptions> pubSecKeys) {
        this.pubSecKeys = pubSecKeys;
        return this;
    }

    public OAuth2Options addPubSecKey(PubSecKeyOptions pubSecKey) {
        if (this.pubSecKeys == null) {
            this.pubSecKeys = new ArrayList<PubSecKeyOptions>();
        }
        this.pubSecKeys.add(pubSecKey);
        return this;
    }

    public String getLogoutPath() {
        return this.logoutPath;
    }

    public OAuth2Options setLogoutPath(String logoutPath) {
        this.logoutPath = logoutPath;
        return this;
    }

    public String getUserInfoPath() {
        return this.userInfoPath;
    }

    public OAuth2Options setUserInfoPath(String userInfoPath) {
        this.userInfoPath = userInfoPath;
        return this;
    }

    public String getScopeSeparator() {
        return this.scopeSeparator;
    }

    public OAuth2Options setScopeSeparator(String scopeSeparator) {
        this.scopeSeparator = scopeSeparator;
        return this;
    }

    public JsonObject getExtraParameters() {
        return this.extraParams;
    }

    public OAuth2Options setExtraParameters(JsonObject extraParams) {
        this.extraParams = extraParams;
        return this;
    }

    public String getIntrospectionPath() {
        return this.introspectionPath;
    }

    public OAuth2Options setIntrospectionPath(String introspectionPath) {
        this.introspectionPath = introspectionPath;
        return this;
    }

    public JsonObject getUserInfoParameters() {
        return this.userInfoParams;
    }

    public OAuth2Options setUserInfoParameters(JsonObject userInfoParams) {
        this.userInfoParams = userInfoParams;
        return this;
    }

    public String getJwkPath() {
        return this.jwkPath;
    }

    public OAuth2Options setJwkPath(String jwkPath) {
        this.jwkPath = jwkPath;
        return this;
    }

    public JWTOptions getJWTOptions() {
        return this.jwtOptions;
    }

    public OAuth2Options setJWTOptions(JWTOptions jwtOptions) {
        this.jwtOptions = jwtOptions;
        return this;
    }

    public boolean isValidateIssuer() {
        return this.validateIssuer;
    }

    public OAuth2Options setValidateIssuer(boolean validateIssuer) {
        this.validateIssuer = validateIssuer;
        return this;
    }

    public String getTenant() {
        return this.tenant;
    }

    public OAuth2Options setTenant(String tenant) {
        this.tenant = tenant;
        return this;
    }

    public List<String> getSupportedGrantTypes() {
        return this.supportedGrantTypes;
    }

    public OAuth2Options setSupportedGrantTypes(List<String> supportedGrantTypes) {
        this.supportedGrantTypes = supportedGrantTypes;
        return this;
    }

    public OAuth2Options addSupportedGrantType(String supportedGrantType) {
        if (this.supportedGrantTypes == null) {
            this.supportedGrantTypes = new ArrayList<String>();
        }
        this.supportedGrantTypes.add(supportedGrantType);
        return this;
    }

    public void replaceVariables(boolean strict) {
        if (this.site != null && this.site.endsWith("/")) {
            this.site = this.site.substring(0, this.site.length() - 1);
        }
        this.site = this.replaceVariables(this.site);
        this.authorizationPath = this.replaceVariables(this.authorizationPath);
        this.tokenPath = this.replaceVariables(this.tokenPath);
        this.revocationPath = this.replaceVariables(this.revocationPath);
        this.logoutPath = this.replaceVariables(this.logoutPath);
        this.userInfoPath = this.replaceVariables(this.userInfoPath);
        this.introspectionPath = this.replaceVariables(this.introspectionPath);
        this.jwkPath = this.replaceVariables(this.jwkPath);
        if (this.extraParams != null) {
            for (Map.Entry kv : this.extraParams) {
                Object v = kv.getValue();
                if (!(v instanceof String)) continue;
                try {
                    kv.setValue(this.replaceVariables((String)v));
                }
                catch (IllegalStateException e) {
                    if (!strict) continue;
                    throw e;
                }
            }
        }
    }

    private String replaceVariables(String path) {
        Matcher matcher;
        if (path != null && (matcher = TENANT_PATTER.matcher(path)).find()) {
            if (this.tenant == null) {
                throw new IllegalStateException("Configuration with placeholders require that \"tenant\" is prior set");
            }
            return matcher.replaceAll(this.tenant);
        }
        return path;
    }

    public void validate() throws IllegalStateException {
        List<String> supportedGrantTypes = this.getSupportedGrantTypes();
        if (supportedGrantTypes == null) {
            supportedGrantTypes = Arrays.asList(OAuth2FlowType.AUTH_CODE.getGrantType(), OAuth2FlowType.IMPLICIT.getGrantType());
        }
        block4: for (OAuth2FlowType flow : OAuth2FlowType.values()) {
            if (!supportedGrantTypes.contains(flow.getGrantType())) continue;
            switch (flow) {
                case AUTH_CODE: 
                case AUTH_JWT: 
                case AAD_OBO: {
                    if (this.clientAssertion == null && this.clientAssertionType == null) {
                        if (this.clientId != null) continue block4;
                        throw new IllegalStateException("Configuration missing. You need to specify [clientId]");
                    }
                    if (this.clientAssertion != null && this.clientAssertionType != null) continue block4;
                    throw new IllegalStateException("Configuration missing. You need to specify [clientAssertion] AND [clientAssertionType]");
                }
                case PASSWORD: {
                    if (this.clientAssertion == null && this.clientAssertionType == null) {
                        if (this.clientId != null) continue block4;
                        LOG.debug((Object)"If you are using Client Oauth2 Resource Owner flow. You need to specify [clientId]");
                        continue block4;
                    }
                    if (this.clientAssertion != null && this.clientAssertionType != null) continue block4;
                    throw new IllegalStateException("Configuration missing. You need to specify [clientAssertion] AND [clientAssertionType]");
                }
            }
        }
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        OAuth2OptionsConverter.toJson(this, json);
        return json;
    }

    public String toString() {
        return this.toJson().encode();
    }

    public HttpClientOptions getHttpClientOptions() {
        return this.httpClientOptions;
    }

    public OAuth2Options setHttpClientOptions(HttpClientOptions httpClientOptions) {
        this.httpClientOptions = httpClientOptions;
        return this;
    }

    public long getJwkMaxAgeInSeconds() {
        return this.jwkMaxAge;
    }

    public void setJwkMaxAgeInSeconds(long jwkMaxAgeInSeconds) {
        this.jwkMaxAge = jwkMaxAgeInSeconds;
    }

    public List<JsonObject> getJwks() {
        return this.jwks;
    }

    @Fluent
    public OAuth2Options setJwks(List<JsonObject> jwks) {
        this.jwks = jwks;
        return this;
    }

    @Fluent
    public OAuth2Options addJwk(JsonObject jwk) {
        if (this.jwks == null) {
            this.jwks = new ArrayList<JsonObject>();
        }
        this.jwks.add(jwk);
        return this;
    }
}

