/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.ext.auth.oauth2.Oauth2Credentials;
import java.util.ArrayList;
import java.util.Map;

public class Oauth2CredentialsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, Oauth2Credentials obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "code": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setCode((String)member.getValue());
                    break;
                }
                case "redirectUri": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setRedirectUri((String)member.getValue());
                    break;
                }
                case "codeVerifier": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setCodeVerifier((String)member.getValue());
                    break;
                }
                case "scopes": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setScopes(list);
                    break;
                }
                case "jwt": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setJwt(((JsonObject)member.getValue()).copy());
                    break;
                }
                case "assertion": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setAssertion((String)member.getValue());
                    break;
                }
                case "password": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPassword((String)member.getValue());
                    break;
                }
                case "username": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setUsername((String)member.getValue());
                    break;
                }
                case "flow": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setFlow(OAuth2FlowType.valueOf((String)member.getValue()));
                }
            }
        }
    }

    static void toJson(Oauth2Credentials obj, JsonObject json) {
        Oauth2CredentialsConverter.toJson(obj, json.getMap());
    }

    static void toJson(Oauth2Credentials obj, Map<String, Object> json) {
        if (obj.getCode() != null) {
            json.put("code", obj.getCode());
        }
        if (obj.getRedirectUri() != null) {
            json.put("redirectUri", obj.getRedirectUri());
        }
        if (obj.getCodeVerifier() != null) {
            json.put("codeVerifier", obj.getCodeVerifier());
        }
        if (obj.getScopes() != null) {
            JsonArray array = new JsonArray();
            obj.getScopes().forEach(item -> array.add(item));
            json.put("scopes", array);
        }
        if (obj.getJwt() != null) {
            json.put("jwt", obj.getJwt());
        }
        if (obj.getAssertion() != null) {
            json.put("assertion", obj.getAssertion());
        }
        if (obj.getPassword() != null) {
            json.put("password", obj.getPassword());
        }
        if (obj.getUsername() != null) {
            json.put("username", obj.getUsername());
        }
        if (obj.getFlow() != null) {
            json.put("flow", obj.getFlow().name());
        }
    }
}

