/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.JWTOptions;
import io.vertx.ext.auth.NoSuchKeyIdException;
import io.vertx.ext.auth.PubSecKeyOptions;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.impl.jose.JWK;
import io.vertx.ext.auth.impl.jose.JWT;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import io.vertx.ext.auth.oauth2.OAuth2RBAC;
import io.vertx.ext.auth.oauth2.Oauth2Credentials;
import io.vertx.ext.auth.oauth2.impl.AccessTokenImpl;
import io.vertx.ext.auth.oauth2.impl.OAuth2API;
import java.util.Collections;

public class OAuth2AuthProviderImpl
implements OAuth2Auth {
    private static final Logger LOG = LoggerFactory.getLogger(OAuth2AuthProviderImpl.class);
    private final Vertx vertx;
    private final OAuth2Options config;
    private final OAuth2API api;
    private JWT jwt = new JWT();
    private long updateTimerId = -1L;
    private Handler<String> missingKeyHandler;

    public OAuth2AuthProviderImpl(Vertx vertx, OAuth2Options config) {
        this.vertx = vertx;
        this.config = config;
        this.api = new OAuth2API(vertx, config);
        this.config.replaceVariables(true);
        this.config.validate();
        if (config.getPubSecKeys() != null) {
            for (PubSecKeyOptions pubSecKey : config.getPubSecKeys()) {
                this.jwt.addJWK(new JWK(pubSecKey));
            }
        }
    }

    @Override
    public OAuth2Auth jWKSet(Handler<AsyncResult<Void>> handler) {
        this.api.jwkSet((Handler<AsyncResult<JsonObject>>)((Handler)res -> {
            if (res.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                if (this.updateTimerId != -1L) {
                    this.vertx.cancelTimer(this.updateTimerId);
                }
                JsonObject json = (JsonObject)res.result();
                JWT jwt = new JWT();
                JsonArray keys = json.getJsonArray("keys");
                for (Object key : keys) {
                    try {
                        jwt.addJWK(new JWK((JsonObject)key));
                    }
                    catch (RuntimeException e) {
                        LOG.warn((Object)("Skipped unsupported JWK: " + e.getMessage()));
                    }
                }
                this.jwt = jwt;
                if (json.containsKey("maxAge")) {
                    long delay = json.getLong("maxAge") * 1000L;
                    this.updateTimerId = delay > 0L ? this.vertx.setPeriodic(delay, t -> this.jWKSet((Handler<AsyncResult<Void>>)((Handler)autoUpdateRes -> {
                        if (autoUpdateRes.failed()) {
                            LOG.warn((Object)"Failed to auto-update JWK Set", autoUpdateRes.cause());
                        }
                    }))) : -1L;
                }
                handler.handle((Object)Future.succeededFuture());
            }
        }));
        return this;
    }

    @Override
    public OAuth2Auth missingKeyHandler(Handler<String> handler) {
        this.missingKeyHandler = handler;
        return this;
    }

    public OAuth2Options getConfig() {
        return this.config;
    }

    public void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> handler) {
        this.authenticate(new Oauth2Credentials(authInfo), handler);
    }

    @Override
    public void authenticate(Oauth2Credentials authInfo, Handler<AsyncResult<User>> handler) {
        if (authInfo.getAccessToken() != null) {
            User user = this.createUser(authInfo.toJson());
            if (!user.attributes().containsKey("accessToken") || this.jwt.isUnsecure()) {
                this.api.tokenIntrospection("access_token", user.principal().getString("access_token"), (Handler<AsyncResult<JsonObject>>)((Handler)res -> {
                    if (res.failed()) {
                        handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
                        return;
                    }
                    JsonObject json = (JsonObject)res.result();
                    if (json.containsKey("active") && !json.getBoolean("active", Boolean.valueOf(false)).booleanValue()) {
                        handler.handle((Object)Future.failedFuture((String)"Inactive Token"));
                        return;
                    }
                    if (json.containsKey("client_id") && !this.config.getClientID().equals(json.getString("client_id"))) {
                        handler.handle((Object)Future.failedFuture((String)"Wrong client_id"));
                        return;
                    }
                    User newUser = this.createUser(json);
                    if (newUser.expired(this.config.getJWTOptions().getLeeway())) {
                        handler.handle((Object)Future.failedFuture((String)"Used is expired."));
                    } else {
                        this.validateUser(newUser, handler);
                    }
                }));
            } else {
                JWTOptions jwtOptions = this.config.getJWTOptions();
                if (user.expired(jwtOptions.getLeeway())) {
                    handler.handle((Object)Future.failedFuture((String)"Expired Token"));
                } else {
                    this.validateUser(user, handler);
                }
            }
        } else {
            JsonObject params = new JsonObject();
            switch (this.config.getFlow()) {
                case PASSWORD: {
                    if (authInfo.getUsername() != null && authInfo.getPassword() != null) {
                        params.put("username", (Object)authInfo.getUsername()).put("password", (Object)authInfo.getPassword());
                        break;
                    }
                    handler.handle((Object)Future.failedFuture((String)"PASSWORD flow requires {username, password}"));
                    return;
                }
                case AUTH_CODE: {
                    if (authInfo.getCode() != null && authInfo.getRedirectUri() != null) {
                        params.mergeIn(authInfo.toJson());
                        break;
                    }
                    handler.handle((Object)Future.failedFuture((String)"AUTH_CODE flow requires {code, redirect_uri}"));
                    return;
                }
                case CLIENT: {
                    params.mergeIn(authInfo.toJson());
                    break;
                }
                case AUTH_JWT: {
                    JsonObject credentials = authInfo.toJson();
                    params.mergeIn(credentials);
                    params.put("assertion", (Object)this.jwt.sign(credentials, this.config.getJWTOptions()));
                    break;
                }
                default: {
                    handler.handle((Object)Future.failedFuture((String)"Current flow does not allow acquiring a token by the replay party"));
                    return;
                }
            }
            this.api.token(this.config.getFlow().getGrantType(), params, (Handler<AsyncResult<JsonObject>>)((Handler)getToken -> {
                if (getToken.failed()) {
                    handler.handle((Object)Future.failedFuture((Throwable)getToken.cause()));
                } else {
                    User newUser = this.createUser((JsonObject)getToken.result());
                    if (newUser.expired(this.config.getJWTOptions().getLeeway())) {
                        handler.handle((Object)Future.failedFuture((String)"Used is expired."));
                    } else {
                        this.validateUser(newUser, handler);
                    }
                }
            }));
        }
    }

    @Override
    public String authorizeURL(JsonObject params) {
        return this.api.authorizeURL(params);
    }

    @Override
    public OAuth2Auth refresh(User user, Handler<AsyncResult<User>> handler) {
        this.api.token("refresh_token", new JsonObject().put("refresh_token", (Object)user.principal().getString("refresh_token")), (Handler<AsyncResult<JsonObject>>)((Handler)getToken -> {
            if (getToken.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)getToken.cause()));
            } else {
                User newUser = this.createUser((JsonObject)getToken.result());
                if (newUser.expired(this.config.getJWTOptions().getLeeway())) {
                    handler.handle((Object)Future.failedFuture((String)"Used is expired."));
                } else {
                    this.validateUser(newUser, handler);
                }
            }
        }));
        return this;
    }

    @Override
    public OAuth2Auth revoke(User user, String tokenType, Handler<AsyncResult<Void>> handler) {
        this.api.tokenRevocation(tokenType, user.principal().getString(tokenType), handler);
        return this;
    }

    @Override
    public OAuth2Auth userInfo(User user, Handler<AsyncResult<JsonObject>> handler) {
        this.api.userInfo(user.principal().getString("access_token"), handler);
        return this;
    }

    @Override
    public String endSessionURL(User user, JsonObject params) {
        return this.api.endSessionURL(user.principal().getString("id_token"), params);
    }

    OAuth2API api() {
        return this.api;
    }

    private User createUser(JsonObject json) {
        User user = User.create((JsonObject)json);
        long now = System.currentTimeMillis() / 1000L;
        if (json.containsKey("expires_in")) {
            Long expiresIn;
            try {
                expiresIn = json.getLong("expires_in");
            }
            catch (ClassCastException e) {
                expiresIn = Long.valueOf(json.getString("expires_in"));
            }
            user.attributes().put("iat", (Object)now).put("exp", (Object)(now + expiresIn));
        }
        if (!this.jwt.isUnsecure()) {
            Long exp;
            if (json.containsKey("access_token")) {
                try {
                    user.attributes().put("accessToken", (Object)this.jwt.decode(json.getString("access_token")));
                    if (!user.attributes().containsKey("exp") && (exp = user.attributes().getJsonObject("accessToken").getLong("exp")) != null) {
                        user.attributes().put("exp", (Object)exp);
                    }
                    user.attributes().put("rootClaim", (Object)"accessToken");
                }
                catch (NoSuchKeyIdException e) {
                    if (this.missingKeyHandler != null) {
                        this.missingKeyHandler.handle((Object)e.id());
                    } else {
                        LOG.trace((Object)"Cannot decode access token:", (Throwable)e);
                    }
                }
                catch (DecodeException | IllegalStateException e) {
                    LOG.trace((Object)"Cannot decode access token:", e);
                }
            }
            if (json.containsKey("id_token")) {
                try {
                    user.attributes().put("idToken", (Object)this.jwt.decode(json.getString("id_token")));
                    if (!user.attributes().containsKey("exp") && (exp = user.attributes().getJsonObject("idToken").getLong("exp")) != null) {
                        user.attributes().put("exp", (Object)exp);
                    }
                }
                catch (NoSuchKeyIdException e) {
                    if (this.missingKeyHandler != null) {
                        this.missingKeyHandler.handle((Object)e.id());
                    } else {
                        LOG.trace((Object)"Cannot decode access token:", (Throwable)e);
                    }
                }
                catch (DecodeException | IllegalStateException e) {
                    LOG.trace((Object)"Cannot decode id token:", e);
                }
            }
        }
        return user;
    }

    private void validateUser(User user, Handler<AsyncResult<User>> handler) {
        JsonObject payload;
        if (!user.attributes().containsKey("accessToken")) {
            handler.handle((Object)Future.succeededFuture((Object)user));
            return;
        }
        JWTOptions jwtOptions = this.config.getJWTOptions();
        try {
            payload = user.attributes().getJsonObject("accessToken");
        }
        catch (RuntimeException e) {
            handler.handle((Object)Future.failedFuture((String)"User accessToken isn't a JsonObject"));
            return;
        }
        if (jwtOptions.getAudience() != null) {
            JsonArray target = payload.getValue("aud") instanceof String ? new JsonArray().add(payload.getValue("aud", (Object)"")) : payload.getJsonArray("aud", new JsonArray());
            if (Collections.disjoint(jwtOptions.getAudience(), target.getList())) {
                handler.handle((Object)Future.failedFuture((String)("Invalid JWT audience. expected: " + Json.encode((Object)jwtOptions.getAudience()))));
                return;
            }
        }
        if (jwtOptions.getIssuer() != null && !jwtOptions.getIssuer().equals(payload.getString("iss"))) {
            handler.handle((Object)Future.failedFuture((String)"Invalid JWT issuer"));
            return;
        }
        handler.handle((Object)Future.succeededFuture((Object)user));
    }

    @Override
    @Deprecated
    public OAuth2Auth decodeToken(String token, Handler<AsyncResult<AccessToken>> handler) {
        try {
            JsonObject json = this.jwt.decode(token);
            handler.handle((Object)Future.succeededFuture((Object)this.createAccessToken(json)));
        }
        catch (RuntimeException e) {
            handler.handle((Object)Future.failedFuture((Throwable)e));
        }
        return this;
    }

    @Override
    @Deprecated
    public OAuth2Auth introspectToken(String token, String tokenType, Handler<AsyncResult<AccessToken>> handler) {
        return this;
    }

    @Override
    @Deprecated
    public OAuth2FlowType getFlowType() {
        return this.config.getFlow();
    }

    @Override
    @Deprecated
    public OAuth2Auth rbacHandler(OAuth2RBAC rbac) {
        return this;
    }

    @Deprecated
    private AccessToken createAccessToken(JsonObject json) {
        AccessTokenImpl user = new AccessTokenImpl(json, this);
        long now = System.currentTimeMillis() / 1000L;
        if (json.containsKey("expires_in")) {
            Long expiresIn;
            try {
                expiresIn = json.getLong("expires_in");
            }
            catch (ClassCastException e) {
                expiresIn = Long.valueOf(json.getString("expires_in"));
            }
            user.attributes().put("iat", (Object)now).put("exp", (Object)(now + expiresIn));
        }
        if (json.getString("access_token") != null) {
            try {
                Long exp;
                user.attributes().put("accessToken", (Object)this.jwt.decode(json.getString("access_token")));
                if (!user.attributes().containsKey("exp") && (exp = user.attributes().getJsonObject("accessToken").getLong("exp")) != null) {
                    user.attributes().put("exp", (Object)exp);
                }
                user.attributes().put("rootClaim", (Object)"accessToken");
            }
            catch (NoSuchKeyIdException e) {
                if (this.missingKeyHandler != null) {
                    this.missingKeyHandler.handle((Object)e.id());
                } else {
                    LOG.trace((Object)"Cannot decode access token:", (Throwable)e);
                }
            }
            catch (DecodeException | IllegalStateException e) {
                LOG.trace((Object)"Cannot decode access token:", e);
            }
        }
        if (json.getString("id_token") != null) {
            try {
                user.attributes().put("idToken", (Object)this.jwt.decode(json.getString("id_token")));
            }
            catch (NoSuchKeyIdException e) {
                if (this.missingKeyHandler != null) {
                    this.missingKeyHandler.handle((Object)e.id());
                } else {
                    LOG.trace((Object)"Cannot decode access token:", (Throwable)e);
                }
            }
            catch (DecodeException | IllegalStateException e) {
                LOG.trace((Object)"Cannot decode id token:", e);
            }
        }
        return user;
    }
}

