/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.PubSecKeyOptions;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.ext.auth.oauth2.OAuth2RBAC;
import io.vertx.ext.auth.oauth2.impl.AccessTokenImpl;
import io.vertx.ext.auth.oauth2.impl.OAuth2API;
import io.vertx.ext.jwt.JWK;
import io.vertx.ext.jwt.JWT;

public class OAuth2AuthProviderImpl
implements OAuth2Auth {
    private static final Logger LOG = LoggerFactory.getLogger(OAuth2AuthProviderImpl.class);
    private final OAuth2ClientOptions config;
    private final OAuth2API api;
    private JWT jwt = new JWT();

    public OAuth2AuthProviderImpl(OAuth2API api, OAuth2ClientOptions config) {
        this.api = api;
        this.config = config;
        this.config.replaceVariables(true);
        this.config.validate();
        if (config.getPubSecKeys() != null) {
            for (PubSecKeyOptions pubSecKey : config.getPubSecKeys()) {
                this.jwt.addJWK(JWK.from((PubSecKeyOptions)pubSecKey));
            }
        }
    }

    @Override
    public OAuth2Auth jWKSet(Handler<AsyncResult<Void>> handler) {
        this.api.jwkSet((Handler<AsyncResult<JsonArray>>)((Handler)res -> {
            if (res.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                JWT jwt = new JWT();
                for (Object key : (JsonArray)res.result()) {
                    try {
                        jwt.addJWK(new JWK((JsonObject)key));
                    }
                    catch (RuntimeException e) {
                        LOG.warn((Object)("Skipped unsupported JWK: " + e.getMessage()));
                    }
                }
                this.jwt = jwt;
                handler.handle((Object)Future.succeededFuture());
            }
        }));
        return this;
    }

    public OAuth2ClientOptions getConfig() {
        return this.config;
    }

    public void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> handler) {
        if (authInfo.containsKey("token_type") && "Bearer".equalsIgnoreCase(authInfo.getString("token_type")) && authInfo.containsKey("access_token") && authInfo.getString("access_token") != null) {
            AccessToken user = this.createAccessToken(authInfo);
            if (!user.principal().containsKey("accessToken") || this.jwt.isUnsecure()) {
                this.api.tokenIntrospection("access_token", user.principal().getString("access_token"), (Handler<AsyncResult<JsonObject>>)((Handler)res -> {
                    if (res.failed()) {
                        handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
                        return;
                    }
                    JsonObject json = (JsonObject)res.result();
                    if (json.containsKey("active") && !json.getBoolean("active", Boolean.valueOf(false)).booleanValue()) {
                        handler.handle((Object)Future.failedFuture((String)"Inactive Token"));
                        return;
                    }
                    if (json.containsKey("client_id") && !this.config.getClientID().equals(json.getString("client_id"))) {
                        handler.handle((Object)Future.failedFuture((String)"Wrong client_id"));
                        return;
                    }
                    if (json.containsKey("token_type") && !"Bearer".equalsIgnoreCase(json.getString("token_type"))) {
                        handler.handle((Object)Future.failedFuture((String)"Wrong token_type"));
                        return;
                    }
                    AccessToken newUser = this.createAccessToken(json);
                    if (newUser.expired(this.config.getJWTOptions().getLeeway())) {
                        handler.handle((Object)Future.failedFuture((String)"Used is expired."));
                    } else {
                        handler.handle((Object)Future.succeededFuture((Object)newUser));
                    }
                }));
            } else if (user.expired(this.config.getJWTOptions().getLeeway())) {
                handler.handle((Object)Future.failedFuture((String)"Expired Token"));
            } else {
                handler.handle((Object)Future.succeededFuture((Object)user));
            }
        } else {
            JsonObject params = new JsonObject();
            switch (this.config.getFlow()) {
                case PASSWORD: {
                    if (authInfo.containsKey("username") && authInfo.containsKey("password")) {
                        params.put("username", (Object)authInfo.getString("username")).put("password", (Object)authInfo.getString("password"));
                        break;
                    }
                    handler.handle((Object)Future.failedFuture((String)"PASSWORD flow requires {username, password}"));
                    return;
                }
                case AUTH_CODE: {
                    if (authInfo.containsKey("code") && authInfo.containsKey("redirect_uri")) {
                        params.mergeIn(authInfo);
                        break;
                    }
                    handler.handle((Object)Future.failedFuture((String)"AUTH_CODE flow requires {code, redirect_uri}"));
                    return;
                }
                case CLIENT: {
                    params.mergeIn(authInfo);
                    break;
                }
                case AUTH_JWT: {
                    params.mergeIn(authInfo);
                    params.put("assertion", (Object)this.jwt.sign(authInfo, this.config.getJWTOptions()));
                    break;
                }
                default: {
                    handler.handle((Object)Future.failedFuture((String)"Current flow does not allow acquiring a token by the replay party"));
                    return;
                }
            }
            this.api.token(this.config.getFlow().getGrantType(), params, (Handler<AsyncResult<JsonObject>>)((Handler)getToken -> {
                if (getToken.failed()) {
                    handler.handle((Object)Future.failedFuture((Throwable)getToken.cause()));
                } else {
                    AccessToken newUser = this.createAccessToken((JsonObject)getToken.result());
                    if (newUser.expired(this.config.getJWTOptions().getLeeway())) {
                        handler.handle((Object)Future.failedFuture((String)"Used is expired."));
                    } else {
                        handler.handle((Object)Future.succeededFuture((Object)newUser));
                    }
                }
            }));
        }
    }

    @Override
    public String authorizeURL(JsonObject params) {
        return this.api.authorizeURL(params);
    }

    @Override
    public OAuth2Auth refresh(User user, Handler<AsyncResult<User>> handler) {
        this.api.token("refresh_token", new JsonObject().put("refresh_token", (Object)user.principal().getString("refresh_token")), (Handler<AsyncResult<JsonObject>>)((Handler)getToken -> {
            if (getToken.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)getToken.cause()));
            } else {
                User newUser = this.createUser((JsonObject)getToken.result());
                if (newUser.expired(this.config.getJWTOptions().getLeeway())) {
                    handler.handle((Object)Future.failedFuture((String)"Used is expired."));
                } else {
                    handler.handle((Object)Future.succeededFuture((Object)newUser));
                }
            }
        }));
        return this;
    }

    @Override
    public OAuth2Auth revoke(User user, String tokenType, Handler<AsyncResult<Void>> handler) {
        this.api.tokenRevocation(tokenType, user.principal().getString(tokenType), handler);
        return this;
    }

    @Override
    public OAuth2Auth userInfo(User user, Handler<AsyncResult<JsonObject>> handler) {
        this.api.userInfo(user.principal().getString("access_token"), handler);
        return this;
    }

    @Override
    public String endSessionURL(User user, JsonObject params) {
        return this.api.endSessionURL(user.principal().getString("id_token"), params);
    }

    OAuth2API api() {
        return this.api;
    }

    private User createUser(JsonObject json) {
        User user = User.create((JsonObject)json);
        long now = System.currentTimeMillis() / 1000L;
        if (json.containsKey("expires_in")) {
            Long expiresIn;
            try {
                expiresIn = json.getLong("expires_in");
            }
            catch (ClassCastException e) {
                expiresIn = Long.valueOf(json.getString("expires_in"));
            }
            user.attributes().put("iat", (Object)now).put("exp", (Object)(now + expiresIn));
        }
        if (json.getString("access_token") != null) {
            try {
                Long exp;
                user.principal().put("accessToken", (Object)this.jwt.decode(json.getString("access_token")));
                if (!user.attributes().containsKey("exp") && (exp = user.principal().getJsonObject("accessToken").getLong("exp")) != null) {
                    user.attributes().put("exp", (Object)exp);
                }
                user.attributes().put("rootClaim", (Object)"accessToken");
            }
            catch (IllegalStateException e) {
                LOG.debug((Object)"Cannot decode access token:", (Throwable)e);
            }
        }
        if (json.getString("id_token") != null) {
            try {
                user.principal().put("idToken", (Object)this.jwt.decode(json.getString("id_token")));
            }
            catch (IllegalStateException e) {
                LOG.debug((Object)"Cannot decode id token:", (Throwable)e);
            }
        }
        return user;
    }

    @Override
    @Deprecated
    public OAuth2Auth decodeToken(String token, Handler<AsyncResult<AccessToken>> handler) {
        try {
            JsonObject json = this.jwt.decode(token);
            handler.handle((Object)Future.succeededFuture((Object)this.createAccessToken(json)));
        }
        catch (RuntimeException e) {
            handler.handle((Object)Future.failedFuture((Throwable)e));
        }
        return this;
    }

    @Override
    @Deprecated
    public OAuth2Auth introspectToken(String token, String tokenType, Handler<AsyncResult<AccessToken>> handler) {
        return this;
    }

    @Override
    @Deprecated
    public OAuth2FlowType getFlowType() {
        return this.config.getFlow();
    }

    @Override
    @Deprecated
    public OAuth2Auth rbacHandler(OAuth2RBAC rbac) {
        return null;
    }

    private AccessToken createAccessToken(JsonObject json) {
        AccessTokenImpl user = new AccessTokenImpl(json, this);
        long now = System.currentTimeMillis() / 1000L;
        if (json.containsKey("expires_in")) {
            Long expiresIn;
            try {
                expiresIn = json.getLong("expires_in");
            }
            catch (ClassCastException e) {
                expiresIn = Long.valueOf(json.getString("expires_in"));
            }
            user.attributes().put("iat", (Object)now).put("exp", (Object)(now + expiresIn));
        }
        if (json.getString("access_token") != null) {
            try {
                Long exp;
                user.principal().put("accessToken", (Object)this.jwt.decode(json.getString("access_token")));
                if (!user.attributes().containsKey("exp") && (exp = user.principal().getJsonObject("accessToken").getLong("exp")) != null) {
                    user.attributes().put("exp", (Object)exp);
                }
                user.attributes().put("rootClaim", (Object)"accessToken");
            }
            catch (IllegalStateException e) {
                LOG.debug((Object)"Cannot decode access token:", (Throwable)e);
            }
        }
        if (json.getString("id_token") != null) {
            try {
                user.principal().put("idToken", (Object)this.jwt.decode(json.getString("id_token")));
            }
            catch (IllegalStateException e) {
                LOG.debug((Object)"Cannot decode id token:", (Throwable)e);
            }
        }
        return user;
    }
}

