/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.providers;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.ext.auth.oauth2.OAuth2Response;
import io.vertx.ext.auth.oauth2.impl.OAuth2API;

@VertxGen
public interface OpenIDConnectAuth {
    public static void discover(Vertx vertx, OAuth2ClientOptions config, Handler<AsyncResult<OAuth2Auth>> handler) {
        if (config.getSite() == null) {
            handler.handle((Object)Future.failedFuture((String)"issuer cannot be null"));
            return;
        }
        config.replaceVariables(false);
        OAuth2API api = new OAuth2API(vertx, config);
        HttpClientRequest request = api.makeRequest(HttpMethod.GET, config.getSite() + "/.well-known/openid-configuration", (Handler<AsyncResult<OAuth2Response>>)((Handler)res -> {
            String issuerEndpoint;
            if (res.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
                return;
            }
            OAuth2Response response = (OAuth2Response)res.result();
            if (response.statusCode() != 200) {
                handler.handle((Object)Future.failedFuture((String)("Bad Response [" + response.statusCode() + "] " + response.body())));
                return;
            }
            if (!response.is("application/json")) {
                handler.handle((Object)Future.failedFuture((String)("Cannot handle Content-Type: " + response.headers().get("Content-Type"))));
                return;
            }
            JsonObject json = response.jsonObject();
            if (config.isValidateIssuer() && (issuerEndpoint = json.getString("issuer")) != null && !config.getSite().equals(issuerEndpoint)) {
                handler.handle((Object)Future.failedFuture((String)("issuer validation failed: received [" + issuerEndpoint + "]")));
                return;
            }
            config.setAuthorizationPath(json.getString("authorization_endpoint"));
            config.setTokenPath(json.getString("token_endpoint"));
            config.setIntrospectionPath(json.getString("token_introspection_endpoint"));
            config.setLogoutPath(json.getString("end_session_endpoint"));
            config.setRevocationPath(json.getString("revocation_endpoint"));
            config.setUserInfoPath(json.getString("userinfo_endpoint"));
            config.setJwkPath(json.getString("jwks_uri"));
            try {
                OAuth2Auth oidc = OAuth2Auth.create(vertx, config);
                if (config.getJwkPath() != null) {
                    oidc.loadJWK((Handler<AsyncResult<Void>>)((Handler)v -> {
                        if (v.failed()) {
                            handler.handle((Object)Future.failedFuture((Throwable)v.cause()));
                            return;
                        }
                        handler.handle((Object)Future.succeededFuture((Object)oidc));
                    }));
                } else {
                    handler.handle((Object)Future.succeededFuture((Object)oidc));
                }
            }
            catch (IllegalArgumentException e) {
                handler.handle((Object)Future.failedFuture((Throwable)e));
            }
        }));
        request.exceptionHandler(t -> handler.handle((Object)Future.failedFuture((Throwable)t)));
        request.putHeader("Accept", "application/json");
        request.end();
    }

    public static Future<OAuth2Auth> discover(Vertx vertx, OAuth2ClientOptions config) {
        Promise promise = Promise.promise();
        OpenIDConnectAuth.discover(vertx, config, (Handler<AsyncResult<OAuth2Auth>>)promise);
        return promise.future();
    }
}

