/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.ext.auth.oauth2.OAuth2RBAC;
import io.vertx.ext.auth.oauth2.impl.OAuth2AuthProviderImpl;

@VertxGen
public interface OAuth2Auth
extends AuthProvider {
    public static OAuth2Auth create(Vertx vertx) {
        return OAuth2Auth.create(vertx, new OAuth2ClientOptions());
    }

    public static OAuth2Auth create(Vertx vertx, OAuth2ClientOptions config) {
        return new OAuth2AuthProviderImpl(vertx, config);
    }

    public String authorizeURL(JsonObject var1);

    @Fluent
    public OAuth2Auth decodeToken(String var1, Handler<AsyncResult<AccessToken>> var2);

    default public Future<AccessToken> decodeToken(String token) {
        Promise promise = Promise.promise();
        this.decodeToken(token, (Handler<AsyncResult<AccessToken>>)promise);
        return promise.future();
    }

    @Fluent
    default public OAuth2Auth introspectToken(String token, Handler<AsyncResult<AccessToken>> handler) {
        return this.introspectToken(token, "access_token", handler);
    }

    default public Future<AccessToken> introspectToken(String token) {
        Promise promise = Promise.promise();
        this.introspectToken(token, (Handler<AsyncResult<AccessToken>>)promise);
        return promise.future();
    }

    @Fluent
    public OAuth2Auth introspectToken(String var1, String var2, Handler<AsyncResult<AccessToken>> var3);

    public OAuth2FlowType getFlowType();

    @Fluent
    public OAuth2Auth loadJWK(Handler<AsyncResult<Void>> var1);

    default public Future<Void> loadJWK() {
        Promise promise = Promise.promise();
        this.loadJWK((Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Fluent
    public OAuth2Auth rbacHandler(OAuth2RBAC var1);
}

