/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.oauth2.OAuth2Response;

@VertxGen
public interface AccessToken
extends User {
    public boolean expired();

    @CacheReturn
    public JsonObject accessToken();

    @CacheReturn
    public JsonObject idToken();

    public String opaqueAccessToken();

    public String opaqueRefreshToken();

    public String opaqueIdToken();

    public String tokenType();

    @Fluent
    public AccessToken setTrustJWT(boolean var1);

    @Fluent
    public AccessToken refresh(Handler<AsyncResult<Void>> var1);

    default public Future<Void> refresh() {
        Promise promise = Promise.promise();
        this.refresh((Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Fluent
    public AccessToken revoke(String var1, Handler<AsyncResult<Void>> var2);

    default public Future<Void> revoke(String token_type) {
        Promise promise = Promise.promise();
        this.revoke(token_type, (Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Fluent
    public AccessToken logout(Handler<AsyncResult<Void>> var1);

    default public Future<Void> logout() {
        Promise promise = Promise.promise();
        this.logout((Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Fluent
    public AccessToken introspect(Handler<AsyncResult<Void>> var1);

    default public Future<Void> introspect() {
        Promise promise = Promise.promise();
        this.introspect((Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Fluent
    public AccessToken introspect(String var1, Handler<AsyncResult<Void>> var2);

    default public Future<Void> introspect(String tokenType) {
        Promise promise = Promise.promise();
        this.introspect(tokenType, (Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }

    @Fluent
    public AccessToken userInfo(Handler<AsyncResult<JsonObject>> var1);

    default public Future<JsonObject> userInfo() {
        Promise promise = Promise.promise();
        this.userInfo((Handler<AsyncResult<JsonObject>>)promise);
        return promise.future();
    }

    @Fluent
    default public AccessToken fetch(String resource, Handler<AsyncResult<OAuth2Response>> callback) {
        return this.fetch(HttpMethod.GET, resource, null, null, callback);
    }

    default public Future<OAuth2Response> fetch(String resource) {
        Promise promise = Promise.promise();
        this.fetch(resource, (Handler<AsyncResult<OAuth2Response>>)promise);
        return promise.future();
    }

    @Fluent
    public AccessToken fetch(HttpMethod var1, String var2, JsonObject var3, Buffer var4, Handler<AsyncResult<OAuth2Response>> var5);

    default public Future<OAuth2Response> fetch(HttpMethod method, String resource, JsonObject headers, Buffer payload) {
        Promise promise = Promise.promise();
        this.fetch(method, resource, headers, payload, (Handler<AsyncResult<OAuth2Response>>)promise);
        return promise.future();
    }
}

