/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.ext.auth.oauth2.OAuth2Response;
import io.vertx.ext.auth.oauth2.impl.OAuth2ResponseImpl;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;

public class OAuth2API {
    private static final Logger LOG = LoggerFactory.getLogger(OAuth2API.class);
    private final HttpClient client;
    private final OAuth2ClientOptions config;

    public OAuth2API(Vertx vertx, OAuth2ClientOptions config) {
        this.config = config;
        this.client = vertx.createHttpClient((HttpClientOptions)config);
    }

    public void fetch(HttpMethod method, String path, JsonObject headers, Buffer payload, Handler<AsyncResult<OAuth2Response>> callback) {
        if (path == null || path.length() == 0) {
            callback.handle((Object)Future.failedFuture((String)"Invalid path"));
            return;
        }
        String url = path.charAt(0) == '/' ? this.config.getSite() + path : path;
        LOG.debug((Object)("Fetching URL: " + url));
        HttpClientRequest request = this.makeRequest(method, url, callback);
        JsonObject tmp = this.config.getHeaders();
        if (tmp != null) {
            for (Map.Entry kv : tmp) {
                request.putHeader((String)kv.getKey(), (String)kv.getValue());
            }
        }
        if (headers != null) {
            for (Map.Entry kv : headers) {
                request.putHeader((String)kv.getKey(), (String)kv.getValue());
            }
        }
        if (this.config.getUserAgent() != null) {
            request.putHeader("User-Agent", this.config.getUserAgent());
        }
        if (payload != null && (method == HttpMethod.POST || method == HttpMethod.PATCH || method == HttpMethod.PUT)) {
            request.putHeader("Content-Length", Integer.toString(payload.length()));
            request.write((Object)payload);
        }
        request.end();
    }

    public HttpClientRequest makeRequest(HttpMethod method, String uri, Handler<AsyncResult<OAuth2Response>> callback) {
        HttpClientRequest request = this.client.requestAbs(method, uri, ar -> {
            if (ar.succeeded()) {
                HttpClientResponse resp = (HttpClientResponse)ar.result();
                resp.exceptionHandler(t -> {
                    callback.handle((Object)Future.failedFuture((Throwable)t));
                    this.client.close();
                });
                resp.bodyHandler(body -> {
                    if (resp.statusCode() < 200 || resp.statusCode() >= 300) {
                        if (body == null || body.length() == 0) {
                            callback.handle((Object)Future.failedFuture((String)resp.statusMessage()));
                        } else {
                            callback.handle((Object)Future.failedFuture((String)(resp.statusMessage() + ": " + body.toString())));
                        }
                    } else {
                        callback.handle((Object)Future.succeededFuture((Object)new OAuth2ResponseImpl(resp.statusCode(), resp.headers(), (Buffer)body)));
                    }
                });
            } else {
                callback.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
        request.exceptionHandler(t -> callback.handle((Object)Future.failedFuture((Throwable)t)));
        return request;
    }

    public static String stringify(JsonObject json) {
        StringBuilder sb = new StringBuilder();
        try {
            for (Map.Entry kv : json) {
                sb.append(URLEncoder.encode((String)kv.getKey(), "UTF-8"));
                sb.append('=');
                Object v = kv.getValue();
                if (v != null) {
                    sb.append(URLEncoder.encode(v.toString(), "UTF-8"));
                }
                sb.append('&');
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static JsonObject queryToJSON(String query) throws UnsupportedEncodingException {
        String[] pairs;
        JsonObject json = new JsonObject();
        for (String pair : pairs = query.split("&")) {
            JsonArray array;
            String value;
            int idx = pair.indexOf("=");
            String key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), "UTF-8") : pair;
            String string = value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), "UTF-8") : null;
            if (!json.containsKey(key)) {
                json.put(key, value);
                continue;
            }
            Object oldValue = json.getValue(key);
            if (oldValue instanceof JsonArray) {
                array = (JsonArray)oldValue;
            } else {
                array = new JsonArray();
                array.add(oldValue);
                json.put(key, array);
            }
            if (value == null) {
                array.addNull();
                continue;
            }
            array.add(value);
        }
        return json;
    }

    public static void processNonStandardHeaders(JsonObject json, OAuth2Response reply, String sep) {
        String xOAuthScopes = reply.getHeader("X-OAuth-Scopes");
        String xAcceptedOAuthScopes = reply.getHeader("X-Accepted-OAuth-Scopes");
        if (xOAuthScopes != null) {
            LOG.trace((Object)("Received non-standard X-OAuth-Scopes: " + xOAuthScopes));
            if (json.containsKey("scope")) {
                json.put("scope", json.getString("scope") + sep + xOAuthScopes);
            } else {
                json.put("scope", xOAuthScopes);
            }
        }
        if (xAcceptedOAuthScopes != null) {
            LOG.trace((Object)("Received non-standard X-Accepted-OAuth-Scopes: " + xAcceptedOAuthScopes));
            json.put("acceptedScopes", xAcceptedOAuthScopes);
        }
    }
}

