/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.oauth2.OAuth2Response;

@VertxGen
public interface AccessToken
extends User {
    public boolean expired();

    @CacheReturn
    public JsonObject accessToken();

    @CacheReturn
    public JsonObject idToken();

    public String opaqueAccessToken();

    public String opaqueRefreshToken();

    public String opaqueIdToken();

    public String tokenType();

    @Fluent
    public AccessToken setTrustJWT(boolean var1);

    @Fluent
    public AccessToken refresh(Handler<AsyncResult<Void>> var1);

    @Fluent
    public AccessToken revoke(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public AccessToken logout(Handler<AsyncResult<Void>> var1);

    @Fluent
    public AccessToken introspect(Handler<AsyncResult<Void>> var1);

    @Fluent
    public AccessToken introspect(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public AccessToken userInfo(Handler<AsyncResult<JsonObject>> var1);

    @Fluent
    default public AccessToken fetch(String resource, Handler<AsyncResult<OAuth2Response>> callback) {
        return this.fetch(HttpMethod.GET, resource, null, null, callback);
    }

    @Fluent
    public AccessToken fetch(HttpMethod var1, String var2, JsonObject var3, Buffer var4, Handler<AsyncResult<OAuth2Response>> var5);
}

