/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.PubSecKeyOptions;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.ext.jwt.JWTOptions;
import java.util.ArrayList;
import java.util.Map;

public class OAuth2ClientOptionsConverter {
    public static void fromJson(Iterable<Map.Entry<String, Object>> json, OAuth2ClientOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "authorizationPath": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setAuthorizationPath((String)member.getValue());
                    break;
                }
                case "clientID": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setClientID((String)member.getValue());
                    break;
                }
                case "clientSecret": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setClientSecret((String)member.getValue());
                    break;
                }
                case "clientSecretParameterName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setClientSecretParameterName((String)member.getValue());
                    break;
                }
                case "extraParameters": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setExtraParameters(((JsonObject)member.getValue()).copy());
                    break;
                }
                case "flow": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setFlow(OAuth2FlowType.valueOf((String)member.getValue()));
                    break;
                }
                case "headers": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setHeaders(((JsonObject)member.getValue()).copy());
                    break;
                }
                case "introspectionPath": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setIntrospectionPath((String)member.getValue());
                    break;
                }
                case "jwkPath": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setJwkPath((String)member.getValue());
                    break;
                }
                case "jwtOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setJWTOptions(new JWTOptions((JsonObject)member.getValue()));
                    break;
                }
                case "logoutPath": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setLogoutPath((String)member.getValue());
                    break;
                }
                case "pubSecKeys": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<PubSecKeyOptions> list = new ArrayList<PubSecKeyOptions>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new PubSecKeyOptions((JsonObject)item));
                        }
                    });
                    obj.setPubSecKeys(list);
                    break;
                }
                case "revocationPath": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setRevocationPath((String)member.getValue());
                    break;
                }
                case "scopeSeparator": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setScopeSeparator((String)member.getValue());
                    break;
                }
                case "site": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setSite((String)member.getValue());
                    break;
                }
                case "tokenPath": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setTokenPath((String)member.getValue());
                    break;
                }
                case "useBasicAuthorizationHeader": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setUseBasicAuthorizationHeader((Boolean)member.getValue());
                    break;
                }
                case "userAgent": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setUserAgent((String)member.getValue());
                    break;
                }
                case "userInfoParameters": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setUserInfoParameters(((JsonObject)member.getValue()).copy());
                    break;
                }
                case "userInfoPath": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setUserInfoPath((String)member.getValue());
                    break;
                }
                case "validateIssuer": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setValidateIssuer((Boolean)member.getValue());
                }
            }
        }
    }

    public static void toJson(OAuth2ClientOptions obj, JsonObject json) {
        OAuth2ClientOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(OAuth2ClientOptions obj, Map<String, Object> json) {
        if (obj.getAuthorizationPath() != null) {
            json.put("authorizationPath", obj.getAuthorizationPath());
        }
        if (obj.getClientID() != null) {
            json.put("clientID", obj.getClientID());
        }
        if (obj.getClientSecret() != null) {
            json.put("clientSecret", obj.getClientSecret());
        }
        if (obj.getClientSecretParameterName() != null) {
            json.put("clientSecretParameterName", obj.getClientSecretParameterName());
        }
        if (obj.getExtraParameters() != null) {
            json.put("extraParameters", obj.getExtraParameters());
        }
        if (obj.getFlow() != null) {
            json.put("flow", obj.getFlow().name());
        }
        if (obj.getHeaders() != null) {
            json.put("headers", obj.getHeaders());
        }
        if (obj.getIntrospectionPath() != null) {
            json.put("introspectionPath", obj.getIntrospectionPath());
        }
        if (obj.getJwkPath() != null) {
            json.put("jwkPath", obj.getJwkPath());
        }
        if (obj.getLogoutPath() != null) {
            json.put("logoutPath", obj.getLogoutPath());
        }
        if (obj.getRevocationPath() != null) {
            json.put("revocationPath", obj.getRevocationPath());
        }
        if (obj.getScopeSeparator() != null) {
            json.put("scopeSeparator", obj.getScopeSeparator());
        }
        if (obj.getSite() != null) {
            json.put("site", obj.getSite());
        }
        if (obj.getTokenPath() != null) {
            json.put("tokenPath", obj.getTokenPath());
        }
        json.put("useBasicAuthorizationHeader", obj.isUseBasicAuthorizationHeader());
        if (obj.getUserAgent() != null) {
            json.put("userAgent", obj.getUserAgent());
        }
        if (obj.getUserInfoParameters() != null) {
            json.put("userInfoParameters", obj.getUserInfoParameters());
        }
        if (obj.getUserInfoPath() != null) {
            json.put("userInfoPath", obj.getUserInfoPath());
        }
        json.put("validateIssuer", obj.isValidateIssuer());
    }
}

