/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.ext.auth.oauth2.OAuth2Response;
import io.vertx.ext.auth.oauth2.impl.OAuth2API;
import io.vertx.ext.auth.oauth2.impl.OAuth2AuthProviderImpl;
import io.vertx.ext.auth.oauth2.impl.OAuth2UserImpl;
import java.io.UnsupportedEncodingException;
import java.util.Base64;

public class OAuth2TokenImpl
extends OAuth2UserImpl {
    private static final Logger LOG = LoggerFactory.getLogger(OAuth2TokenImpl.class);

    public OAuth2TokenImpl() {
    }

    public OAuth2TokenImpl(OAuth2Auth provider, JsonObject token) {
        super(provider, token);
    }

    @Override
    public AccessToken setTrustJWT(boolean trust) {
        this.accessToken = this.decodeToken("access_token", trust);
        this.refreshToken = this.decodeToken("refresh_token", trust);
        this.idToken = this.decodeToken("id_token", trust);
        return this;
    }

    @Override
    public String tokenType() {
        return this.principal().getString("token_type");
    }

    @Override
    public OAuth2TokenImpl refresh(Handler<AsyncResult<Void>> handler) {
        LOG.info((Object)"Refreshing AccessToken");
        JsonObject headers = new JsonObject();
        OAuth2AuthProviderImpl provider = this.getProvider();
        OAuth2ClientOptions config = provider.getConfig();
        JsonObject tmp = config.getHeaders();
        if (tmp != null) {
            headers.mergeIn(tmp);
        }
        JsonObject form = new JsonObject();
        form.put("grant_type", "refresh_token").put("refresh_token", this.opaqueRefreshToken()).put("client_id", config.getClientID());
        if (config.getClientSecretParameterName() != null) {
            form.put(config.getClientSecretParameterName(), config.getClientSecret());
        }
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        Buffer payload = Buffer.buffer((String)OAuth2API.stringify(form));
        headers.put("Accept", "application/json,application/x-www-form-urlencoded;q=0.9");
        OAuth2API.fetch(provider.getVertx(), config, HttpMethod.POST, config.getTokenPath(), headers, payload, (Handler<AsyncResult<OAuth2Response>>)((Handler)res -> {
            block17: {
                JsonObject json;
                if (res.failed()) {
                    handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
                    return;
                }
                OAuth2Response reply = (OAuth2Response)res.result();
                if (reply.body() == null || reply.body().length() == 0) {
                    handler.handle((Object)Future.failedFuture((String)"No Body"));
                    return;
                }
                if (reply.is("application/json")) {
                    try {
                        json = reply.jsonObject();
                    }
                    catch (RuntimeException e) {
                        handler.handle((Object)Future.failedFuture((Throwable)e));
                        return;
                    }
                } else if (reply.is("application/x-www-form-urlencoded") || reply.is("text/plain")) {
                    try {
                        json = OAuth2API.queryToJSON(reply.body().toString());
                    }
                    catch (UnsupportedEncodingException | RuntimeException e) {
                        handler.handle((Object)Future.failedFuture((Throwable)e));
                        return;
                    }
                } else {
                    handler.handle((Object)Future.failedFuture((String)("Cannot handle accessToken type: " + reply.headers().get("Content-Type"))));
                    return;
                }
                try {
                    if (json.containsKey("error")) {
                        String description;
                        Object error = json.getValue("error");
                        if (error instanceof JsonObject) {
                            description = ((JsonObject)error).getString("message");
                        } else {
                            try {
                                description = json.getString("error_description", json.getString("error"));
                            }
                            catch (RuntimeException e) {
                                description = error.toString();
                            }
                        }
                        handler.handle((Object)Future.failedFuture((String)description));
                        break block17;
                    }
                    OAuth2API.processNonStandardHeaders(json, reply, config.getScopeSeparator());
                    LOG.debug((Object)"Got new AccessToken");
                    this.init(json);
                    handler.handle((Object)Future.succeededFuture());
                }
                catch (RuntimeException e) {
                    handler.handle((Object)Future.failedFuture((Throwable)e));
                }
            }
        }));
        return this;
    }

    @Override
    public OAuth2TokenImpl revoke(String token_type, Handler<AsyncResult<Void>> handler) {
        OAuth2AuthProviderImpl provider = this.getProvider();
        OAuth2ClientOptions config = provider.getConfig();
        String tokenValue = this.principal().getString(token_type);
        if (tokenValue != null) {
            JsonObject headers = new JsonObject();
            JsonObject tmp = config.getHeaders();
            if (tmp != null) {
                headers.mergeIn(tmp);
            }
            JsonObject form = new JsonObject();
            form.put("token", tokenValue).put("token_type_hint", token_type);
            headers.put("Content-Type", "application/x-www-form-urlencoded");
            Buffer payload = Buffer.buffer((String)OAuth2API.stringify(form));
            headers.put("Accept", "application/json,application/x-www-form-urlencoded;q=0.9");
            OAuth2API.fetch(provider.getVertx(), config, HttpMethod.POST, config.getRevocationPath(), headers, payload, (Handler<AsyncResult<OAuth2Response>>)((Handler)res -> {
                if (res.failed()) {
                    handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
                    return;
                }
                OAuth2Response reply = (OAuth2Response)res.result();
                if (reply.body() == null) {
                    handler.handle((Object)Future.failedFuture((String)"No Body"));
                    return;
                }
                this.principal().remove(token_type);
                this.init(this.principal());
                handler.handle((Object)Future.succeededFuture());
            }));
        } else {
            handler.handle((Object)Future.failedFuture((String)("Invalid token: " + token_type)));
        }
        return this;
    }

    @Override
    public OAuth2TokenImpl logout(Handler<AsyncResult<Void>> callback) {
        String refreshToken;
        OAuth2AuthProviderImpl provider = this.getProvider();
        OAuth2ClientOptions config = provider.getConfig();
        JsonObject headers = new JsonObject();
        headers.put("Authorization", "Bearer " + this.opaqueAccessToken());
        JsonObject tmp = config.getHeaders();
        if (tmp != null) {
            headers.mergeIn(tmp);
        }
        JsonObject form = new JsonObject();
        form.put("client_id", config.getClientID());
        if (config.getClientSecretParameterName() != null && config.getClientSecret() != null) {
            form.put(config.getClientSecretParameterName(), config.getClientSecret());
        }
        if ((refreshToken = this.opaqueRefreshToken()) != null) {
            form.put("refresh_token", this.opaqueRefreshToken());
        }
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        Buffer payload = Buffer.buffer((String)OAuth2API.stringify(form));
        headers.put("Accept", "application/json,application/x-www-form-urlencoded;q=0.9");
        OAuth2API.fetch(provider.getVertx(), config, HttpMethod.POST, config.getLogoutPath(), headers, payload, (Handler<AsyncResult<OAuth2Response>>)((Handler)res -> {
            if (res.succeeded()) {
                this.init(null);
                callback.handle((Object)Future.succeededFuture());
            } else {
                callback.handle((Object)Future.failedFuture((Throwable)res.cause()));
            }
        }));
        return this;
    }

    @Override
    public AccessToken introspect(String tokenType, Handler<AsyncResult<Void>> handler) {
        JsonObject tmp;
        JsonObject headers = new JsonObject();
        OAuth2AuthProviderImpl provider = this.getProvider();
        OAuth2ClientOptions config = provider.getConfig();
        if (config.isUseBasicAuthorizationHeader()) {
            String basic = config.getClientID() + ":" + (config.getClientSecret() == null ? "" : config.getClientSecret());
            headers.put("Authorization", "Basic " + Base64.getEncoder().encodeToString(basic.getBytes()));
        }
        if ((tmp = config.getHeaders()) != null) {
            headers.mergeIn(tmp);
        }
        JsonObject form = new JsonObject().put("token", this.principal().getString(tokenType)).put("token_type_hint", tokenType);
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        Buffer payload = Buffer.buffer((String)OAuth2API.stringify(form));
        headers.put("Accept", "application/json,application/x-www-form-urlencoded;q=0.9");
        OAuth2API.fetch(provider.getVertx(), config, HttpMethod.POST, config.getIntrospectionPath(), headers, payload, (Handler<AsyncResult<OAuth2Response>>)((Handler)res -> {
            block34: {
                JsonObject json;
                if (res.failed()) {
                    handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
                    return;
                }
                OAuth2Response reply = (OAuth2Response)res.result();
                if (reply.body() == null || reply.body().length() == 0) {
                    handler.handle((Object)Future.failedFuture((String)"No Body"));
                    return;
                }
                if (reply.is("application/json")) {
                    try {
                        json = reply.jsonObject();
                    }
                    catch (RuntimeException e) {
                        handler.handle((Object)Future.failedFuture((Throwable)e));
                        return;
                    }
                } else if (reply.is("application/x-www-form-urlencoded") || reply.is("text/plain")) {
                    try {
                        json = OAuth2API.queryToJSON(reply.body().toString());
                    }
                    catch (UnsupportedEncodingException | RuntimeException e) {
                        handler.handle((Object)Future.failedFuture((Throwable)e));
                        return;
                    }
                } else {
                    handler.handle((Object)Future.failedFuture((String)("Cannot handle accessToken type: " + reply.headers().get("Content-Type"))));
                    return;
                }
                try {
                    if (json.containsKey("error")) {
                        String description;
                        Object error = json.getValue("error");
                        if (error instanceof JsonObject) {
                            description = ((JsonObject)error).getString("message");
                        } else {
                            try {
                                description = json.getString("error_description", json.getString("error"));
                            }
                            catch (RuntimeException e) {
                                description = error.toString();
                            }
                        }
                        handler.handle((Object)Future.failedFuture((String)description));
                        break block34;
                    }
                    if (json.containsKey("active") && !json.getBoolean("active", Boolean.valueOf(false)).booleanValue()) {
                        handler.handle((Object)Future.failedFuture((String)"Inactive Token"));
                        return;
                    }
                    if (json.containsKey("scope") && json.getString("scope") != null) {
                        this.principal().put("scope", json.getString("scope"));
                    }
                    if (json.containsKey("client_id")) {
                        if (this.principal().containsKey("client_id")) {
                            if (!json.getString("client_id", "").equals(this.principal().getString("client_id"))) {
                                handler.handle((Object)Future.failedFuture((String)"Wrong client_id"));
                                return;
                            }
                        } else {
                            this.principal().put("client_id", json.getString("client_id"));
                        }
                    }
                    if (json.containsKey("username")) {
                        this.principal().put("username", json.getString("username"));
                    }
                    if (json.containsKey("token_type")) {
                        if (this.principal().containsKey("token_type")) {
                            if (!json.getString("token_type", "").equalsIgnoreCase(this.principal().getString("token_type"))) {
                                handler.handle((Object)Future.failedFuture((String)"Wrong token_type"));
                                return;
                            }
                        } else {
                            this.principal().put("token_type", json.getString("token_type"));
                        }
                    }
                    try {
                        Long iat;
                        OAuth2API.processNonStandardHeaders(json, reply, config.getScopeSeparator());
                        if (json.containsKey("expires_in")) {
                            this.principal().put("expires_in", json.getValue("expires_in")).remove("expires_at");
                        }
                        long now = System.currentTimeMillis() / 1000L;
                        if (json.containsKey("iat") && (iat = json.getLong("iat")) > now + (long)config.getJWTOptions().getLeeway()) {
                            handler.handle((Object)Future.failedFuture((String)"Invalid token: iat > now"));
                            return;
                        }
                        if (json.containsKey("exp")) {
                            Long exp = json.getLong("exp");
                            if (now - (long)config.getJWTOptions().getLeeway() >= exp) {
                                handler.handle((Object)Future.failedFuture((String)"Invalid token: exp <= now"));
                                return;
                            }
                            this.principal().put("expires_in", Long.valueOf(exp - now)).remove("expires_at");
                        }
                        this.init(this.principal());
                        handler.handle((Object)Future.succeededFuture());
                    }
                    catch (RuntimeException e) {
                        handler.handle((Object)Future.failedFuture((Throwable)e));
                    }
                }
                catch (RuntimeException e) {
                    handler.handle((Object)Future.failedFuture((Throwable)e));
                }
            }
        }));
        return this;
    }

    @Override
    public AccessToken introspect(Handler<AsyncResult<Void>> handler) {
        return this.introspect("access_token", handler);
    }

    @Override
    public AccessToken userInfo(Handler<AsyncResult<JsonObject>> callback) {
        JsonObject headers = new JsonObject();
        OAuth2AuthProviderImpl provider = this.getProvider();
        OAuth2ClientOptions config = provider.getConfig();
        JsonObject extraParams = config.getUserInfoParameters();
        String path = config.getUserInfoPath();
        if (extraParams != null) {
            path = path + "?" + OAuth2API.stringify(extraParams);
        }
        headers.put("Authorization", "Bearer " + this.opaqueAccessToken());
        headers.put("Accept", "application/json,application/x-www-form-urlencoded;q=0.9");
        OAuth2API.fetch(provider.getVertx(), config, HttpMethod.GET, path, headers, null, (Handler<AsyncResult<OAuth2Response>>)((Handler)fetch -> {
            JsonObject userInfo;
            if (fetch.failed()) {
                callback.handle((Object)Future.failedFuture((Throwable)fetch.cause()));
                return;
            }
            OAuth2Response reply = (OAuth2Response)fetch.result();
            if (reply.is("application/json")) {
                try {
                    userInfo = reply.jsonObject();
                }
                catch (RuntimeException e) {
                    callback.handle((Object)Future.failedFuture((Throwable)e));
                    return;
                }
            } else if (reply.is("application/x-www-form-urlencoded") || reply.is("text/plain")) {
                try {
                    userInfo = OAuth2API.queryToJSON(reply.body().toString());
                }
                catch (UnsupportedEncodingException | RuntimeException e) {
                    callback.handle((Object)Future.failedFuture((Throwable)e));
                    return;
                }
            } else {
                callback.handle((Object)Future.failedFuture((String)("Cannot handle Content-Type: " + reply.headers().get("Content-Type"))));
                return;
            }
            OAuth2API.processNonStandardHeaders(this.principal(), reply, config.getScopeSeparator());
            this.init(this.principal());
            callback.handle((Object)Future.succeededFuture((Object)userInfo));
        }));
        return this;
    }

    @Override
    public AccessToken fetch(HttpMethod method, String resource, JsonObject headers, Buffer payload, Handler<AsyncResult<OAuth2Response>> callback) {
        OAuth2AuthProviderImpl provider = this.getProvider();
        OAuth2ClientOptions config = provider.getConfig();
        if (headers == null) {
            headers = new JsonObject();
        }
        headers.put("Authorization", "Bearer " + this.opaqueAccessToken());
        OAuth2API.fetch(provider.getVertx(), config, method, resource, headers, payload, (Handler<AsyncResult<OAuth2Response>>)((Handler)fetch -> {
            if (fetch.failed()) {
                callback.handle((Object)Future.failedFuture((Throwable)fetch.cause()));
                return;
            }
            callback.handle((Object)Future.succeededFuture((Object)fetch.result()));
        }));
        return this;
    }
}

