/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.ext.auth.oauth2.impl.OAuth2API;
import io.vertx.ext.auth.oauth2.impl.crypto.TokenVerifier;
import io.vertx.ext.auth.oauth2.impl.flow.AuthCodeImpl;
import io.vertx.ext.auth.oauth2.impl.flow.ClientImpl;
import io.vertx.ext.auth.oauth2.impl.flow.OAuth2Flow;
import io.vertx.ext.auth.oauth2.impl.flow.PasswordImpl;

public class OAuth2AuthProviderImpl
implements OAuth2Auth {
    private final Vertx vertx;
    private final OAuth2ClientOptions config;
    private final TokenVerifier verifier;
    private final OAuth2Flow flow;

    public OAuth2AuthProviderImpl(Vertx vertx, OAuth2FlowType flow, OAuth2ClientOptions config) {
        this.vertx = vertx;
        this.config = config;
        this.verifier = new TokenVerifier(config.getPublicKey());
        switch (flow) {
            case AUTH_CODE: {
                this.flow = new AuthCodeImpl(this);
                break;
            }
            case CLIENT: {
                this.flow = new ClientImpl(this);
                break;
            }
            case PASSWORD: {
                this.flow = new PasswordImpl(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid oauth2 flow type: " + (Object)((Object)flow));
            }
        }
    }

    public OAuth2ClientOptions getConfig() {
        return this.config;
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public TokenVerifier getVerifier() {
        return this.verifier;
    }

    public void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> resultHandler) {
    }

    @Override
    public String authorizeURL(JsonObject params) {
        return this.flow.authorizeURL(params);
    }

    @Override
    public void getToken(JsonObject params, Handler<AsyncResult<AccessToken>> handler) {
        this.flow.getToken(params, handler);
    }

    @Override
    public OAuth2Auth api(HttpMethod method, String path, JsonObject params, Handler<AsyncResult<JsonObject>> handler) {
        OAuth2API.api(this, method, path, params, handler);
        return this;
    }

    @Override
    public boolean hasJWTToken() {
        return this.config.isJwtToken();
    }
}

