/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.auth.AbstractUser;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.auth.oauth2.impl.OAuth2API;
import io.vertx.ext.auth.oauth2.impl.OAuth2AuthProviderImpl;
import java.nio.charset.StandardCharsets;

public class AccessTokenImpl
extends AbstractUser
implements AccessToken {
    private static final Logger log = LoggerFactory.getLogger(AccessTokenImpl.class);
    private Vertx vertx;
    private JsonObject config;
    private JsonObject token;

    public AccessTokenImpl() {
        log.info((Object)"You are probably serializing the OAuth2 User, OAuth2 tokens are supposed to be used in stateless servers!");
    }

    public AccessTokenImpl(Vertx vertx, JsonObject config, JsonObject token) {
        this.vertx = vertx;
        this.config = config;
        this.init(token);
    }

    private void init(JsonObject token) {
        if (token.containsKey("expires_in")) {
            token = token.copy();
            token.put("expires_at", Long.valueOf(System.currentTimeMillis() + 1000L * token.getLong("expires_in")));
        }
        this.token = token;
    }

    @Override
    public boolean expired() {
        return this.token.containsKey("expires_at") && this.token.getLong("expires_at", Long.valueOf(0L)) < System.currentTimeMillis();
    }

    @Override
    public AccessTokenImpl refresh(Handler<AsyncResult<Void>> callback) {
        JsonObject params = new JsonObject().put("grant_type", "refresh_token").put("refresh_token", this.token.getString("refresh_token"));
        OAuth2API.api(this.vertx, this.config, HttpMethod.POST, this.config.getString("tokenPath"), params, (Handler<AsyncResult<JsonObject>>)((Handler)res -> {
            if (res.succeeded()) {
                this.init((JsonObject)res.result());
                callback.handle((Object)Future.succeededFuture());
            } else {
                callback.handle((Object)Future.failedFuture((Throwable)res.cause()));
            }
        }));
        return this;
    }

    @Override
    public AccessTokenImpl revoke(String token_type, Handler<AsyncResult<Void>> callback) {
        String token = "access_token".equals(token_type) ? this.token.getString("access_token") : this.token.getString("refresh_token");
        JsonObject params = new JsonObject().put("token", token).put("token_type_hint", token_type);
        OAuth2API.api(this.vertx, this.config, HttpMethod.POST, this.config.getString("revocationPath"), params, (Handler<AsyncResult<JsonObject>>)((Handler)res -> {
            if (res.succeeded()) {
                callback.handle((Object)Future.succeededFuture());
            } else {
                callback.handle((Object)Future.failedFuture((Throwable)res.cause()));
            }
        }));
        return this;
    }

    protected void doIsPermitted(String permission, Handler<AsyncResult<Boolean>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture((Object)true));
    }

    public JsonObject principal() {
        return this.token;
    }

    public void setAuthProvider(AuthProvider authProvider) {
        OAuth2AuthProviderImpl provider = (OAuth2AuthProviderImpl)authProvider;
        this.vertx = provider.getVertx();
        this.config = provider.getConfig();
    }

    public void writeToBuffer(Buffer buff) {
        super.writeToBuffer(buff);
        byte[] bytes = this.token.encode().getBytes(StandardCharsets.UTF_8);
        buff.appendInt(bytes.length);
        buff.appendBytes(bytes);
    }

    public int readFromBuffer(int pos, Buffer buffer) {
        pos = super.readFromBuffer(pos, buffer);
        int len = buffer.getInt(pos);
        byte[] bytes = buffer.getBytes(pos += 4, pos + len);
        this.token = new JsonObject(new String(bytes, StandardCharsets.UTF_8));
        return pos += len;
    }
}

