/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.ldap.impl;

import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.CredentialValidationException;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import io.vertx.ext.auth.ldap.LdapAuthentication;
import io.vertx.ext.auth.ldap.LdapAuthenticationOptions;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Objects;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;

public class LdapAuthenticationImpl
implements LdapAuthentication {
    private static final String SIMPLE_AUTHENTICATION_MECHANISM = "simple";
    private static final String FOLLOW_REFERRAL = "follow";
    private final Vertx vertx;
    private final LdapAuthenticationOptions authenticationOptions;

    public LdapAuthenticationImpl(Vertx vertx, LdapAuthenticationOptions authenticationOptions) {
        this.vertx = Objects.requireNonNull(vertx);
        this.authenticationOptions = Objects.requireNonNull(authenticationOptions);
    }

    public Future<User> authenticate(Credentials credentials) {
        UsernamePasswordCredentials authInfo;
        try {
            try {
                authInfo = (UsernamePasswordCredentials)credentials;
            }
            catch (ClassCastException e) {
                throw new CredentialValidationException("Invalid credentials type", (Throwable)e);
            }
            authInfo.checkValid(null);
        }
        catch (RuntimeException e) {
            return Future.failedFuture((Throwable)e);
        }
        String ldapPrincipal = this.getLdapPrincipal(authInfo.getUsername());
        return this.createLdapContext(ldapPrincipal, authInfo.getPassword()).compose(ldapContext -> {
            User user = User.fromName((String)authInfo.getUsername());
            user.principal().put("amr", Collections.singletonList("pwd"));
            return Future.succeededFuture((Object)user);
        });
    }

    private Future<LdapContext> createLdapContext(String principal, String credential) {
        Hashtable<String, String> environment = new Hashtable<String, String>();
        environment.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        environment.put("java.naming.provider.url", this.authenticationOptions.getUrl());
        if (principal != null) {
            environment.put("java.naming.security.principal", principal);
        }
        if (credential != null) {
            environment.put("java.naming.security.credentials", credential);
        }
        if (this.authenticationOptions.getAuthenticationMechanism() == null && (principal != null || credential != null)) {
            environment.put("java.naming.security.authentication", SIMPLE_AUTHENTICATION_MECHANISM);
        }
        environment.put("java.naming.referral", this.authenticationOptions.getReferral() == null ? FOLLOW_REFERRAL : this.authenticationOptions.getReferral());
        PromiseInternal promise = ((VertxInternal)this.vertx).promise();
        this.vertx.executeBlocking(() -> new InitialLdapContext(environment, null)).onComplete((Completable)promise);
        return promise.future();
    }

    private String getLdapPrincipal(String principal) {
        return this.authenticationOptions.getAuthenticationQuery().replace("{0}", principal);
    }
}

