/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.ldap.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.ldap.LdapAuthentication;
import io.vertx.ext.auth.ldap.LdapAuthenticationOptions;
import java.util.Hashtable;
import java.util.Objects;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;

public class LdapAuthenticationImpl
implements LdapAuthentication {
    private static final String SIMPLE_AUTHENTICATION_MECHANISM = "simple";
    private static final String FOLLOW_REFERRAL = "follow";
    private Vertx vertx;
    private LdapAuthenticationOptions authenticationOptions;

    public LdapAuthenticationImpl(Vertx vertx, LdapAuthenticationOptions authenticationOptions) {
        this.vertx = Objects.requireNonNull(vertx);
        this.authenticationOptions = Objects.requireNonNull(authenticationOptions);
    }

    public void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> resultHandler) {
        String principal = authInfo.getString("username");
        String credential = authInfo.getString("password");
        String ldapPrincipal = this.getLdapPrincipal(principal);
        this.createLdapContext(ldapPrincipal, credential, (Handler<AsyncResult<LdapContext>>)((Handler)contextResponse -> {
            if (contextResponse.succeeded()) {
                User user = User.create((JsonObject)new JsonObject().put("username", (Object)principal));
                resultHandler.handle((Object)Future.succeededFuture((Object)user));
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)contextResponse.cause()));
            }
        }));
    }

    private void createLdapContext(String principal, String credential, Handler<AsyncResult<LdapContext>> resultHandler) {
        Hashtable<String, String> environment = new Hashtable<String, String>();
        environment.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        environment.put("java.naming.provider.url", this.authenticationOptions.getUrl());
        if (principal != null) {
            environment.put("java.naming.security.principal", principal);
        }
        if (credential != null) {
            environment.put("java.naming.security.credentials", credential);
        }
        if (this.authenticationOptions.getAuthenticationMechanism() == null && (principal != null || credential != null)) {
            environment.put("java.naming.security.authentication", SIMPLE_AUTHENTICATION_MECHANISM);
        }
        environment.put("java.naming.referral", this.authenticationOptions.getReferral() == null ? FOLLOW_REFERRAL : this.authenticationOptions.getReferral());
        this.vertx.executeBlocking(blockingResult -> {
            try {
                InitialLdapContext context = new InitialLdapContext(environment, null);
                blockingResult.complete((Object)context);
            }
            catch (Throwable t) {
                blockingResult.fail(t);
            }
        }, resultHandler);
    }

    private String getLdapPrincipal(String principal) {
        return this.authenticationOptions.getAuthenticationQuery().replace("{0}", principal);
    }
}

