/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jwt.impl;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileSystemException;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.JWTOptions;
import io.vertx.ext.auth.KeyStoreOptions;
import io.vertx.ext.auth.PubSecKeyOptions;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.CredentialValidationException;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.TokenCredentials;
import io.vertx.ext.auth.impl.jose.JWK;
import io.vertx.ext.auth.impl.jose.JWT;
import io.vertx.ext.auth.jwt.JWTAuth;
import io.vertx.ext.auth.jwt.JWTAuthOptions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JWTAuthProviderImpl
implements JWTAuth {
    private static final Logger LOG = LoggerFactory.getLogger(JWTAuthProviderImpl.class);
    private static final JsonArray EMPTY_ARRAY = new JsonArray(Collections.emptyList());
    private final JWT jwt = new JWT();
    private final JWTOptions jwtOptions;
    private static final Collection<String> SPECIAL_KEYS = Arrays.asList("access_token", "exp", "iat", "nbf");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public JWTAuthProviderImpl(Vertx vertx, JWTAuthOptions config) {
        this.jwtOptions = config.getJWTOptions();
        this.jwt.nonceAlgorithm(this.jwtOptions.getNonceAlgorithm());
        KeyStoreOptions keyStore = config.getKeyStore();
        try {
            List<JsonObject> jwks;
            List<PubSecKeyOptions> keys;
            if (keyStore != null) {
                KeyStore ks = keyStore.getProvider() == null ? KeyStore.getInstance(keyStore.getType()) : KeyStore.getInstance(keyStore.getType(), keyStore.getProvider());
                Iterator iterator = JWTAuthProviderImpl.class;
                // MONITORENTER : io.vertx.ext.auth.jwt.impl.JWTAuthProviderImpl.class
                String path = keyStore.getPath();
                if (path != null) {
                    Buffer keystore = vertx.fileSystem().readFileBlocking(keyStore.getPath());
                    try (ByteArrayInputStream in = new ByteArrayInputStream(keystore.getBytes());){
                        ks.load(in, keyStore.getPassword().toCharArray());
                    }
                } else {
                    ks.load(null, keyStore.getPassword().toCharArray());
                }
                // MONITOREXIT : iterator
                for (JWK key : JWK.load((KeyStore)ks, (String)keyStore.getPassword(), (Map)keyStore.getPasswordProtection())) {
                    this.jwt.addJWK(key);
                }
            }
            if ((keys = config.getPubSecKeys()) != null) {
                for (PubSecKeyOptions pubSecKey : config.getPubSecKeys()) {
                    this.jwt.addJWK(new JWK(pubSecKey));
                }
            }
            if ((jwks = config.getJwks()) == null) return;
            Iterator<JsonObject> iterator = jwks.iterator();
            while (iterator.hasNext()) {
                JsonObject jwk = iterator.next();
                try {
                    this.jwt.addJWK(new JWK(jwk));
                }
                catch (Exception e) {
                    LOG.warn((Object)"Unsupported JWK", (Throwable)e);
                }
            }
            return;
        }
        catch (FileSystemException | IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    public Future<User> authenticate(Credentials credentials) {
        JsonObject payload;
        TokenCredentials authInfo;
        try {
            try {
                authInfo = (TokenCredentials)credentials;
            }
            catch (ClassCastException e) {
                throw new CredentialValidationException("Invalid credentials type", (Throwable)e);
            }
            authInfo.checkValid(null);
        }
        catch (RuntimeException e) {
            return Future.failedFuture((Throwable)e);
        }
        try {
            payload = this.jwt.decode(authInfo.getToken());
        }
        catch (RuntimeException | SignatureException e) {
            return Future.failedFuture((Throwable)e);
        }
        if (this.jwtOptions.getAudience() != null) {
            JsonArray target = payload.getValue("aud") instanceof String ? new JsonArray().add(payload.getValue("aud", (Object)"")) : payload.getJsonArray("aud", EMPTY_ARRAY);
            if (Collections.disjoint(this.jwtOptions.getAudience(), target.getList())) {
                return Future.failedFuture((String)("Invalid JWT audience. expected: " + Json.encode((Object)this.jwtOptions.getAudience())));
            }
        }
        if (this.jwtOptions.getIssuer() != null && !this.jwtOptions.getIssuer().equals(payload.getString("iss"))) {
            return Future.failedFuture((String)"Invalid JWT issuer");
        }
        User user = this.createUser(authInfo.getToken(), payload);
        if (user.expired(this.jwtOptions.getLeeway()) && !this.jwtOptions.isIgnoreExpiration()) {
            return Future.failedFuture((String)"Invalid JWT token: token expired.");
        }
        return Future.succeededFuture((Object)user);
    }

    @Override
    public String generateToken(JsonObject claims, JWTOptions options) {
        return this.jwt.sign(claims, options);
    }

    @Override
    public String generateToken(JsonObject claims) {
        return this.generateToken(claims, this.jwtOptions);
    }

    private User createUser(String accessToken, JsonObject jwtToken) {
        User result = User.fromToken((String)accessToken);
        if (jwtToken.containsKey("amr")) {
            result.principal().put("amr", jwtToken.getValue("amr"));
        }
        result.attributes().put("accessToken", (Object)jwtToken);
        JWTAuthProviderImpl.copyProperties(jwtToken, result.attributes(), "exp", "iat", "nbf", "sub");
        for (String key : jwtToken.fieldNames()) {
            if (SPECIAL_KEYS.contains(key)) continue;
            result.principal().put(key, jwtToken.getValue(key));
        }
        result.attributes().put("rootClaim", (Object)"accessToken");
        return result;
    }

    private static void copyProperties(JsonObject source, JsonObject target, String ... keys) {
        if (source != null && target != null) {
            for (String key : keys) {
                if (!source.containsKey(key) || target.containsKey(key)) continue;
                target.put(key, source.getValue(key));
            }
        }
    }
}

