/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jwt;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.JWTOptions;
import io.vertx.ext.auth.KeyStoreOptions;
import io.vertx.ext.auth.PubSecKeyOptions;
import io.vertx.ext.auth.jwt.JWTAuthOptions;
import java.util.ArrayList;
import java.util.Map;

public class JWTAuthOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, JWTAuthOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "keyStore": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setKeyStore(new KeyStoreOptions((JsonObject)member.getValue()));
                    break;
                }
                case "pubSecKeys": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<PubSecKeyOptions> list = new ArrayList<PubSecKeyOptions>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new PubSecKeyOptions((JsonObject)item));
                        }
                    });
                    obj.setPubSecKeys(list);
                    break;
                }
                case "jwtOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setJWTOptions(new JWTOptions((JsonObject)member.getValue()));
                    break;
                }
                case "jwks": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<PubSecKeyOptions> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add((PubSecKeyOptions)((JsonObject)item).copy());
                        }
                    });
                    obj.setJwks(list);
                }
            }
        }
    }

    static void toJson(JWTAuthOptions obj, JsonObject json) {
        JWTAuthOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(JWTAuthOptions obj, Map<String, Object> json) {
        JsonArray array;
        if (obj.getPubSecKeys() != null) {
            array = new JsonArray();
            obj.getPubSecKeys().forEach(item -> array.add((Object)item.toJson()));
            json.put("pubSecKeys", array);
        }
        if (obj.getJWTOptions() != null) {
            json.put("jwtOptions", obj.getJWTOptions().toJson());
        }
        if (obj.getJwks() != null) {
            array = new JsonArray();
            obj.getJwks().forEach(item -> array.add(item));
            json.put("jwks", array);
        }
    }
}

