/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jwt.authorization.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.RoleBasedAuthorization;
import io.vertx.ext.auth.jwt.authorization.MicroProfileAuthorization;
import java.util.HashSet;

public class MicroProfileAuthorizationImpl
implements MicroProfileAuthorization {
    public String getId() {
        return "mp-jwt";
    }

    public void getAuthorizations(User user, Handler<AsyncResult<Void>> handler) {
        JsonObject accessToken;
        String rootClaim = user.attributes().getString("rootClaim");
        JsonObject jsonObject = accessToken = rootClaim == null ? user.attributes().getJsonObject("accessToken") : user.attributes().getJsonObject("accessToken").getJsonObject(rootClaim);
        if (accessToken == null) {
            handler.handle((Object)Future.failedFuture((String)"User doesn't contain a decoded Token"));
            return;
        }
        HashSet<RoleBasedAuthorization> authorizations = new HashSet<RoleBasedAuthorization>();
        JsonArray groups = accessToken.getJsonArray("groups");
        if (groups != null && groups.size() >= 0) {
            for (Object el : groups) {
                if (el instanceof String) {
                    authorizations.add(RoleBasedAuthorization.create((String)((String)el)));
                    continue;
                }
                handler.handle((Object)Future.failedFuture((String)("Cannot parse role: " + el)));
                return;
            }
        }
        user.authorizations().add(this.getId(), authorizations);
        handler.handle((Object)Future.succeededFuture());
    }
}

