/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jwt;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.JWTOptions;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.jwt.JWTAuthOptions;
import io.vertx.ext.auth.jwt.JWTCredentials;
import io.vertx.ext.auth.jwt.impl.JWTAuthProviderImpl;

@VertxGen
public interface JWTAuth
extends AuthenticationProvider {
    public static JWTAuth create(Vertx vertx, JWTAuthOptions config) {
        return new JWTAuthProviderImpl(vertx, config);
    }

    public void authenticate(JWTCredentials var1, Handler<AsyncResult<User>> var2);

    default public Future<User> authenticate(JWTCredentials credentials) {
        Promise promise = Promise.promise();
        this.authenticate(credentials, (Handler<AsyncResult<User>>)promise);
        return promise.future();
    }

    public String generateToken(JsonObject var1, JWTOptions var2);

    default public String generateToken(JsonObject claims) {
        return this.generateToken(claims, new JWTOptions());
    }
}

