/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jwt.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileSystemException;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.KeyStoreOptions;
import io.vertx.ext.auth.PubSecKeyOptions;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.PermissionBasedAuthorization;
import io.vertx.ext.auth.jwt.JWTAuth;
import io.vertx.ext.auth.jwt.JWTAuthOptions;
import io.vertx.ext.jwt.JWK;
import io.vertx.ext.jwt.JWT;
import io.vertx.ext.jwt.JWTOptions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.List;

public class JWTAuthProviderImpl
implements JWTAuth {
    private static final JsonArray EMPTY_ARRAY = new JsonArray();
    private final JWT jwt = new JWT();
    private final String permissionsClaimKey;
    private final JWTOptions jwtOptions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JWTAuthProviderImpl(Vertx vertx, JWTAuthOptions config) {
        this.permissionsClaimKey = config.getPermissionsClaimKey();
        this.jwtOptions = config.getJWTOptions();
        KeyStoreOptions keyStore = config.getKeyStore();
        try {
            List<JsonObject> jwks;
            if (keyStore != null) {
                KeyStore ks = KeyStore.getInstance(keyStore.getType());
                Class<JWTAuthProviderImpl> clazz = JWTAuthProviderImpl.class;
                synchronized (JWTAuthProviderImpl.class) {
                    Buffer keystore = vertx.fileSystem().readFileBlocking(keyStore.getPath());
                    try (ByteArrayInputStream in = new ByteArrayInputStream(keystore.getBytes());){
                        ks.load(in, keyStore.getPassword().toCharArray());
                    }
                    // ** MonitorExit[var5_7] (shouldn't be in output)
                    for (JWK key : JWK.from((KeyStore)ks, (char[])keyStore.getPassword().toCharArray())) {
                        this.jwt.addJWK(key);
                    }
                    return;
                }
            }
            List<PubSecKeyOptions> keys = config.getPubSecKeys();
            if (keys != null) {
                for (PubSecKeyOptions pubSecKey : config.getPubSecKeys()) {
                    this.jwt.addJWK(JWK.from((PubSecKeyOptions)pubSecKey));
                }
            }
            if ((jwks = config.getJwks()) == null) return;
            for (JsonObject jwk : jwks) {
                this.jwt.addJWK(new JWK(jwk));
            }
            return;
        }
        catch (FileSystemException | IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    public void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> resultHandler) {
        try {
            JsonObject payload = this.jwt.decode(authInfo.getString("jwt"));
            if (this.jwt.isExpired(payload, this.jwtOptions)) {
                resultHandler.handle((Object)Future.failedFuture((String)"Expired JWT token."));
                return;
            }
            if (this.jwtOptions.getAudience() != null) {
                JsonArray target = payload.getValue("aud") instanceof String ? new JsonArray().add(payload.getValue("aud", (Object)"")) : payload.getJsonArray("aud", EMPTY_ARRAY);
                if (Collections.disjoint(this.jwtOptions.getAudience(), target.getList())) {
                    resultHandler.handle((Object)Future.failedFuture((String)("Invalid JWT audient. expected: " + Json.encode((Object)this.jwtOptions.getAudience()))));
                    return;
                }
            }
            if (this.jwtOptions.getIssuer() != null && !this.jwtOptions.getIssuer().equals(payload.getString("iss"))) {
                resultHandler.handle((Object)Future.failedFuture((String)"Invalid JWT issuer"));
                return;
            }
            if (!this.jwt.isScopeGranted(payload, this.jwtOptions)) {
                resultHandler.handle((Object)Future.failedFuture((String)"Invalid JWT token: missing required scopes."));
                return;
            }
            resultHandler.handle((Object)Future.succeededFuture((Object)this.createUser(payload, this.permissionsClaimKey)));
        }
        catch (RuntimeException e) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    @Override
    public String generateToken(JsonObject claims, JWTOptions options) {
        JsonObject _claims = claims.copy();
        if (options.getPermissions() != null && !_claims.containsKey(this.permissionsClaimKey)) {
            _claims.put(this.permissionsClaimKey, (Object)new JsonArray(options.getPermissions()));
        }
        return this.jwt.sign(_claims, options);
    }

    private static JsonArray getJsonPermissions(JsonObject jwtToken, String permissionsClaimKey) {
        if (permissionsClaimKey.contains("/")) {
            return JWTAuthProviderImpl.getNestedJsonValue(jwtToken, permissionsClaimKey);
        }
        return jwtToken.getJsonArray(permissionsClaimKey, null);
    }

    private User createUser(JsonObject jwtToken, String permissionsClaimKey) {
        User result = User.create((JsonObject)jwtToken);
        JsonArray jsonPermissions = JWTAuthProviderImpl.getJsonPermissions(jwtToken, permissionsClaimKey);
        if (jsonPermissions != null) {
            for (Object item : jsonPermissions) {
                if (!(item instanceof String)) continue;
                String permission = (String)item;
                result.authorizations().add("jwt-authentication", (Authorization)PermissionBasedAuthorization.create((String)permission));
            }
        }
        return result;
    }

    private static JsonArray getNestedJsonValue(JsonObject jwtToken, String permissionsClaimKey) {
        String[] keys = permissionsClaimKey.split("/");
        JsonObject obj = null;
        for (int i = 0; i < keys.length; ++i) {
            if (i == 0) {
                obj = jwtToken.getJsonObject(keys[i]);
                continue;
            }
            if (i == keys.length - 1) {
                if (obj == null) continue;
                return obj.getJsonArray(keys[i]);
            }
            if (obj == null) continue;
            obj = obj.getJsonObject(keys[i]);
        }
        return null;
    }
}

