/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jwt.authorization.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.RoleBasedAuthorization;
import io.vertx.ext.auth.jwt.authorization.MicroProfileAuthorization;
import java.util.HashSet;
import java.util.Set;

public class MicroProfileAuthorizationImpl
implements MicroProfileAuthorization {
    public String getId() {
        return "mp-jwt";
    }

    public void getAuthorizations(User user, Handler<AsyncResult<Set<Authorization>>> handler) {
        JsonObject accessToken;
        String rootClaim = user.attributes().getString("rootClaim");
        JsonObject jsonObject = accessToken = rootClaim == null ? user.principal() : user.principal().getJsonObject(rootClaim);
        if (accessToken == null) {
            handler.handle((Object)Future.failedFuture((String)"User doesn't contain a decoded Token"));
            return;
        }
        HashSet<RoleBasedAuthorization> authorizations = new HashSet<RoleBasedAuthorization>();
        JsonArray groups = accessToken.getJsonArray("groups");
        if (groups != null && groups.size() >= 0) {
            for (Object el : groups) {
                if (el instanceof String) {
                    authorizations.add(RoleBasedAuthorization.create((String)((String)el)));
                    continue;
                }
                handler.handle((Object)Future.failedFuture((String)("Cannot parse role: " + el)));
                return;
            }
        }
        handler.handle((Object)Future.succeededFuture(authorizations));
    }
}

