/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jwt.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.jwt.JWTAuth;
import io.vertx.ext.auth.jwt.JWTOptions;
import io.vertx.ext.auth.jwt.impl.JWT;
import io.vertx.ext.auth.jwt.impl.JWTUser;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Collections;

public class JWTAuthProviderImpl
implements JWTAuth {
    private static final JsonObject EMPTY_OBJECT = new JsonObject();
    private static final JsonArray EMPTY_ARRAY = new JsonArray();
    private final JWT jwt;
    private final String permissionsClaimKey;

    public JWTAuthProviderImpl(Vertx vertx, JsonObject config) {
        block16: {
            this.permissionsClaimKey = config.getString("permissionsClaimKey", "permissions");
            JsonObject keyStore = config.getJsonObject("keyStore");
            try {
                if (keyStore != null) {
                    KeyStore ks = KeyStore.getInstance(keyStore.getString("type", "jceks"));
                    VertxInternal vertxInternal = (VertxInternal)vertx;
                    try (FileInputStream in = new FileInputStream(vertxInternal.resolveFile(keyStore.getString("path")));){
                        ks.load(in, keyStore.getString("password").toCharArray());
                    }
                    this.jwt = new JWT(ks, keyStore.getString("password").toCharArray());
                    break block16;
                }
                this.jwt = new JWT(config.getString("public-key"));
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> resultHandler) {
        try {
            Long nbf;
            Long iat;
            JsonObject payload = this.jwt.decode(authInfo.getString("jwt"));
            JsonObject options = authInfo.getJsonObject("options", EMPTY_OBJECT);
            long now = System.currentTimeMillis() / 1000L;
            if (payload.containsKey("exp") && !options.getBoolean("ignoreExpiration", Boolean.valueOf(false)).booleanValue() && now >= payload.getLong("exp")) {
                resultHandler.handle((Object)Future.failedFuture((String)"Expired JWT token: exp <= now"));
                return;
            }
            if (payload.containsKey("iat") && (iat = payload.getLong("iat")) > now) {
                resultHandler.handle((Object)Future.failedFuture((String)"Invalid JWT token: iat > now"));
                return;
            }
            if (payload.containsKey("nbf") && (nbf = payload.getLong("nbf")) > now) {
                resultHandler.handle((Object)Future.failedFuture((String)"Invalid JWT token: nbf > now"));
                return;
            }
            if (options.containsKey("audience")) {
                JsonArray audiences = options.getJsonArray("audience", EMPTY_ARRAY);
                JsonArray target = payload.getJsonArray("aud", EMPTY_ARRAY);
                if (Collections.disjoint(audiences.getList(), target.getList())) {
                    resultHandler.handle((Object)Future.failedFuture((String)("Invalid JWT audient. expected: " + audiences.encode())));
                    return;
                }
            }
            if (options.containsKey("issuer") && !options.getString("issuer").equals(payload.getString("iss"))) {
                resultHandler.handle((Object)Future.failedFuture((String)"Invalid JWT issuer"));
                return;
            }
            resultHandler.handle((Object)Future.succeededFuture((Object)((Object)new JWTUser(payload, this.permissionsClaimKey))));
        }
        catch (RuntimeException e) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    @Override
    public String generateToken(JsonObject claims, JWTOptions options) {
        JsonObject jsonOptions = options.toJson();
        JsonObject _claims = claims.copy();
        if (jsonOptions.containsKey("permissions") && !_claims.containsKey(this.permissionsClaimKey)) {
            _claims.put(this.permissionsClaimKey, jsonOptions.getJsonArray("permissions"));
        }
        return this.jwt.sign(_claims, jsonOptions);
    }
}

