/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jwt.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.jwt.JWTAuth;
import io.vertx.ext.auth.jwt.JWTOptions;
import io.vertx.ext.auth.jwt.impl.JWT;
import io.vertx.ext.auth.jwt.impl.JWTUser;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Collections;

public class JWTAuthProviderImpl
implements JWTAuth {
    private static final JsonObject EMPTY_OBJECT = new JsonObject();
    private static final JsonArray EMPTY_ARRAY = new JsonArray();
    private final JWT jwt;
    private final String permissionsClaimKey;

    /*
     * Unable to fully structure code
     */
    public JWTAuthProviderImpl(JsonObject config) {
        block32: {
            super();
            this.permissionsClaimKey = config.getString("permissionsClaimKey", "permissions");
            keyStoreURI = config.getString("keyStoreURI");
            try {
                block33: {
                    if (keyStoreURI == null) break block33;
                    ks = KeyStore.getInstance(config.getString("keyStoreType", "jceks"));
                    uri = new URI(keyStoreURI);
                    var5_6 = uri.getScheme();
                    var6_7 = -1;
                    switch (var5_6.hashCode()) {
                        case -8875619: {
                            if (!var5_6.equals("classpath")) break;
                            var6_7 = 0;
                            break;
                        }
                        case 3143036: {
                            if (!var5_6.equals("file")) break;
                            var6_7 = 1;
                        }
                    }
                    switch (var6_7) {
                        case 0: {
                            in = this.getClassLoader().getResourceAsStream(uri.getPath().substring(1));
                            var8_10 = null;
                            ks.load(in, config.getString("keyStorePassword").toCharArray());
                            if (in == null) break;
                            if (var8_10 == null) ** GOTO lbl32
                            try {
                                in.close();
                            }
                            catch (Throwable var9_12) {
                                var8_10.addSuppressed(var9_12);
                            }
                            break;
lbl32:
                            // 1 sources

                            in.close();
                            break;
                            catch (Throwable var9_13) {
                                try {
                                    var8_10 = var9_13;
                                    throw var9_13;
                                }
                                catch (Throwable var10_16) {
                                    if (in != null) {
                                        if (var8_10 != null) {
                                            try {
                                                in.close();
                                            }
                                            catch (Throwable var11_17) {
                                                var8_10.addSuppressed(var11_17);
                                            }
                                        } else {
                                            in.close();
                                        }
                                    }
                                    throw var10_16;
                                }
                            }
                        }
                        case 1: {
                            in = new FileInputStream(uri.getPath());
                            var8_11 = null;
                            ks.load(in, config.getString("keyStorePassword").toCharArray());
                            if (in == null) break;
                            if (var8_11 == null) ** GOTO lbl62
                            try {
                                in.close();
                            }
                            catch (Throwable var9_14) {
                                var8_11.addSuppressed(var9_14);
                            }
                            break;
lbl62:
                            // 1 sources

                            in.close();
                            break;
                            catch (Throwable var9_15) {
                                try {
                                    var8_11 = var9_15;
                                    throw var9_15;
                                }
                                catch (Throwable var12_18) {
                                    if (in != null) {
                                        if (var8_11 != null) {
                                            try {
                                                in.close();
                                            }
                                            catch (Throwable var13_19) {
                                                var8_11.addSuppressed(var13_19);
                                            }
                                        } else {
                                            in.close();
                                        }
                                    }
                                    throw var12_18;
                                }
                            }
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid uri: " + config.getString("keyStoreFilename"));
                        }
                    }
                    this.jwt = new JWT(ks, config.getString("keyStorePassword").toCharArray());
                    break block32;
                }
                this.jwt = new JWT(null, null);
            }
            catch (IOException | URISyntaxException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private ClassLoader getClassLoader() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        return tccl == null ? this.getClass().getClassLoader() : tccl;
    }

    public void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> resultHandler) {
        try {
            Long nbf;
            Long iat;
            JsonObject payload = this.jwt.decode(authInfo.getString("jwt"));
            JsonObject options = authInfo.getJsonObject("options", EMPTY_OBJECT);
            long now = System.currentTimeMillis() / 1000L;
            if (payload.containsKey("exp") && !options.getBoolean("ignoreExpiration", Boolean.valueOf(false)).booleanValue() && now >= payload.getLong("exp")) {
                resultHandler.handle((Object)Future.failedFuture((String)"Expired JWT token: exp <= now"));
                return;
            }
            if (payload.containsKey("iat") && (iat = payload.getLong("iat")) > now) {
                resultHandler.handle((Object)Future.failedFuture((String)"Invalid JWT token: iat > now"));
                return;
            }
            if (payload.containsKey("nbf") && (nbf = payload.getLong("nbf")) > now) {
                resultHandler.handle((Object)Future.failedFuture((String)"Invalid JWT token: nbf > now"));
                return;
            }
            if (options.containsKey("audience")) {
                JsonArray audiences = options.getJsonArray("audience", EMPTY_ARRAY);
                JsonArray target = payload.getJsonArray("aud", EMPTY_ARRAY);
                if (Collections.disjoint(audiences.getList(), target.getList())) {
                    resultHandler.handle((Object)Future.failedFuture((String)("Invalid JWT audient. expected: " + audiences.encode())));
                    return;
                }
            }
            if (options.containsKey("issuer") && !options.getString("issuer").equals(payload.getString("iss"))) {
                resultHandler.handle((Object)Future.failedFuture((String)"Invalid JWT issuer"));
                return;
            }
            resultHandler.handle((Object)Future.succeededFuture((Object)((Object)new JWTUser(payload, this.permissionsClaimKey))));
        }
        catch (RuntimeException e) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    @Override
    public String generateToken(JsonObject claims, JWTOptions options) {
        JsonObject jsonOptions = options.toJSON();
        if (jsonOptions.containsKey("permissions") && !claims.containsKey(this.permissionsClaimKey)) {
            claims.put(this.permissionsClaimKey, jsonOptions.getJsonArray("permissions"));
        }
        return this.jwt.sign(claims, options.toJSON());
    }
}

