/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.htdigest.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.htdigest.HtdigestAuth;
import io.vertx.ext.auth.htdigest.HtdigestCredentials;
import io.vertx.ext.auth.impl.Codec;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class HtdigestAuthImpl
implements HtdigestAuth {
    private static final MessageDigest MD5;
    private final Map<String, Digest> htdigest = new HashMap<String, Digest>();
    private final String realm;

    public HtdigestAuthImpl(Vertx vertx, String htdigestFile) {
        String realm = null;
        for (String line : vertx.fileSystem().readFileBlocking(htdigestFile).toString().split("\\r?\\n")) {
            String[] parts = line.split(":");
            if (realm == null) {
                realm = parts[1];
            } else if (!realm.equals(parts[1])) {
                throw new RuntimeException("multiple realms in htdigest file not allowed.");
            }
            this.htdigest.put(parts[0], new Digest(parts[0], parts[1], parts[2]));
        }
        this.realm = realm;
    }

    @Override
    public String realm() {
        return this.realm;
    }

    public void authenticate(JsonObject credentials, Handler<AsyncResult<User>> resultHandler) {
        this.authenticate(credentials).onComplete(resultHandler);
    }

    public Future<User> authenticate(JsonObject authInfo) {
        return this.authenticate(new HtdigestCredentials(authInfo));
    }

    public Future<User> authenticate(Credentials credentials) {
        HtdigestCredentials authInfo;
        try {
            authInfo = (HtdigestCredentials)credentials;
            authInfo.checkValid(null);
        }
        catch (RuntimeException e) {
            return Future.failedFuture((Throwable)e);
        }
        if (!this.htdigest.containsKey(authInfo.getUsername())) {
            return Future.failedFuture((String)"Unknown username.");
        }
        Digest credential = this.htdigest.get(authInfo.getUsername());
        if (!credential.realm.equals(authInfo.getRealm())) {
            return Future.failedFuture((String)"Invalid realm.");
        }
        String ha1 = "MD5-sess".equals(authInfo.getAlgorithm()) ? HtdigestAuthImpl.md5(credential.password + ":" + authInfo.getNonce() + ":" + authInfo.getCnonce()) : credential.password;
        if (authInfo.getQop() != null && !"auth".equals(authInfo.getQop())) {
            if ("auth-int".equals(authInfo.getQop())) {
                return Future.failedFuture((String)"qop: auth-int not supported.");
            }
            return Future.failedFuture((String)"Invalid qop.");
        }
        String ha2 = HtdigestAuthImpl.md5(authInfo.getMethod() + ":" + authInfo.getUri());
        String digest = authInfo.getQop() == null ? HtdigestAuthImpl.md5(ha1 + ":" + authInfo.getNonce() + ":" + ha2) : HtdigestAuthImpl.md5(ha1 + ":" + authInfo.getNonce() + ":" + authInfo.getNc() + ":" + authInfo.getCnonce() + ":" + authInfo.getQop() + ":" + ha2);
        if (digest.equals(authInfo.getResponse())) {
            User user = User.create((JsonObject)new JsonObject().put("username", (Object)credential.username).put("realm", (Object)credential.realm));
            user.principal().put("amr", Collections.singletonList("pwd"));
            return Future.succeededFuture((Object)user);
        }
        return Future.failedFuture((String)"Bad response");
    }

    private static synchronized String md5(String payload) {
        MD5.reset();
        return Codec.base16Encode((byte[])MD5.digest(payload.getBytes(StandardCharsets.UTF_8)));
    }

    static {
        try {
            MD5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static class Digest {
        final String username;
        final String realm;
        final String password;

        Digest(String username, String realm, String password) {
            this.username = username;
            this.realm = realm;
            this.password = password;
        }
    }
}

