/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.htdigest;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authentication.CredentialValidationException;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.htdigest.HtdigestCredentialsConverter;
import java.util.Map;

@DataObject(generateConverter=true, publicConverter=false)
public class HtdigestCredentials
implements Credentials {
    private String algorithm;
    private String cnonce;
    private String method;
    private String nc;
    private String nonce;
    private String opaque;
    private String qop;
    private String realm;
    private String response;
    private String uri;
    private String username;

    public HtdigestCredentials() {
    }

    public HtdigestCredentials(JsonObject jsonObject) {
        HtdigestCredentialsConverter.fromJson((Iterable<Map.Entry<String, Object>>)jsonObject, this);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getCnonce() {
        return this.cnonce;
    }

    public String getMethod() {
        return this.method;
    }

    public String getNc() {
        return this.nc;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public String getQop() {
        return this.qop;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getResponse() {
        return this.response;
    }

    public String getUri() {
        return this.uri;
    }

    public String getUsername() {
        return this.username;
    }

    public HtdigestCredentials setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public HtdigestCredentials setCnonce(String cnonce) {
        this.cnonce = cnonce;
        return this;
    }

    public HtdigestCredentials setMethod(String method) {
        this.method = method;
        return this;
    }

    public HtdigestCredentials setNc(String nc) {
        this.nc = nc;
        return this;
    }

    public HtdigestCredentials setNonce(String nonce) {
        this.nonce = nonce;
        return this;
    }

    public HtdigestCredentials setOpaque(String opaque) {
        this.opaque = opaque;
        return this;
    }

    public HtdigestCredentials setQop(String qop) {
        this.qop = qop;
        return this;
    }

    public HtdigestCredentials setRealm(String realm) {
        this.realm = realm;
        return this;
    }

    public HtdigestCredentials setResponse(String response) {
        this.response = response;
        return this;
    }

    public HtdigestCredentials setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public HtdigestCredentials setUsername(String username) {
        this.username = username;
        return this;
    }

    public <V> void checkValid(V arg) throws CredentialValidationException {
        if (this.username == null || this.username.length() == 0) {
            throw new CredentialValidationException("username cannot be null or empty");
        }
        if (this.realm == null) {
            throw new CredentialValidationException("realm cannot be null");
        }
        if (this.response == null) {
            throw new CredentialValidationException("response cannot be null");
        }
    }

    public JsonObject toJson() {
        JsonObject result = new JsonObject();
        HtdigestCredentialsConverter.toJson(this, result);
        return result;
    }

    public String toString() {
        return this.toJson().encode();
    }
}

