/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.htdigest.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.htdigest.HtdigestAuth;
import io.vertx.ext.auth.htdigest.impl.HtdigestUser;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public class HtdigestAuthImpl
implements HtdigestAuth {
    private static final MessageDigest MD5;
    private final Map<String, Digest> htdigest = new HashMap<String, Digest>();
    private final String realm;
    private static final char[] hexArray;

    public HtdigestAuthImpl(Vertx vertx, String htdigestFile) {
        String realm = null;
        for (String line : vertx.fileSystem().readFileBlocking(htdigestFile).toString().split("\\r?\\n")) {
            String[] parts = line.split(":");
            if (realm == null) {
                realm = parts[1];
            } else if (!realm.equals(parts[1])) {
                throw new RuntimeException("multiple realms in htdigest file not allowed.");
            }
            this.htdigest.put(parts[0], new Digest(parts[0], parts[1], parts[2]));
        }
        this.realm = realm;
    }

    @Override
    public String realm() {
        return this.realm;
    }

    public void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> resultHandler) {
        String username = authInfo.getString("username");
        if (username == null || username.length() == 0) {
            resultHandler.handle((Object)Future.failedFuture((String)"Username must be set for authentication."));
            return;
        }
        if (!this.htdigest.containsKey(username)) {
            resultHandler.handle((Object)Future.failedFuture((String)"Unknown username."));
            return;
        }
        String realm = authInfo.getString("realm");
        if (realm == null) {
            resultHandler.handle((Object)Future.failedFuture((String)"Realm must be set for authentication."));
            return;
        }
        Digest credential = this.htdigest.get(username);
        if (!credential.realm.equals(realm)) {
            resultHandler.handle((Object)Future.failedFuture((String)"Invalid realm."));
            return;
        }
        String ha1 = "MD5-sess".equals(authInfo.getString("algorithm")) ? HtdigestAuthImpl.md5(credential.password + ":" + authInfo.getString("nonce") + ":" + authInfo.getString("cnonce")) : credential.password;
        if (authInfo.containsKey("qop") && !"auth".equals(authInfo.getString("qop"))) {
            if ("auth-int".equals(authInfo.getString("qop"))) {
                resultHandler.handle((Object)Future.failedFuture((String)"qop: auth-int not supported."));
                return;
            }
            resultHandler.handle((Object)Future.failedFuture((String)"Invalid qop."));
            return;
        }
        String ha2 = HtdigestAuthImpl.md5(authInfo.getString("method") + ":" + authInfo.getString("uri"));
        String digest = !authInfo.containsKey("qop") ? HtdigestAuthImpl.md5(ha1 + ":" + authInfo.getString("nonce") + ":" + ha2) : HtdigestAuthImpl.md5(ha1 + ":" + authInfo.getString("nonce") + ":" + authInfo.getString("nc") + ":" + authInfo.getString("cnonce") + ":" + authInfo.getString("qop") + ":" + ha2);
        if (digest.equals(authInfo.getString("response"))) {
            resultHandler.handle((Object)Future.succeededFuture((Object)new HtdigestUser(credential.username, credential.realm)));
        } else {
            resultHandler.handle((Object)Future.failedFuture((String)"Bad response"));
        }
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    private static synchronized String md5(String payload) {
        MD5.reset();
        return HtdigestAuthImpl.bytesToHex(MD5.digest(payload.getBytes()));
    }

    static {
        try {
            MD5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        hexArray = "0123456789abcdef".toCharArray();
    }

    private static class Digest {
        final String username;
        final String realm;
        final String password;

        Digest(String username, String realm, String password) {
            this.username = username;
            this.realm = realm;
            this.password = password;
        }
    }
}

