/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.ClusterSerializable;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.Authorizations;
import io.vertx.ext.auth.authorization.impl.AuthorizationsImpl;
import io.vertx.ext.auth.impl.UserConverter;
import java.util.Collections;
import java.util.Objects;

public class UserImpl
implements User,
ClusterSerializable {
    private Authorizations authorizations;
    private JsonObject attributes;
    private JsonObject principal;

    public UserImpl() {
    }

    public UserImpl(JsonObject principal, JsonObject attributes) {
        this.principal = Objects.requireNonNull(principal);
        this.attributes = attributes;
        this.authorizations = new AuthorizationsImpl();
    }

    @Override
    public Authorizations authorizations() {
        return this.authorizations;
    }

    @Override
    public JsonObject attributes() {
        return this.attributes;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserImpl other = (UserImpl)obj;
        return Objects.equals(this.authorizations, other.authorizations) && Objects.equals(this.principal, other.principal) && Objects.equals(this.attributes, other.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.authorizations, this.principal, this.attributes);
    }

    @Override
    public JsonObject principal() {
        return this.principal;
    }

    @Override
    public User merge(User other) {
        if (other == null) {
            return this;
        }
        JsonArray amr = this.principal().getJsonArray("amr");
        JsonArray otherAmr = other.principal().getJsonArray("amr");
        this.principal().mergeIn(other.principal());
        if (amr == null) {
            if (otherAmr != null) {
                amr = otherAmr.copy();
            }
        } else if (otherAmr != null) {
            amr = amr.copy();
            for (Object el : otherAmr) {
                if (amr.contains(el)) continue;
                amr.add(el);
            }
        }
        if (amr == null) {
            this.principal.put("amr", Collections.singletonList("mfa"));
        } else {
            if (!(amr = amr.copy()).contains((Object)"mfa")) {
                amr.add((Object)"mfa");
            }
            this.principal.put("amr", (Object)amr);
        }
        JsonObject attrs = this.attributes();
        JsonObject otherAttrs = other.attributes();
        if (attrs == null) {
            if (otherAttrs != null) {
                this.attributes = otherAttrs.copy();
            }
        } else if (otherAttrs != null) {
            for (String key : otherAttrs.fieldNames()) {
                Object lhsValue = attrs.getValue(key);
                Object rhsValue = otherAttrs.getValue(key);
                if (lhsValue == null) {
                    attrs.put(key, rhsValue instanceof JsonArray ? new JsonArray().add(rhsValue) : rhsValue);
                    continue;
                }
                if (lhsValue instanceof JsonArray) {
                    if (rhsValue instanceof JsonArray) {
                        ((JsonArray)lhsValue).addAll((JsonArray)rhsValue);
                        continue;
                    }
                    ((JsonArray)lhsValue).add(rhsValue);
                    continue;
                }
                if (rhsValue instanceof JsonArray) {
                    attrs.put(key, (Object)new JsonArray().add(lhsValue).addAll((JsonArray)rhsValue));
                    continue;
                }
                attrs.put(key, (Object)new JsonArray().add(lhsValue).add(rhsValue));
            }
        }
        return this;
    }

    public void writeToBuffer(Buffer buffer) {
        UserConverter.encode(this).writeToBuffer(buffer);
    }

    public int readFromBuffer(int pos, Buffer buffer) {
        JsonObject jsonObject = new JsonObject();
        int read = jsonObject.readFromBuffer(pos, buffer);
        User readUser = UserConverter.decode(jsonObject);
        this.principal = readUser.principal();
        this.authorizations = readUser.authorizations();
        this.attributes = readUser.attributes();
        return read;
    }
}

