/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.KeyStoreOptionsConverter;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;

@DataObject(generateConverter=true)
public class KeyStoreOptions
extends io.vertx.core.net.KeyStoreOptions {
    private static final String DEFAULT_TYPE = KeyStore.getDefaultType();
    private Map<String, String> passwordProtection;

    public KeyStoreOptions() {
        this.setType(DEFAULT_TYPE);
    }

    public KeyStoreOptions(KeyStoreOptions other) {
        super((io.vertx.core.net.KeyStoreOptions)other);
        if (this.getType() == null) {
            this.setType(DEFAULT_TYPE);
        }
        this.passwordProtection = other.getPasswordProtection();
    }

    public KeyStoreOptions(JsonObject json) {
        KeyStoreOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public String getType() {
        return super.getType();
    }

    @Fluent
    public KeyStoreOptions setType(String type) {
        super.setType(type);
        return this;
    }

    @Fluent
    public KeyStoreOptions setPassword(String password) {
        super.setPassword(password);
        return this;
    }

    @Fluent
    public KeyStoreOptions setPath(String path) {
        super.setPath(path);
        return this;
    }

    @Fluent
    public KeyStoreOptions setValue(Buffer value) {
        super.setValue(value);
        return this;
    }

    public Map<String, String> getPasswordProtection() {
        return this.passwordProtection;
    }

    @Fluent
    public KeyStoreOptions setPasswordProtection(Map<String, String> passwordProtection) {
        this.passwordProtection = passwordProtection;
        return this;
    }

    public KeyStoreOptions putPasswordProtection(String alias, String password) {
        if (this.passwordProtection == null) {
            this.passwordProtection = new HashMap<String, String>();
        }
        this.passwordProtection.put(alias, password);
        return this;
    }
}

