/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.authentication;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.CredentialValidationException;
import io.vertx.ext.auth.authentication.Credentials;

@VertxGen
public interface AuthenticationProvider {
    public void authenticate(JsonObject var1, Handler<AsyncResult<User>> var2);

    default public Future<User> authenticate(JsonObject credentials) {
        Promise promise = Promise.promise();
        this.authenticate(credentials, (Handler<AsyncResult<User>>)promise);
        return promise.future();
    }

    default public void authenticate(Credentials credentials, Handler<AsyncResult<User>> resultHandler) {
        try {
            credentials.checkValid(null);
            this.authenticate(credentials.toJson(), resultHandler);
        }
        catch (CredentialValidationException e) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    default public Future<User> authenticate(Credentials credentials) {
        Promise promise = Promise.promise();
        this.authenticate(credentials, (Handler<AsyncResult<User>>)promise);
        return promise.future();
    }
}

