/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.impl.jose;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.PubSecKeyOptions;
import io.vertx.ext.auth.impl.jose.Crypto;
import io.vertx.ext.auth.impl.jose.SignatureHelper;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.PSSParameterSpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public final class JWK
implements Crypto {
    public static final int USE_SIG = 1;
    public static final int USE_ENC = 2;
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final Logger LOG = LoggerFactory.getLogger(JWK.class);
    private final String kid;
    private final String alg;
    private final String label;
    private final int len;
    private final boolean asn1;
    private final boolean symmetric;
    private final int use;
    private PrivateKey privateKey;
    private PublicKey publicKey;
    private Signature signature;
    private Cipher cipher;
    private Mac mac;

    public static List<JWK> load(KeyStore keyStore, String keyStorePassword, Map<String, String> passwordProtection) {
        String expected;
        String alg;
        HashMap<String, String> aliases = new HashMap<String, String>(){
            {
                this.put("HS256", "HMacSHA256");
                this.put("HS384", "HMacSHA384");
                this.put("HS512", "HMacSHA512");
                this.put("RS256", "SHA256withRSA");
                this.put("RS384", "SHA384withRSA");
                this.put("RS512", "SHA512withRSA");
                this.put("ES256", "SHA256withECDSA");
                this.put("ES384", "SHA384withECDSA");
                this.put("ES512", "SHA512withECDSA");
            }
        };
        ArrayList<JWK> keys = new ArrayList<JWK>();
        for (String alias : Arrays.asList("HS256", "HS384", "HS512")) {
            try {
                Key secretKey = keyStore.getKey(alias, keyStorePassword.toCharArray());
                if (secretKey == null) continue;
                alg = secretKey.getAlgorithm();
                expected = (String)aliases.get(alias);
                if (alg == null || !alg.equalsIgnoreCase(expected)) {
                    LOG.warn((Object)("The key algorithm does not match " + expected));
                    continue;
                }
                Mac mac = Mac.getInstance(alg);
                mac.init(secretKey);
                keys.add(new JWK(alias, mac));
            }
            catch (InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                LOG.warn((Object)("Failed to load key for algorithm: " + alias), (Throwable)e);
            }
        }
        for (String alias : Arrays.asList("RS256", "RS384", "RS512", "ES256", "ES384", "ES512")) {
            try {
                X509Certificate certificate = (X509Certificate)keyStore.getCertificate(alias);
                if (certificate == null) continue;
                certificate.checkValidity();
                alg = certificate.getSigAlgName();
                expected = (String)aliases.get(alias);
                if (alg == null || !alg.equalsIgnoreCase(expected)) {
                    LOG.warn((Object)("The key algorithm does not match " + expected));
                    continue;
                }
                PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, passwordProtection == null ? keyStorePassword.toCharArray() : passwordProtection.get(alias).toCharArray());
                keys.add(new JWK(alias, certificate, privateKey));
            }
            catch (ClassCastException | InvalidAlgorithmParameterException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateExpiredException | CertificateNotYetValidException e) {
                LOG.warn((Object)("Failed to load key for algorithm: " + alias), (Throwable)e);
            }
        }
        return keys;
    }

    public JWK(PubSecKeyOptions options) {
        this.alg = options.getAlgorithm();
        this.kid = options.getId();
        String pem = Objects.requireNonNull(options.getBuffer());
        this.label = this.kid == null ? this.alg + "#" + pem.hashCode() : this.kid;
        switch (this.alg) {
            case "HS256": {
                try {
                    this.mac = Mac.getInstance("HMacSHA256");
                    this.mac.init(new SecretKeySpec(pem.getBytes(), "HMacSHA256"));
                }
                catch (InvalidKeyException | NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
                this.len = 256;
                this.asn1 = false;
                this.symmetric = true;
                this.use = 3;
                return;
            }
            case "HS384": {
                try {
                    this.mac = Mac.getInstance("HMacSHA384");
                    this.mac.init(new SecretKeySpec(pem.getBytes(), "HMacSHA384"));
                }
                catch (InvalidKeyException | NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
                this.len = 384;
                this.asn1 = false;
                this.symmetric = true;
                this.use = 3;
                return;
            }
            case "HS512": {
                try {
                    this.mac = Mac.getInstance("HMacSHA512");
                    this.mac.init(new SecretKeySpec(pem.getBytes(), "HMacSHA512"));
                }
                catch (InvalidKeyException | NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
                this.len = 512;
                this.asn1 = false;
                this.symmetric = true;
                this.use = 3;
                return;
            }
        }
        this.symmetric = false;
        try {
            switch (this.alg) {
                case "RS256": {
                    this.asn1 = false;
                    this.use = this.parsePEM(KeyFactory.getInstance("RSA"), pem);
                    this.signature = Signature.getInstance("SHA256withRSA");
                    if (this.publicKey != null && this.publicKey instanceof RSAKey) {
                        this.len = ((RSAKey)((Object)this.publicKey)).getModulus().bitLength() + 7 >> 3;
                        break;
                    }
                    this.len = 256;
                    break;
                }
                case "RS384": {
                    this.asn1 = false;
                    this.use = this.parsePEM(KeyFactory.getInstance("RSA"), pem);
                    this.signature = Signature.getInstance("SHA384withRSA");
                    if (this.publicKey != null && this.publicKey instanceof RSAKey) {
                        this.len = ((RSAKey)((Object)this.publicKey)).getModulus().bitLength() + 7 >> 3;
                        break;
                    }
                    this.len = 384;
                    break;
                }
                case "RS512": {
                    this.asn1 = false;
                    this.use = this.parsePEM(KeyFactory.getInstance("RSA"), pem);
                    this.signature = Signature.getInstance("SHA512withRSA");
                    if (this.publicKey != null && this.publicKey instanceof RSAKey) {
                        this.len = ((RSAKey)((Object)this.publicKey)).getModulus().bitLength() + 7 >> 3;
                        break;
                    }
                    this.len = 512;
                    break;
                }
                case "PS256": {
                    this.asn1 = false;
                    this.use = this.parsePEM(KeyFactory.getInstance("RSA"), pem);
                    this.signature = Signature.getInstance("RSASSA-PSS");
                    this.signature.setParameter(new PSSParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, 32, 1));
                    if (this.publicKey != null && this.publicKey instanceof RSAKey) {
                        this.len = ((RSAKey)((Object)this.publicKey)).getModulus().bitLength() + 7 >> 3;
                        break;
                    }
                    this.len = 256;
                    break;
                }
                case "PS384": {
                    this.asn1 = false;
                    this.use = this.parsePEM(KeyFactory.getInstance("RSA"), pem);
                    this.signature = Signature.getInstance("RSASSA-PSS");
                    this.signature.setParameter(new PSSParameterSpec("SHA-384", "MGF1", MGF1ParameterSpec.SHA384, 48, 1));
                    if (this.publicKey != null && this.publicKey instanceof RSAKey) {
                        this.len = ((RSAKey)((Object)this.publicKey)).getModulus().bitLength() + 7 >> 3;
                        break;
                    }
                    this.len = 384;
                    break;
                }
                case "PS512": {
                    this.asn1 = false;
                    this.use = this.parsePEM(KeyFactory.getInstance("RSA"), pem);
                    this.signature = Signature.getInstance("RSASSA-PSS");
                    this.signature.setParameter(new PSSParameterSpec("SHA-512", "MGF1", MGF1ParameterSpec.SHA512, 64, 1));
                    if (this.publicKey != null && this.publicKey instanceof RSAKey) {
                        this.len = ((RSAKey)((Object)this.publicKey)).getModulus().bitLength() + 7 >> 3;
                        break;
                    }
                    this.len = 512;
                    break;
                }
                case "ES256": {
                    this.asn1 = true;
                    this.len = 64;
                    this.use = this.parsePEM(KeyFactory.getInstance("EC"), pem);
                    this.signature = Signature.getInstance("SHA256withECDSA");
                    break;
                }
                case "ES384": {
                    this.asn1 = true;
                    this.len = 96;
                    this.use = this.parsePEM(KeyFactory.getInstance("EC"), pem);
                    this.signature = Signature.getInstance("SHA384withECDSA");
                    break;
                }
                case "ES512": {
                    this.asn1 = true;
                    this.len = 132;
                    this.use = this.parsePEM(KeyFactory.getInstance("EC"), pem);
                    this.signature = Signature.getInstance("SHA512withECDSA");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown algorithm: " + this.alg);
                }
            }
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | CertificateException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    private int parsePEM(KeyFactory kf, String pem) throws CertificateException, InvalidKeySpecException {
        String[] lines = pem.split("\r?\n");
        if (lines.length <= 2) {
            throw new IllegalArgumentException("PEM contains not enough lines");
        }
        Pattern begin = Pattern.compile("-----BEGIN (.+?)-----");
        Pattern end = Pattern.compile("-----END (.+?)-----");
        Matcher beginMatcher = begin.matcher(lines[0]);
        if (!beginMatcher.matches()) {
            throw new IllegalArgumentException("PEM first line does not match a BEGIN line");
        }
        String kind = beginMatcher.group(1);
        Buffer buffer = Buffer.buffer();
        boolean endSeen = false;
        for (int i = 1; i < lines.length; ++i) {
            if ("".equals(lines[i])) continue;
            Matcher endMatcher = end.matcher(lines[i]);
            if (endMatcher.matches()) {
                endSeen = true;
                if (kind.equals(endMatcher.group(1))) break;
                throw new IllegalArgumentException("PEM END line does not match start");
            }
            buffer.appendString(lines[i]);
        }
        if (!endSeen) {
            throw new IllegalArgumentException("PEM END line not found");
        }
        switch (kind) {
            case "CERTIFICATE": {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                this.publicKey = cf.generateCertificate(new ByteArrayInputStream(pem.getBytes())).getPublicKey();
                return 2;
            }
            case "PUBLIC KEY": {
                this.publicKey = kf.generatePublic(new X509EncodedKeySpec(Base64.getMimeDecoder().decode(buffer.getBytes())));
                return 2;
            }
            case "PRIVATE KEY": {
                this.privateKey = kf.generatePrivate(new PKCS8EncodedKeySpec(Base64.getMimeDecoder().decode(buffer.getBytes())));
                return 1;
            }
        }
        throw new IllegalStateException("Invalid PEM content: " + kind);
    }

    private JWK(String algorithm, Mac mac) throws NoSuchAlgorithmException {
        this.alg = algorithm;
        this.kid = null;
        this.label = this.alg + "#" + mac.hashCode();
        this.symmetric = true;
        this.use = 3;
        String macAlg = mac.getAlgorithm();
        switch (this.alg) {
            case "HS256": {
                this.len = 256;
                this.asn1 = false;
                if (!"HMacSHA256".equalsIgnoreCase(macAlg)) {
                    throw new IllegalArgumentException("The key algorithm does not match, expected: HMacSHA256");
                }
                this.mac = mac;
                break;
            }
            case "HS384": {
                this.len = 384;
                this.asn1 = false;
                if (!"HMacSHA384".equalsIgnoreCase(macAlg)) {
                    throw new IllegalArgumentException("The key algorithm does not match, expected: HMacSHA384");
                }
                this.mac = mac;
                break;
            }
            case "HS512": {
                this.len = 512;
                this.asn1 = false;
                if (!"HMacSHA512".equalsIgnoreCase(macAlg)) {
                    throw new IllegalArgumentException("The key algorithm does not match, expected: HMacSHA512");
                }
                this.mac = mac;
                break;
            }
            default: {
                throw new NoSuchAlgorithmException("Unknown algorithm: " + algorithm);
            }
        }
    }

    private JWK(String algorithm, X509Certificate certificate, PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        this.alg = algorithm;
        this.kid = null;
        this.label = privateKey != null ? algorithm + '#' + certificate.hashCode() + "-" + privateKey.hashCode() : algorithm + '#' + certificate.hashCode();
        this.symmetric = false;
        this.publicKey = certificate.getPublicKey();
        this.privateKey = privateKey;
        this.use = privateKey != null ? 3 : 2;
        switch (algorithm) {
            case "RS256": {
                this.asn1 = false;
                this.signature = Signature.getInstance("SHA256withRSA");
                if (this.publicKey != null && this.publicKey instanceof RSAKey) {
                    this.len = ((RSAKey)((Object)this.publicKey)).getModulus().bitLength() + 7 >> 3;
                    break;
                }
                this.len = 256;
                break;
            }
            case "RS384": {
                this.asn1 = false;
                this.signature = Signature.getInstance("SHA384withRSA");
                if (this.publicKey != null && this.publicKey instanceof RSAKey) {
                    this.len = ((RSAKey)((Object)this.publicKey)).getModulus().bitLength() + 7 >> 3;
                    break;
                }
                this.len = 384;
                break;
            }
            case "RS512": {
                this.asn1 = false;
                this.signature = Signature.getInstance("SHA512withRSA");
                if (this.publicKey != null && this.publicKey instanceof RSAKey) {
                    this.len = ((RSAKey)((Object)this.publicKey)).getModulus().bitLength() + 7 >> 3;
                    break;
                }
                this.len = 512;
                break;
            }
            case "PS256": {
                this.asn1 = false;
                this.signature = Signature.getInstance("RSASSA-PSS");
                this.signature.setParameter(new PSSParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, 32, 1));
                if (this.publicKey != null && this.publicKey instanceof RSAKey) {
                    this.len = ((RSAKey)((Object)this.publicKey)).getModulus().bitLength() + 7 >> 3;
                    break;
                }
                this.len = 256;
                break;
            }
            case "PS384": {
                this.asn1 = false;
                this.signature = Signature.getInstance("RSASSA-PSS");
                this.signature.setParameter(new PSSParameterSpec("SHA-384", "MGF1", MGF1ParameterSpec.SHA384, 48, 1));
                if (this.publicKey != null && this.publicKey instanceof RSAKey) {
                    this.len = ((RSAKey)((Object)this.publicKey)).getModulus().bitLength() + 7 >> 3;
                    break;
                }
                this.len = 384;
                break;
            }
            case "PS512": {
                this.asn1 = false;
                this.signature = Signature.getInstance("RSASSA-PSS");
                this.signature.setParameter(new PSSParameterSpec("SHA-512", "MGF1", MGF1ParameterSpec.SHA512, 64, 1));
                if (this.publicKey != null && this.publicKey instanceof RSAKey) {
                    this.len = ((RSAKey)((Object)this.publicKey)).getModulus().bitLength() + 7 >> 3;
                    break;
                }
                this.len = 512;
                break;
            }
            case "ES256": {
                this.asn1 = true;
                this.len = 64;
                this.signature = Signature.getInstance("SHA256withECDSA");
                break;
            }
            case "ES384": {
                this.asn1 = true;
                this.len = 96;
                this.signature = Signature.getInstance("SHA384withECDSA");
                break;
            }
            case "ES512": {
                this.asn1 = true;
                this.len = 132;
                this.signature = Signature.getInstance("SHA512withECDSA");
                break;
            }
            default: {
                throw new NoSuchAlgorithmException("Unknown algorithm: " + algorithm);
            }
        }
    }

    public JWK(JsonObject json) {
        this.kid = json.getString("kid");
        try {
            block7 : switch (json.getString("kty")) {
                case "RSA": 
                case "RSASSA": {
                    this.alg = json.getString("alg", "RS256");
                    this.symmetric = false;
                    switch (this.alg) {
                        case "RS1": {
                            this.asn1 = false;
                            this.use = this.createRSA("SHA1withRSA", json);
                            if (this.publicKey != null && this.publicKey instanceof RSAKey) {
                                this.len = ((RSAKey)((Object)this.publicKey)).getModulus().bitLength() + 7 >> 3;
                                break block7;
                            }
                            this.len = 256;
                            break block7;
                        }
                        case "RS256": {
                            this.asn1 = false;
                            this.use = this.createRSA("SHA256withRSA", json);
                            if (this.publicKey != null && this.publicKey instanceof RSAKey) {
                                this.len = ((RSAKey)((Object)this.publicKey)).getModulus().bitLength() + 7 >> 3;
                                break block7;
                            }
                            this.len = 256;
                            break block7;
                        }
                        case "RS384": {
                            this.asn1 = false;
                            this.use = this.createRSA("SHA384withRSA", json);
                            if (this.publicKey != null && this.publicKey instanceof RSAKey) {
                                this.len = ((RSAKey)((Object)this.publicKey)).getModulus().bitLength() + 7 >> 3;
                                break block7;
                            }
                            this.len = 384;
                            break block7;
                        }
                        case "RS512": {
                            this.asn1 = false;
                            this.use = this.createRSA("SHA512withRSA", json);
                            if (this.publicKey != null && this.publicKey instanceof RSAKey) {
                                this.len = ((RSAKey)((Object)this.publicKey)).getModulus().bitLength() + 7 >> 3;
                                break block7;
                            }
                            this.len = 512;
                            break block7;
                        }
                        case "PS256": {
                            this.asn1 = false;
                            this.use = this.createRSA("RSASSA-PSS", json);
                            if (this.publicKey != null && this.publicKey instanceof RSAKey) {
                                this.len = ((RSAKey)((Object)this.publicKey)).getModulus().bitLength() + 7 >> 3;
                                break block7;
                            }
                            this.len = 256;
                            break block7;
                        }
                        case "PS384": {
                            this.asn1 = false;
                            this.use = this.createRSA("RSASSA-PSS", json);
                            if (this.publicKey != null && this.publicKey instanceof RSAKey) {
                                this.len = ((RSAKey)((Object)this.publicKey)).getModulus().bitLength() + 7 >> 3;
                                break block7;
                            }
                            this.len = 384;
                            break block7;
                        }
                        case "PS512": {
                            this.asn1 = false;
                            this.use = this.createRSA("RSASSA-PSS", json);
                            if (this.publicKey != null && this.publicKey instanceof RSAKey) {
                                this.len = ((RSAKey)((Object)this.publicKey)).getModulus().bitLength() + 7 >> 3;
                                break block7;
                            }
                            this.len = 512;
                            break block7;
                        }
                    }
                    throw new NoSuchAlgorithmException(this.alg);
                }
                case "EC": {
                    this.alg = json.getString("alg", "ES256");
                    this.symmetric = false;
                    switch (this.alg) {
                        case "ES256": {
                            this.len = 64;
                            this.asn1 = json.getBoolean("asn1", Boolean.valueOf(true));
                            this.use = this.createEC("SHA256withECDSA", json);
                            break block7;
                        }
                        case "ES384": {
                            this.len = 96;
                            this.asn1 = json.getBoolean("asn1", Boolean.valueOf(true));
                            this.use = this.createEC("SHA384withECDSA", json);
                            break block7;
                        }
                        case "ES512": {
                            this.len = 132;
                            this.asn1 = json.getBoolean("asn1", Boolean.valueOf(true));
                            this.use = this.createEC("SHA512withECDSA", json);
                            break block7;
                        }
                    }
                    throw new NoSuchAlgorithmException(this.alg);
                }
                case "oct": {
                    this.alg = json.getString("alg", "HS256");
                    this.symmetric = true;
                    switch (this.alg) {
                        case "HS256": {
                            this.len = 256;
                            this.asn1 = false;
                            this.use = this.createOCT("HMacSHA256", json);
                            break block7;
                        }
                        case "HS384": {
                            this.len = 384;
                            this.asn1 = false;
                            this.use = this.createOCT("HMacSHA384", json);
                            break block7;
                        }
                        case "HS512": {
                            this.len = 512;
                            this.asn1 = false;
                            this.use = this.createOCT("HMacSHA512", json);
                            break block7;
                        }
                    }
                    throw new NoSuchAlgorithmException(this.alg);
                }
                default: {
                    throw new RuntimeException("Unsupported key type: " + json.getString("kty"));
                }
            }
            this.label = this.kid != null ? this.kid : this.alg + "#" + json.hashCode();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | CertificateException | InvalidKeySpecException | InvalidParameterSpecException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    private int createRSA(String alias, JsonObject json) throws NoSuchAlgorithmException, InvalidKeySpecException, CertificateException, NoSuchPaddingException {
        BigInteger e;
        BigInteger n;
        int use = 0;
        if (JWK.jsonHasProperties(json, "n", "e")) {
            n = new BigInteger(1, Base64.getUrlDecoder().decode(json.getString("n")));
            e = new BigInteger(1, Base64.getUrlDecoder().decode(json.getString("e")));
            this.publicKey = KeyFactory.getInstance("RSA").generatePublic(new RSAPublicKeySpec(n, e));
            if ((use & 2) == 0) {
                use += 2;
            }
        }
        if (JWK.jsonHasProperties(json, "n", "e", "d", "p", "q", "dp", "dq", "qi")) {
            n = new BigInteger(1, Base64.getUrlDecoder().decode(json.getString("n")));
            e = new BigInteger(1, Base64.getUrlDecoder().decode(json.getString("e")));
            BigInteger d = new BigInteger(1, Base64.getUrlDecoder().decode(json.getString("d")));
            BigInteger p = new BigInteger(1, Base64.getUrlDecoder().decode(json.getString("p")));
            BigInteger q = new BigInteger(1, Base64.getUrlDecoder().decode(json.getString("q")));
            BigInteger dp = new BigInteger(1, Base64.getUrlDecoder().decode(json.getString("dp")));
            BigInteger dq = new BigInteger(1, Base64.getUrlDecoder().decode(json.getString("dq")));
            BigInteger qi = new BigInteger(1, Base64.getUrlDecoder().decode(json.getString("qi")));
            this.privateKey = KeyFactory.getInstance("RSA").generatePrivate(new RSAPrivateCrtKeySpec(n, e, d, p, q, dp, dq, qi));
            if ((use & 1) == 0) {
                ++use;
            }
        }
        if (json.containsKey("x5c")) {
            JsonArray x5c = json.getJsonArray("x5c");
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Object certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(this.addBoundaries(x5c.getString(0)).getBytes(UTF8)));
            ((X509Certificate)certificate).checkValidity();
            try {
                if (x5c.size() > 1) {
                    ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>();
                    certChain.add((X509Certificate)certificate);
                    for (int i = 1; i < x5c.size(); ++i) {
                        X509Certificate c = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(this.addBoundaries(x5c.getString(i)).getBytes(UTF8)));
                        c.checkValidity();
                        certChain.add(c);
                    }
                    JWK.validateCertificatePath(certChain);
                }
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e2) {
                throw new RuntimeException(e2);
            }
            this.publicKey = ((Certificate)certificate).getPublicKey();
            if ((use & 2) == 0) {
                use += 2;
            }
        }
        switch (json.getString("use", "sig")) {
            case "sig": {
                try {
                    this.signature = Signature.getInstance(alias);
                    switch (this.alg) {
                        case "PS256": {
                            this.signature.setParameter(new PSSParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, 32, 1));
                            break;
                        }
                        case "PS384": {
                            this.signature.setParameter(new PSSParameterSpec("SHA-384", "MGF1", MGF1ParameterSpec.SHA384, 48, 1));
                            break;
                        }
                        case "PS512": {
                            this.signature.setParameter(new PSSParameterSpec("SHA-512", "MGF1", MGF1ParameterSpec.SHA512, 64, 1));
                        }
                    }
                    if (!json.containsKey("use") || (use & 1) != 0) break;
                    ++use;
                    break;
                }
                catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e3) {
                    throw new RuntimeException(e3);
                }
            }
            case "enc": {
                this.cipher = Cipher.getInstance("RSA");
                if (!json.containsKey("use") || (use & 2) != 0) break;
                use += 2;
            }
        }
        return use;
    }

    public static void validateCertificatePath(List<X509Certificate> certificates) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, NoSuchProviderException {
        for (int i = 0; i < certificates.size(); ++i) {
            X509Certificate subjectCert = certificates.get(i);
            X509Certificate issuerCert = i + 1 >= certificates.size() ? subjectCert : certificates.get(i + 1);
            if (!subjectCert.getIssuerX500Principal().equals(issuerCert.getSubjectX500Principal())) {
                throw new CertificateException("Failed to validate certificate path! Issuers dont match!");
            }
            subjectCert.verify(issuerCert.getPublicKey());
        }
    }

    private String addBoundaries(String certificate) {
        return "-----BEGIN CERTIFICATE-----\n" + certificate + "\n-----END CERTIFICATE-----\n";
    }

    private int createEC(String alias, JsonObject json) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidParameterSpecException, NoSuchPaddingException {
        BigInteger y;
        BigInteger x;
        int use = 0;
        AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC");
        parameters.init(new ECGenParameterSpec(JWK.translate(json.getString("crv"))));
        if (JWK.jsonHasProperties(json, "x", "y")) {
            x = new BigInteger(1, Base64.getUrlDecoder().decode(json.getString("x")));
            y = new BigInteger(1, Base64.getUrlDecoder().decode(json.getString("y")));
            this.publicKey = KeyFactory.getInstance("EC").generatePublic(new ECPublicKeySpec(new ECPoint(x, y), parameters.getParameterSpec(ECParameterSpec.class)));
            if ((use & 2) == 0) {
                use += 2;
            }
        }
        if (JWK.jsonHasProperties(json, "x", "y", "d")) {
            x = new BigInteger(1, Base64.getUrlDecoder().decode(json.getString("x")));
            y = new BigInteger(1, Base64.getUrlDecoder().decode(json.getString("y")));
            BigInteger d = new BigInteger(1, Base64.getUrlDecoder().decode(json.getString("d")));
            this.privateKey = KeyFactory.getInstance("EC").generatePrivate(new ECPrivateKeySpec(d, parameters.getParameterSpec(ECParameterSpec.class)));
            if ((use & 1) == 0) {
                ++use;
            }
        }
        switch (json.getString("use", "sig")) {
            case "sig": {
                try {
                    this.signature = Signature.getInstance(alias);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
                if (!json.containsKey("use") || (use & 1) != 0) break;
                ++use;
                break;
            }
            default: {
                throw new RuntimeException("EC Encryption not supported");
            }
        }
        return use;
    }

    private int createOCT(String alias, JsonObject json) throws NoSuchAlgorithmException, InvalidKeyException {
        this.mac = Mac.getInstance(alias);
        this.mac.init(new SecretKeySpec(json.getString("k").getBytes(UTF8), alias));
        return 3;
    }

    public String getAlgorithm() {
        return this.alg;
    }

    @Override
    public String getId() {
        return this.kid;
    }

    public Key unwrap() {
        if (this.privateKey != null) {
            return this.privateKey;
        }
        if (this.publicKey != null) {
            return this.publicKey;
        }
        return null;
    }

    public synchronized byte[] encrypt(byte[] payload) {
        if (this.cipher == null) {
            throw new RuntimeException("Key use is not 'enc'");
        }
        try {
            this.cipher.init(1, this.publicKey);
            this.cipher.update(payload);
            return this.cipher.doFinal();
        }
        catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized byte[] decrypt(byte[] payload) {
        if (this.cipher == null) {
            throw new RuntimeException("Key use is not 'enc'");
        }
        try {
            this.cipher.init(2, this.privateKey);
            this.cipher.update(payload);
            return this.cipher.doFinal();
        }
        catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized byte[] sign(byte[] payload) {
        if (!this.isFor(1)) {
            throw new IllegalStateException("Key use is not 'sig'");
        }
        if (this.symmetric) {
            return this.mac.doFinal(payload);
        }
        try {
            this.signature.initSign(this.privateKey);
            this.signature.update(payload);
            if (this.asn1) {
                return SignatureHelper.toJWS(this.signature.sign(), this.len);
            }
            return this.signature.sign();
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized boolean verify(byte[] expected, byte[] payload) {
        if (!this.isFor(2)) {
            throw new IllegalStateException("Key use is not 'enc'");
        }
        if (this.symmetric) {
            return MessageDigest.isEqual(expected, this.sign(payload));
        }
        try {
            this.signature.initVerify(this.publicKey);
            this.signature.update(payload);
            if (this.asn1) {
                return this.signature.verify(SignatureHelper.toDER(expected));
            }
            if (expected.length < this.len) {
                byte[] normalized = new byte[this.len];
                System.arraycopy(expected, 0, normalized, 0, expected.length);
                return this.signature.verify(normalized);
            }
            return this.signature.verify(expected);
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new RuntimeException(e);
        }
    }

    private static String translate(String crv) {
        switch (crv) {
            case "P-256": {
                return "secp256r1";
            }
            case "P-384": {
                return "secp384r1";
            }
            case "P-521": {
                return "secp521r1";
            }
        }
        return "";
    }

    private static boolean jsonHasProperties(JsonObject json, String ... properties) {
        for (String property : properties) {
            if (json.containsKey(property) && json.getValue(property) != null) continue;
            return false;
        }
        return true;
    }

    public boolean isFor(int use) {
        return (this.use & use) != 0;
    }

    public int getUse() {
        return this.use;
    }

    @Override
    public String getLabel() {
        return this.label;
    }
}

