/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.impl.jose;

import io.vertx.ext.auth.impl.jose.Crypto;
import java.util.Arrays;
import java.util.UUID;
import javax.crypto.Mac;

class CryptoMac
implements Crypto {
    private final String label = UUID.randomUUID().toString();
    private final Mac mac;

    CryptoMac(Mac mac) {
        this.mac = mac;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public synchronized byte[] sign(byte[] payload) {
        return this.mac.doFinal(payload);
    }

    @Override
    public boolean verify(byte[] signature, byte[] payload) {
        return Arrays.equals(signature, this.sign(payload));
    }
}

