/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.groovy.ext.auth.internal;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class ConversionHelper {
    public static Object unwrap(Object obj) {
        if (obj instanceof Map) {
            return ConversionHelper.toJsonObject((Map)obj);
        }
        if (obj instanceof List) {
            return ConversionHelper.toJsonArray((List)obj);
        }
        if (obj instanceof CharSequence) {
            return obj.toString();
        }
        return obj;
    }

    private static Object toJsonElement(Object obj) {
        if (obj instanceof Map) {
            return ConversionHelper.toJsonObject((Map)obj);
        }
        if (obj instanceof List) {
            return ConversionHelper.toJsonArray((List)obj);
        }
        if (obj instanceof CharSequence) {
            return obj.toString();
        }
        if (obj instanceof Buffer) {
            return Base64.getEncoder().encodeToString(((Buffer)obj).getBytes());
        }
        return obj;
    }

    public static JsonObject toJsonObject(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        map = new LinkedHashMap<String, Object>(map);
        map.entrySet().forEach(e -> e.setValue(ConversionHelper.toJsonElement(e.getValue())));
        return new JsonObject(map);
    }

    public static JsonArray toJsonArray(List<Object> list) {
        if (list == null) {
            return null;
        }
        list = new ArrayList<Object>(list);
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, ConversionHelper.toJsonElement(list.get(i)));
        }
        return new JsonArray(list);
    }

    public static <T, R> R applyIfNotNull(T expr, Function<T, R> function) {
        if (expr != null) {
            return function.apply(expr);
        }
        return null;
    }

    public static <T, R> R wrap(T t, Function<T, Object> f) {
        if (t != null) {
            return (R)ConversionHelper.wrap(f.apply(t));
        }
        return null;
    }

    public static <T> T wrap(Object obj) {
        if (obj instanceof JsonObject) {
            return (T)ConversionHelper.fromJsonObject((JsonObject)obj);
        }
        if (obj instanceof JsonArray) {
            return (T)ConversionHelper.fromJsonArray((JsonArray)obj);
        }
        return (T)obj;
    }

    public static Map<String, Object> fromJsonObject(JsonObject json) {
        if (json == null) {
            return null;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(json.getMap());
        map.entrySet().forEach(entry -> entry.setValue(ConversionHelper.wrap(entry.getValue())));
        return map;
    }

    public static List<Object> fromJsonArray(JsonArray json) {
        if (json == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(json.getList());
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, ConversionHelper.wrap(list.get(i)));
        }
        return list;
    }
}

