/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth;

import io.vertx.core.Vertx;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class PRNG {
    private static final int DEFAULT_SEED_INTERVAL_MILLIS = 300000;
    private static final int DEFAULT_SEED_BITS = 64;
    private final SecureRandom random;
    private final long seedID;
    private final Vertx vertx;

    public PRNG(Vertx vertx) {
        this.vertx = vertx;
        String algorithm = System.getProperty("io.vertx.ext.auth.prng.algorithm");
        int seedInterval = Integer.getInteger("io.vertx.ext.auth.prng.seed.interval", 300000);
        int seedBits = Integer.getInteger("io.vertx.ext.auth.prng.seed.bits", 64);
        if (algorithm != null) {
            try {
                this.random = SecureRandom.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.random = new SecureRandom();
        }
        this.random.nextBytes(new byte[1]);
        this.seedID = seedInterval > 0 && seedBits > 0 ? vertx.setPeriodic((long)seedInterval, id -> vertx.executeBlocking(future -> future.complete((Object)this.random.generateSeed(seedBits / 8)), false, asyncResult -> this.random.setSeed((byte[])asyncResult.result()))) : -1L;
    }

    public void close() {
        if (this.seedID != -1L) {
            this.vertx.cancelTimer(this.seedID);
        }
    }

    public void nextBytes(byte[] bytes) {
        this.random.nextBytes(bytes);
    }
}

