/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.shareddata.impl.ClusterSerializable;
import io.vertx.ext.auth.User;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractUser
implements User,
ClusterSerializable {
    final Set<String> cachedPermissions = new HashSet<String>();

    @Override
    public User isAuthorised(String authority, Handler<AsyncResult<Boolean>> resultHandler) {
        if (this.cachedPermissions.contains(authority)) {
            resultHandler.handle((Object)Future.succeededFuture((Object)true));
        } else {
            this.doIsPermitted(authority, (Handler<AsyncResult<Boolean>>)((Handler)res -> {
                if (res.succeeded() && ((Boolean)res.result()).booleanValue()) {
                    this.cachedPermissions.add(authority);
                }
                resultHandler.handle(res);
            }));
        }
        return this;
    }

    @Override
    public User clearCache() {
        this.cachedPermissions.clear();
        return this;
    }

    public void writeToBuffer(Buffer buff) {
        this.writeStringSet(buff, this.cachedPermissions);
    }

    public int readFromBuffer(int pos, Buffer buffer) {
        pos = this.readStringSet(buffer, this.cachedPermissions, pos);
        return pos;
    }

    protected abstract void doIsPermitted(String var1, Handler<AsyncResult<Boolean>> var2);

    private void writeStringSet(Buffer buff, Set<String> set) {
        buff.appendInt(set == null ? 0 : set.size());
        if (set != null) {
            for (String entry : set) {
                byte[] bytes = entry.getBytes(StandardCharsets.UTF_8);
                buff.appendInt(bytes.length).appendBytes(bytes);
            }
        }
    }

    private int readStringSet(Buffer buffer, Set<String> set, int pos) {
        int num = buffer.getInt(pos);
        pos += 4;
        for (int i = 0; i < num; ++i) {
            int len = buffer.getInt(pos);
            byte[] bytes = buffer.getBytes(pos += 4, pos + len);
            pos += len;
            set.add(new String(bytes, StandardCharsets.UTF_8));
        }
        return pos;
    }
}

