/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.abac.impl;

import io.vertx.core.Future;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.abac.Attribute;
import io.vertx.ext.auth.abac.Policy;
import io.vertx.ext.auth.abac.PolicyBasedAuthorizationProvider;
import io.vertx.ext.auth.authorization.Authorization;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class PolicyBasedAuthorizationProviderImpl
implements PolicyBasedAuthorizationProvider {
    private List<Policy> policies;

    public String getId() {
        return "policy";
    }

    public Future<Void> getAuthorizations(User user) {
        Objects.requireNonNull(user, "user cannot be null");
        HashSet<Authorization> authorizations = new HashSet<Authorization>();
        List<Policy> policies = this.policies;
        if (policies != null) {
            int len = policies.size();
            block0: for (int i = 0; i < len; ++i) {
                Policy policy = policies.get(i);
                if (policy.getSubjects() != null && !policy.getSubjects().contains(user.subject())) continue;
                if (policy.getAttributes() != null) {
                    for (Attribute attribute : policy.getAttributes()) {
                        if (attribute.match(user)) continue;
                        continue block0;
                    }
                }
                authorizations.addAll(policy.getAuthorizations());
            }
        }
        user.authorizations().put(this.getId(), authorizations);
        return Future.succeededFuture();
    }

    @Override
    public synchronized PolicyBasedAuthorizationProvider addPolicy(Policy policy) {
        if (this.policies == null) {
            this.policies = new ArrayList<Policy>();
        }
        this.policies.add(policy);
        return this;
    }

    @Override
    public synchronized PolicyBasedAuthorizationProvider setPolicies(List<Policy> policies) {
        this.policies = policies;
        return this;
    }

    @Override
    public synchronized PolicyBasedAuthorizationProvider clear() {
        this.policies = null;
        return this;
    }
}

