/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.abac;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.abac.Attribute;
import io.vertx.ext.auth.abac.impl.AttributeImpl;
import io.vertx.ext.auth.authorization.AndAuthorization;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.OrAuthorization;
import io.vertx.ext.auth.authorization.impl.AuthorizationConverter;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@DataObject
public class Policy {
    private String name;
    private Set<String> subjects;
    private Set<Attribute> attributes;
    private Set<Authorization> authorizations;

    public Policy() {
    }

    public Policy(JsonObject json) {
        this.name = json.getString("name");
        if (json.containsKey("subjects")) {
            this.subjects = json.getJsonArray("subjects").stream().map(String.class::cast).collect(Collectors.toSet());
        }
        if (json.containsKey("attributes")) {
            this.attributes = json.getJsonObject("attributes").stream().map(kv -> new AttributeImpl((String)kv.getKey(), (JsonObject)kv.getValue())).collect(Collectors.toSet());
        }
        if (json.containsKey("authorizations")) {
            this.authorizations = json.getJsonArray("authorizations").stream().map(JsonObject.class::cast).map(AuthorizationConverter::decode).peek(authn -> {
                if (authn instanceof AndAuthorization || authn instanceof OrAuthorization) {
                    throw new IllegalArgumentException("AND/OR Authorizations are not allowed in a policy");
                }
            }).collect(Collectors.toSet());
        }
    }

    public String getName() {
        return this.name;
    }

    public Policy setName(String name) {
        this.name = name;
        return this;
    }

    public Set<String> getSubjects() {
        return this.subjects;
    }

    public Policy addSubject(String subject) {
        if (this.subjects == null) {
            this.subjects = new HashSet<String>();
        }
        this.subjects.add(subject);
        return this;
    }

    public Policy setSubjects(Set<String> subjects) {
        this.subjects = subjects;
        return this;
    }

    public Set<Attribute> getAttributes() {
        return this.attributes;
    }

    public Policy setAttributes(Set<Attribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    public Policy addAttribute(Attribute attribute) {
        Objects.requireNonNull(attribute, "attribute cannot be null");
        if (this.attributes == null) {
            this.attributes = new HashSet<Attribute>();
        }
        this.attributes.add(attribute);
        return this;
    }

    public Set<Authorization> getAuthorizations() {
        return this.authorizations;
    }

    public Policy setAuthorizations(Set<Authorization> authorizations) {
        if (authorizations != null) {
            authorizations.forEach(authn -> {
                if (authn instanceof AndAuthorization || authn instanceof OrAuthorization) {
                    throw new IllegalArgumentException("AND/OR Authorizations are not allowed in a policy");
                }
            });
        }
        this.authorizations = authorizations;
        return this;
    }

    public Policy addAuthorization(Authorization authorization) {
        Objects.requireNonNull(authorization, "authorization cannot be null");
        if (authorization instanceof AndAuthorization || authorization instanceof OrAuthorization) {
            throw new IllegalArgumentException("AND/OR Authorizations are not allowed in a policy");
        }
        if (this.authorizations == null) {
            this.authorizations = new HashSet<Authorization>();
        }
        this.authorizations.add(authorization);
        return this;
    }

    public JsonObject toJson() {
        JsonArray array;
        JsonObject json = new JsonObject();
        if (this.name != null) {
            json.put("name", (Object)this.name);
        }
        if (this.subjects != null) {
            array = new JsonArray();
            this.subjects.forEach(arg_0 -> ((JsonArray)array).add(arg_0));
            json.put("subjects", (Object)array);
        }
        if (this.attributes != null) {
            JsonObject object = new JsonObject();
            this.attributes.forEach(el -> object.mergeIn(el.toJson()));
            json.put("attributes", (Object)object);
        }
        if (this.authorizations != null) {
            array = new JsonArray();
            this.authorizations.forEach(el -> array.add((Object)el.toJson()));
            json.put("authorizations", (Object)array);
        }
        return json;
    }

    public String toString() {
        return this.toJson().encode();
    }
}

