/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.abac.impl;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.abac.Attribute;
import io.vertx.ext.auth.abac.impl.Operator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public class AttributeImpl
implements Attribute {
    private final JsonPointer pointer;
    private final Operator type;
    private final Object value;
    private final Function<User, Boolean> function;

    public AttributeImpl(String pointer, JsonObject json) {
        Objects.requireNonNull(json, "json cannot be null");
        this.pointer = JsonPointer.from((String)pointer);
        Set keys = json.fieldNames();
        if (keys.size() != 1) {
            throw new IllegalArgumentException("json must have exactly one field");
        }
        String key = (String)keys.stream().findFirst().get();
        this.type = Operator.valueOf(key.toUpperCase());
        if (this.type == Operator.FN) {
            throw new IllegalArgumentException("json policy does not allow FN operator");
        }
        this.value = json.getValue(key);
        this.function = null;
    }

    public AttributeImpl(String pointer, Operator operator, Object value) {
        Objects.requireNonNull(pointer, "pointer cannot be null");
        this.pointer = JsonPointer.from((String)pointer);
        this.type = operator;
        this.value = Objects.requireNonNull(value, "value cannot be null");
        this.function = null;
    }

    public AttributeImpl(Function<User, Boolean> function) {
        this.pointer = null;
        this.type = Operator.FN;
        this.function = Objects.requireNonNull(function, "function cannot be null");
        this.value = null;
    }

    @Override
    public boolean match(User user) {
        if (this.type == null) {
            return false;
        }
        switch (this.type) {
            case HAS: {
                JsonObject ctx = new JsonObject().put("principal", (Object)user.principal()).put("attributes", (Object)user.attributes());
                Object obj = this.pointer.queryJson((Object)ctx);
                if (obj instanceof JsonArray) {
                    return ((JsonArray)obj).contains(this.value);
                }
                if (!(obj instanceof JsonObject)) break;
                return ((JsonObject)obj).containsKey((String)this.value);
            }
            case EQ: {
                JsonObject ctx = new JsonObject().put("principal", (Object)user.principal()).put("attributes", (Object)user.attributes());
                Object obj = this.pointer.queryJson((Object)ctx);
                return Objects.equals(obj, this.value);
            }
            case NE: {
                JsonObject ctx = new JsonObject().put("principal", (Object)user.principal()).put("attributes", (Object)user.attributes());
                Object obj = this.pointer.queryJson((Object)ctx);
                return !Objects.equals(obj, this.value);
            }
            case FN: {
                return this.function.apply(user);
            }
        }
        return false;
    }

    @Override
    public JsonObject toJson() {
        if (this.type == Operator.FN) {
            throw new UnsupportedOperationException("Cannot serialize custom attribute function");
        }
        if (this.type != null && this.value != null) {
            return new JsonObject().put(this.pointer.toString(), (Object)new JsonObject().put(this.type.name().toLowerCase(), this.value));
        }
        return null;
    }
}

