/*
 * Decompiled with CFR 0.152.
 */
package io.valkey.providers;

import io.valkey.CommandArguments;
import io.valkey.Connection;
import io.valkey.ConnectionFactory;
import io.valkey.ConnectionPool;
import io.valkey.HostAndPort;
import io.valkey.JedisClientConfig;
import io.valkey.providers.ConnectionProvider;
import io.valkey.util.Pool;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class PooledConnectionProvider
implements ConnectionProvider {
    private final Pool<Connection> pool;
    private Object connectionMapKey = "";

    public PooledConnectionProvider(HostAndPort hostAndPort) {
        this(new ConnectionFactory(hostAndPort));
        this.connectionMapKey = hostAndPort;
    }

    public PooledConnectionProvider(HostAndPort hostAndPort, JedisClientConfig clientConfig) {
        this(new ConnectionPool(hostAndPort, clientConfig));
        this.connectionMapKey = hostAndPort;
    }

    public PooledConnectionProvider(HostAndPort hostAndPort, JedisClientConfig clientConfig, GenericObjectPoolConfig<Connection> poolConfig) {
        this(new ConnectionFactory(hostAndPort, clientConfig), poolConfig);
        this.connectionMapKey = hostAndPort;
    }

    public PooledConnectionProvider(PooledObjectFactory<Connection> factory) {
        this(new ConnectionPool(factory));
        this.connectionMapKey = factory;
    }

    public PooledConnectionProvider(PooledObjectFactory<Connection> factory, GenericObjectPoolConfig<Connection> poolConfig) {
        this(new ConnectionPool(factory, poolConfig));
        this.connectionMapKey = factory;
    }

    private PooledConnectionProvider(Pool<Connection> pool) {
        this.pool = pool;
    }

    @Override
    public void close() {
        this.pool.close();
    }

    public final Pool<Connection> getPool() {
        return this.pool;
    }

    @Override
    public Connection getConnection() {
        return this.pool.getResource();
    }

    @Override
    public Connection getConnection(CommandArguments args) {
        return this.pool.getResource();
    }

    public Map<?, Pool<Connection>> getConnectionMap() {
        return Collections.singletonMap(this.connectionMapKey, this.pool);
    }
}

