/*
 * Decompiled with CFR 0.152.
 */
package io.valkey.util;

import io.valkey.util.KeyValue;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public final class SafeEncoder {
    public static volatile Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;

    private SafeEncoder() {
        throw new InstantiationError("Must not instantiate this class");
    }

    public static byte[][] encodeMany(String ... strs) {
        byte[][] many = new byte[strs.length][];
        for (int i = 0; i < strs.length; ++i) {
            many[i] = SafeEncoder.encode(strs[i]);
        }
        return many;
    }

    public static byte[] encode(String str) {
        if (str == null) {
            throw new IllegalArgumentException("null value cannot be sent to redis");
        }
        return str.getBytes(DEFAULT_CHARSET);
    }

    public static String encode(byte[] data) {
        return new String(data, DEFAULT_CHARSET);
    }

    public static Object encodeObject(Object dataToEncode) {
        if (dataToEncode instanceof byte[]) {
            return SafeEncoder.encode((byte[])dataToEncode);
        }
        if (dataToEncode instanceof KeyValue) {
            KeyValue keyValue = (KeyValue)dataToEncode;
            return new KeyValue<Object, Object>(SafeEncoder.encodeObject(keyValue.getKey()), SafeEncoder.encodeObject(keyValue.getValue()));
        }
        if (dataToEncode instanceof List) {
            List arrayToDecode = (List)dataToEncode;
            ArrayList<Object> returnValueArray = new ArrayList<Object>(arrayToDecode.size());
            for (Object arrayEntry : arrayToDecode) {
                returnValueArray.add(SafeEncoder.encodeObject(arrayEntry));
            }
            return returnValueArray;
        }
        return dataToEncode;
    }
}

