/*
 * Decompiled with CFR 0.152.
 */
package io.valkey.timeseries;

import io.valkey.Builder;
import io.valkey.BuilderFactory;
import io.valkey.timeseries.AggregationType;
import io.valkey.timeseries.DuplicatePolicy;
import io.valkey.util.DoublePrecision;
import io.valkey.util.KeyValue;
import io.valkey.util.SafeEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TSInfo {
    private static final String DUPLICATE_POLICY_PROPERTY = "duplicatePolicy";
    private static final String LABELS_PROPERTY = "labels";
    private static final String RULES_PROPERTY = "rules";
    private static final String CHUNKS_PROPERTY = "Chunks";
    private static final String CHUNKS_BYTES_PER_SAMPLE_PROPERTY = "bytesPerSample";
    private final Map<String, Object> properties;
    private final Map<String, String> labels;
    private final Map<String, Rule> rules;
    private final List<Map<String, Object>> chunks;
    public static Builder<TSInfo> TIMESERIES_INFO = new Builder<TSInfo>(){

        @Override
        public TSInfo build(Object data) {
            List list = (List)data;
            HashMap properties = new HashMap();
            Map<String, String> labels = null;
            HashMap<String, Rule> rules = null;
            ArrayList<Map<String, Object>> chunks = null;
            for (int i = 0; i < list.size(); i += 2) {
                String prop = SafeEncoder.encode((byte[])list.get(i));
                Object value = list.get(i + 1);
                if (value instanceof List) {
                    switch (prop) {
                        case "labels": {
                            labels = BuilderFactory.STRING_MAP_FROM_PAIRS.build(value);
                            value = labels;
                            break;
                        }
                        case "rules": {
                            List rulesDataList = (List)value;
                            ArrayList<List> rulesValueList = new ArrayList<List>(rulesDataList.size());
                            rules = new HashMap<String, Rule>(rulesDataList.size());
                            for (Object ruleData : rulesDataList) {
                                List encodedRule = (List)SafeEncoder.encodeObject(ruleData);
                                rulesValueList.add(encodedRule);
                                rules.put((String)encodedRule.get(0), new Rule((String)encodedRule.get(0), (Long)encodedRule.get(1), AggregationType.safeValueOf((String)encodedRule.get(2)), (Long)encodedRule.get(3)));
                            }
                            value = rulesValueList;
                            break;
                        }
                        case "Chunks": {
                            List chunksDataList = (List)value;
                            ArrayList<HashMap<String, Object>> chunksValueList = new ArrayList<HashMap<String, Object>>(chunksDataList.size());
                            chunks = new ArrayList<Map<String, Object>>(chunksDataList.size());
                            for (Object chunkData : chunksDataList) {
                                Map<String, Object> chunk = BuilderFactory.ENCODED_OBJECT_MAP.build(chunkData);
                                chunksValueList.add(new HashMap<String, Object>(chunk));
                                if (chunk.containsKey(TSInfo.CHUNKS_BYTES_PER_SAMPLE_PROPERTY)) {
                                    chunk.put(TSInfo.CHUNKS_BYTES_PER_SAMPLE_PROPERTY, DoublePrecision.parseEncodedFloatingPointNumber(chunk.get(TSInfo.CHUNKS_BYTES_PER_SAMPLE_PROPERTY)));
                                }
                                chunks.add(chunk);
                            }
                            value = chunksValueList;
                            break;
                        }
                        default: {
                            value = SafeEncoder.encodeObject(value);
                            break;
                        }
                    }
                } else if (value instanceof byte[]) {
                    value = SafeEncoder.encode((byte[])value);
                    if (TSInfo.DUPLICATE_POLICY_PROPERTY.equals(prop)) {
                        try {
                            value = DuplicatePolicy.valueOf(((String)value).toUpperCase());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                properties.put(prop, value);
            }
            return new TSInfo(properties, labels, rules, chunks);
        }
    };
    public static Builder<TSInfo> TIMESERIES_INFO_RESP3 = new Builder<TSInfo>(){

        @Override
        public TSInfo build(Object data) {
            List list = (List)data;
            HashMap properties = new HashMap();
            Map<String, String> labels = null;
            HashMap<String, Rule> rules = null;
            ArrayList<Map<String, Object>> chunks = null;
            for (KeyValue propertyValue : list) {
                String prop = BuilderFactory.STRING.build(propertyValue.getKey());
                Object value = propertyValue.getValue();
                if (value instanceof List) {
                    switch (prop) {
                        case "labels": {
                            labels = BuilderFactory.STRING_MAP.build(value);
                            value = labels;
                            break;
                        }
                        case "rules": {
                            List rulesDataList = (List)value;
                            HashMap<String, List<Object>> rulesValueMap = new HashMap<String, List<Object>>(rulesDataList.size(), 1.0f);
                            rules = new HashMap<String, Rule>(rulesDataList.size());
                            for (KeyValue rkv : rulesDataList) {
                                String ruleName = BuilderFactory.STRING.build(rkv.getKey());
                                List<Object> ruleValueList = BuilderFactory.ENCODED_OBJECT_LIST.build(rkv.getValue());
                                rulesValueMap.put(ruleName, ruleValueList);
                                rules.put(ruleName, new Rule(ruleName, ruleValueList));
                            }
                            value = rulesValueMap;
                            break;
                        }
                        case "Chunks": {
                            List chunksDataList = (List)value;
                            ArrayList<Map<String, Object>> chunksValueList = new ArrayList<Map<String, Object>>(chunksDataList.size());
                            chunks = new ArrayList<Map<String, Object>>(chunksDataList.size());
                            for (List chunkDataAsList : chunksDataList) {
                                Map<String, Object> chunk = chunkDataAsList.stream().collect(Collectors.toMap(kv -> BuilderFactory.STRING.build(kv.getKey()), kv -> BuilderFactory.ENCODED_OBJECT.build(kv.getValue())));
                                chunksValueList.add(chunk);
                                chunks.add(chunk);
                            }
                            value = chunksValueList;
                            break;
                        }
                        default: {
                            value = SafeEncoder.encodeObject(value);
                            break;
                        }
                    }
                } else if (value instanceof byte[]) {
                    value = BuilderFactory.STRING.build(value);
                    if (TSInfo.DUPLICATE_POLICY_PROPERTY.equals(prop)) {
                        try {
                            value = DuplicatePolicy.valueOf(((String)value).toUpperCase());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                properties.put(prop, value);
            }
            return new TSInfo(properties, labels, rules, chunks);
        }
    };

    private TSInfo(Map<String, Object> properties, Map<String, String> labels, Map<String, Rule> rules, List<Map<String, Object>> chunks) {
        this.properties = properties;
        this.labels = labels;
        this.rules = rules;
        this.chunks = chunks;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Object getProperty(String property) {
        return this.properties.get(property);
    }

    public Long getIntegerProperty(String property) {
        return (Long)this.properties.get(property);
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public String getLabel(String label) {
        return this.labels.get(label);
    }

    public Map<String, Rule> getRules() {
        return this.rules;
    }

    public Rule getRule(String rule) {
        return this.rules.get(rule);
    }

    public List<Map<String, Object>> getChunks() {
        return this.chunks;
    }

    public static class Rule {
        private final String compactionKey;
        private final long bucketDuration;
        private final AggregationType aggregator;
        private final long alignmentTimestamp;

        private Rule(String compaction, List<Object> encodedValues) {
            this(compaction, (Long)encodedValues.get(0), AggregationType.safeValueOf((String)encodedValues.get(1)), (Long)encodedValues.get(2));
        }

        private Rule(String compaction, long bucket, AggregationType aggregation, long alignment) {
            this.compactionKey = compaction;
            this.bucketDuration = bucket;
            this.aggregator = aggregation;
            this.alignmentTimestamp = alignment;
        }

        public String getCompactionKey() {
            return this.compactionKey;
        }

        public long getBucketDuration() {
            return this.bucketDuration;
        }

        public AggregationType getAggregator() {
            return this.aggregator;
        }

        public long getAlignmentTimestamp() {
            return this.alignmentTimestamp;
        }
    }
}

