/*
 * Decompiled with CFR 0.152.
 */
package io.valkey.mcf;

import io.valkey.CommandArguments;
import io.valkey.CommandObject;
import io.valkey.CommandObjects;
import io.valkey.Connection;
import io.valkey.PipelineBase;
import io.valkey.RedisProtocol;
import io.valkey.Response;
import io.valkey.annots.Experimental;
import io.valkey.graph.ResultSet;
import io.valkey.mcf.CircuitBreakerFailoverConnectionProvider;
import io.valkey.providers.MultiClusterPooledConnectionProvider;
import io.valkey.util.KeyValue;
import java.io.Closeable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;

@Experimental
public class MultiClusterPipeline
extends PipelineBase
implements Closeable {
    private final CircuitBreakerFailoverConnectionProvider failoverProvider;
    private final Queue<KeyValue<CommandArguments, Response<?>>> commands = new LinkedList();

    @Deprecated
    public MultiClusterPipeline(MultiClusterPooledConnectionProvider pooledProvider) {
        super(new CommandObjects());
        this.failoverProvider = new CircuitBreakerFailoverConnectionProvider(pooledProvider);
        try (Connection connection = this.failoverProvider.getConnection();){
            RedisProtocol proto = connection.getRedisProtocol();
            if (proto != null) {
                this.commandObjects.setProtocol(proto);
            }
        }
    }

    public MultiClusterPipeline(MultiClusterPooledConnectionProvider pooledProvider, CommandObjects commandObjects) {
        super(commandObjects);
        this.failoverProvider = new CircuitBreakerFailoverConnectionProvider(pooledProvider);
    }

    @Override
    protected final <T> Response<T> appendCommand(CommandObject<T> commandObject) {
        CommandArguments args = commandObject.getArguments();
        Response<T> response = new Response<T>(commandObject.getBuilder());
        this.commands.add(KeyValue.of(args, response));
        return response;
    }

    @Override
    public void close() {
        this.sync();
    }

    @Override
    public void sync() {
        if (this.commands.isEmpty()) {
            return;
        }
        try (Connection connection = this.failoverProvider.getConnection();){
            this.commands.forEach(command -> connection.sendCommand((CommandArguments)command.getKey()));
            List<Object> unformatted = connection.getMany(this.commands.size());
            unformatted.forEach(rawReply -> ((Response)this.commands.poll().getValue()).set(rawReply));
        }
    }

    public Response<Long> waitReplicas(int replicas, long timeout) {
        return this.appendCommand(this.commandObjects.waitReplicas(replicas, timeout));
    }

    public Response<KeyValue<Long, Long>> waitAOF(long numLocal, long numReplicas, long timeout) {
        return this.appendCommand(this.commandObjects.waitAOF(numLocal, numReplicas, timeout));
    }

    @Override
    public Response<ResultSet> graphQuery(String name, String query) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphReadonlyQuery(String name, String query) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphQuery(String name, String query, long timeout) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphReadonlyQuery(String name, String query, long timeout) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphQuery(String name, String query, Map<String, Object> params) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphReadonlyQuery(String name, String query, Map<String, Object> params) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphQuery(String name, String query, Map<String, Object> params, long timeout) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphReadonlyQuery(String name, String query, Map<String, Object> params, long timeout) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<String> graphDelete(String name) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<List<String>> graphProfile(String graphName, String query) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }
}

