/*
 * Decompiled with CFR 0.152.
 */
package io.valkey.args;

import io.valkey.Protocol;
import io.valkey.args.Rawable;
import io.valkey.util.SafeEncoder;
import java.util.Arrays;

public final class RawableFactory {
    public static Rawable from(int i) {
        return RawableFactory.from(Protocol.toByteArray(i));
    }

    public static Rawable from(double d) {
        return RawableFactory.from(Protocol.toByteArray(d));
    }

    public static Rawable from(byte[] binary) {
        return new Raw(binary);
    }

    public static Rawable from(String string) {
        return new RawString(string);
    }

    private RawableFactory() {
        throw new InstantiationError();
    }

    public static class RawString
    implements Rawable {
        private final byte[] raw;

        public RawString(String str) {
            this.raw = SafeEncoder.encode(str);
        }

        @Override
        public byte[] getRaw() {
            return this.raw;
        }
    }

    public static class Raw
    implements Rawable {
        private final byte[] raw;

        public Raw(byte[] raw) {
            this.raw = Arrays.copyOf(raw, raw.length);
        }

        @Override
        public byte[] getRaw() {
            return this.raw;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return Arrays.equals(this.raw, ((Raw)o).raw);
        }

        public int hashCode() {
            return Arrays.hashCode(this.raw);
        }
    }
}

