/*
 * Decompiled with CFR 0.152.
 */
package glide.internal;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import glide.api.BaseClient;
import glide.api.logging.Logger;
import glide.api.models.GlideString;
import glide.api.models.PubSubMessage;
import glide.api.models.exceptions.ClosingException;
import glide.api.models.exceptions.RequestException;
import glide.ffi.resolvers.NativeUtils;
import glide.internal.AsyncRegistry;
import glide.internal.GlideNativeBridge;
import java.lang.ref.Cleaner;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class GlideCoreClient
implements AutoCloseable {
    private static final Cleaner CLEANER = Cleaner.create();
    private static final ConcurrentHashMap<Long, WeakReference<BaseClient>> clients;
    public static final byte[][] EMPTY_2D_BYTE_ARRAY;
    private final AtomicLong nativeClientHandle = new AtomicLong(0L);
    private final int maxInflightRequests;
    private final AtomicBoolean cleanupInProgress = new AtomicBoolean(false);
    private final Cleaner.Cleanable cleanable;
    private final NativeState nativeState;

    private static native void onNativeInit();

    private static native void freeNativeBuffer(long var0);

    public static void registerClient(long handle, BaseClient client) {
        clients.put(handle, new WeakReference<BaseClient>(client));
    }

    public static void unregisterClient(long handle) {
        clients.remove(handle);
    }

    private static void onNativePush(long handle, byte[] message, byte[] channel, byte[] pattern) {
        BaseClient c;
        GlideString msg = GlideString.of(message);
        GlideString ch = GlideString.of(channel);
        PubSubMessage m = pattern != null && pattern.length > 0 ? new PubSubMessage(msg, ch, GlideString.of(pattern)) : new PubSubMessage(msg, ch);
        WeakReference<BaseClient> ref = clients.get(handle);
        if (ref != null && (c = (BaseClient)ref.get()) != null) {
            c.__enqueuePubSubMessage(m);
        }
    }

    static void registerNativeBufferCleaner(ByteBuffer buffer, long id) {
        if (buffer == null || id == 0L) {
            return;
        }
        CLEANER.register(buffer, () -> {
            try {
                GlideCoreClient.freeNativeBuffer(id);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    public long getNativeHandle() {
        return this.nativeClientHandle.get();
    }

    public int getMaxInflightRequests() {
        return this.maxInflightRequests;
    }

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Constructor fails fast on invalid handles prior to registering resources")
    public GlideCoreClient(long existingHandle, int maxInflight) {
        if (existingHandle == 0L) {
            throw new IllegalArgumentException("Native handle cannot be zero");
        }
        this.maxInflightRequests = maxInflight > 0 ? maxInflight : 0;
        this.nativeClientHandle.set(existingHandle);
        this.nativeState = new NativeState(existingHandle);
        this.cleanable = CLEANER.register(this, new CleanupAction(this.nativeState));
    }

    public CompletableFuture<Object> executeBinaryCommandAsync(byte[] requestBytes) {
        try {
            long correlationId;
            long handle = this.nativeClientHandle.get();
            if (handle == 0L) {
                CompletableFuture<Object> future = new CompletableFuture<Object>();
                future.completeExceptionally(new ClosingException("Client is closed"));
                return future;
            }
            CompletableFuture<Object> future = new CompletableFuture<Object>();
            try {
                correlationId = AsyncRegistry.register(future, this.maxInflightRequests, handle);
            }
            catch (RequestException e) {
                future.completeExceptionally(e);
                return future;
            }
            GlideNativeBridge.executeBinaryCommandAsync(handle, requestBytes, correlationId);
            return future;
        }
        catch (Exception e) {
            CompletableFuture<Object> future = new CompletableFuture<Object>();
            future.completeExceptionally(e);
            return future;
        }
    }

    public CompletableFuture<Object> executeCommandAsync(byte[] requestBytes) {
        try {
            long correlationId;
            long handle = this.nativeClientHandle.get();
            if (handle == 0L) {
                CompletableFuture<Object> future = new CompletableFuture<Object>();
                future.completeExceptionally(new ClosingException("Client is closed"));
                return future;
            }
            CompletableFuture<Object> future = new CompletableFuture<Object>();
            try {
                correlationId = AsyncRegistry.register(future, this.maxInflightRequests, handle);
            }
            catch (RequestException e) {
                future.completeExceptionally(e);
                return future;
            }
            GlideNativeBridge.executeCommandAsync(handle, requestBytes, correlationId);
            return future;
        }
        catch (Exception e) {
            CompletableFuture<Object> future = new CompletableFuture<Object>();
            future.completeExceptionally(e);
            return future;
        }
    }

    public CompletableFuture<Object> executeBatchAsync(byte[] batchRequestBytes, boolean expectUtf8Response) {
        try {
            long correlationId;
            long handle = this.nativeClientHandle.get();
            if (handle == 0L) {
                CompletableFuture<Object> future = new CompletableFuture<Object>();
                future.completeExceptionally(new ClosingException("Client is closed"));
                return future;
            }
            CompletableFuture<Object> future = new CompletableFuture<Object>();
            try {
                correlationId = AsyncRegistry.register(future, this.maxInflightRequests, handle);
            }
            catch (RequestException e) {
                future.completeExceptionally(e);
                return future;
            }
            GlideNativeBridge.executeBatchAsync(handle, batchRequestBytes, expectUtf8Response, correlationId);
            return future;
        }
        catch (Exception e) {
            CompletableFuture<Object> future = new CompletableFuture<Object>();
            future.completeExceptionally(e);
            return future;
        }
    }

    public CompletableFuture<Object> executeClusterScanAsync(String cursorId, String matchPattern, long count, String objectType, boolean expectUtf8Response) {
        try {
            long correlationId;
            long handle = this.nativeClientHandle.get();
            if (handle == 0L) {
                CompletableFuture<Object> future = new CompletableFuture<Object>();
                future.completeExceptionally(new ClosingException("Client is closed"));
                return future;
            }
            CompletableFuture<Object> future = new CompletableFuture<Object>();
            try {
                correlationId = AsyncRegistry.register(future, this.maxInflightRequests, handle);
            }
            catch (RequestException e) {
                future.completeExceptionally(e);
                return future;
            }
            GlideNativeBridge.executeClusterScanAsync(handle, cursorId, matchPattern, count, objectType, expectUtf8Response, correlationId);
            return future;
        }
        catch (Exception e) {
            CompletableFuture<Object> future = new CompletableFuture<Object>();
            future.completeExceptionally(e);
            return future;
        }
    }

    public CompletableFuture<String> updateConnectionPassword(String password, boolean immediateAuth) {
        long correlationId;
        long handle = this.nativeClientHandle.get();
        if (handle == 0L) {
            CompletableFuture<String> f = new CompletableFuture<String>();
            f.completeExceptionally(new ClosingException("Client is closed"));
            return f;
        }
        CompletableFuture<String> future = new CompletableFuture<String>();
        try {
            correlationId = AsyncRegistry.register(future, this.maxInflightRequests, handle);
        }
        catch (RequestException e) {
            future.completeExceptionally(e);
            return future;
        }
        GlideNativeBridge.updateConnectionPassword(handle, password, immediateAuth, correlationId);
        return future;
    }

    public CompletableFuture<String> refreshIamToken() {
        long correlationId;
        CompletableFuture<String> future = new CompletableFuture<String>();
        long handle = this.nativeClientHandle.get();
        if (handle == 0L) {
            future.completeExceptionally(new ClosingException("Client is closed"));
            return future;
        }
        try {
            correlationId = AsyncRegistry.register(future, this.maxInflightRequests, handle);
        }
        catch (RequestException e) {
            future.completeExceptionally(e);
            return future;
        }
        GlideNativeBridge.refreshIamToken(handle, correlationId);
        return future;
    }

    public CompletableFuture<Object> executeScriptAsync(String hash, byte[][] keys, byte[][] args, boolean hasRoute, int routeType, String routeParam, boolean expectUtf8Response) {
        try {
            long correlationId;
            long handle = this.nativeClientHandle.get();
            if (handle == 0L) {
                CompletableFuture<Object> future = new CompletableFuture<Object>();
                future.completeExceptionally(new ClosingException("Client is closed"));
                return future;
            }
            CompletableFuture<Object> future = new CompletableFuture<Object>();
            try {
                correlationId = AsyncRegistry.register(future, this.maxInflightRequests, handle);
            }
            catch (RequestException e) {
                future.completeExceptionally(e);
                return future;
            }
            GlideNativeBridge.executeScriptAsync(handle, correlationId, hash, keys != null ? keys : EMPTY_2D_BYTE_ARRAY, args != null ? args : EMPTY_2D_BYTE_ARRAY, hasRoute, routeType, routeParam, expectUtf8Response);
            return future;
        }
        catch (Exception e) {
            CompletableFuture<Object> future = new CompletableFuture<Object>();
            future.completeExceptionally(e);
            return future;
        }
    }

    public boolean isConnected() {
        long handle = this.nativeClientHandle.get();
        return handle != 0L && GlideNativeBridge.isConnected(handle);
    }

    public String getClientInfo() {
        long handle = this.nativeClientHandle.get();
        if (handle == 0L) {
            return "Client is closed";
        }
        return GlideNativeBridge.getClientInfo(handle);
    }

    public int getPendingOperations() {
        return AsyncRegistry.getPendingCount();
    }

    public boolean isHealthy() {
        return this.isConnected() && AsyncRegistry.getPendingCount() < 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.cleanupInProgress.compareAndSet(false, true)) {
            return;
        }
        long handle = this.nativeClientHandle.getAndSet(0L);
        if (handle != 0L) {
            try {
                GlideCoreClient.unregisterClient(handle);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                AsyncRegistry.cleanupClient(handle);
                GlideNativeBridge.closeClient(handle);
            }
            finally {
                if (clients.isEmpty()) {
                    AsyncRegistry.reset();
                }
            }
        }
        this.cleanable.clean();
    }

    static {
        try {
            NativeUtils.loadGlideLib();
        }
        catch (Exception e) {
            Logger.log(Logger.Level.ERROR, "GlideCoreClient", "Failed to load native library: " + e.getMessage());
            throw new RuntimeException("Failed to load native library", e);
        }
        GlideCoreClient.onNativeInit();
        clients = new ConcurrentHashMap();
        EMPTY_2D_BYTE_ARRAY = new byte[0][];
    }

    private static class CleanupAction
    implements Runnable {
        private final NativeState nativeState;

        CleanupAction(NativeState nativeState) {
            this.nativeState = nativeState;
        }

        @Override
        public void run() {
            long ptr = this.nativeState.nativePtr;
            if (ptr != 0L) {
                this.nativeState.nativePtr = 0L;
                AsyncRegistry.cleanupClient(ptr);
                GlideNativeBridge.closeClient(ptr);
            }
        }
    }

    private static class NativeState {
        volatile long nativePtr;

        NativeState(long nativePtr) {
            this.nativePtr = nativePtr;
        }
    }
}

