/*
 * Decompiled with CFR 0.152.
 */
package glide.managers;

import command_request.CommandRequestOuterClass;
import glide.api.OpenTelemetry;
import glide.api.models.Batch;
import glide.api.models.ClusterBatch;
import glide.api.models.GlideString;
import glide.api.models.Script;
import glide.api.models.commands.batch.BaseBatchOptions;
import glide.api.models.commands.batch.BatchOptions;
import glide.api.models.commands.batch.ClusterBatchOptions;
import glide.api.models.commands.scan.ClusterScanCursor;
import glide.api.models.commands.scan.ScanOptions;
import glide.api.models.configuration.RequestRoutingConfiguration;
import glide.api.models.exceptions.ClosingException;
import glide.api.models.exceptions.RequestException;
import glide.com.google.protobuf.ByteString;
import glide.com.google.protobuf.UnsafeByteOperations;
import glide.ffi.resolvers.ClusterScanCursorResolver;
import glide.ffi.resolvers.OpenTelemetryResolver;
import glide.internal.GlideCoreClient;
import glide.managers.GlideExceptionCheckedFunction;
import glide.managers.JniResponseRegistry;
import glide.utils.BufferUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import lombok.NonNull;
import response.ResponseOuterClass;

public class CommandManager {
    private final GlideCoreClient coreClient;

    public <T> CompletableFuture<T> submitNewCommand(CommandRequestOuterClass.RequestType requestType, String[] arguments, GlideExceptionCheckedFunction<ResponseOuterClass.Response, T> responseHandler) {
        CommandRequestOuterClass.CommandRequest.Builder command = this.prepareCommandRequest(requestType, arguments);
        return this.submitCommandToJni(command, responseHandler, false, true);
    }

    public <T> CompletableFuture<T> submitNewCommand(CommandRequestOuterClass.RequestType requestType, GlideString[] arguments, GlideExceptionCheckedFunction<ResponseOuterClass.Response, T> responseHandler) {
        CommandRequestOuterClass.CommandRequest.Builder command = this.prepareCommandRequest(requestType, arguments);
        return this.submitCommandToJni(command, responseHandler, true, false);
    }

    public <T> CompletableFuture<T> submitNewCommandWithResponseType(CommandRequestOuterClass.RequestType requestType, GlideString[] arguments, GlideExceptionCheckedFunction<ResponseOuterClass.Response, T> responseHandler, boolean expectUtf8Response) {
        CommandRequestOuterClass.CommandRequest.Builder command = this.prepareCommandRequest(requestType, arguments);
        return this.submitCommandToJni(command, responseHandler, true, expectUtf8Response);
    }

    public <T> CompletableFuture<T> submitNewCommandWithResponseType(CommandRequestOuterClass.RequestType requestType, GlideString[] arguments, RequestRoutingConfiguration.Route route, GlideExceptionCheckedFunction<ResponseOuterClass.Response, T> responseHandler, boolean expectUtf8Response) {
        CommandRequestOuterClass.CommandRequest.Builder command = this.prepareCommandRequest(requestType, arguments, route);
        return this.submitCommandToJni(command, responseHandler, true, expectUtf8Response);
    }

    public <T> CompletableFuture<T> submitNewCommand(CommandRequestOuterClass.RequestType requestType, String[] arguments, RequestRoutingConfiguration.Route route, GlideExceptionCheckedFunction<ResponseOuterClass.Response, T> responseHandler) {
        CommandRequestOuterClass.CommandRequest.Builder command = this.prepareCommandRequest(requestType, arguments, route);
        return this.submitCommandToJni(command, responseHandler, false, true);
    }

    public <T> CompletableFuture<T> submitNewCommand(CommandRequestOuterClass.RequestType requestType, GlideString[] arguments, RequestRoutingConfiguration.Route route, GlideExceptionCheckedFunction<ResponseOuterClass.Response, T> responseHandler) {
        CommandRequestOuterClass.CommandRequest.Builder command = this.prepareCommandRequest(requestType, arguments, route);
        return this.submitCommandToJni(command, responseHandler, true, false);
    }

    public <T> CompletableFuture<T> submitObjectEncoding(GlideString[] arguments, GlideExceptionCheckedFunction<ResponseOuterClass.Response, T> responseHandler) {
        CommandRequestOuterClass.CommandRequest.Builder command = this.prepareCommandRequest(CommandRequestOuterClass.RequestType.ObjectEncoding, arguments);
        return this.submitCommandToJni(command, responseHandler, true, true);
    }

    public <T> CompletableFuture<T> submitObjectEncoding(GlideString[] arguments, RequestRoutingConfiguration.Route route, GlideExceptionCheckedFunction<ResponseOuterClass.Response, T> responseHandler) {
        CommandRequestOuterClass.CommandRequest.Builder command = this.prepareCommandRequest(CommandRequestOuterClass.RequestType.ObjectEncoding, arguments, route);
        return this.submitCommandToJni(command, responseHandler, true, true);
    }

    public <T> CompletableFuture<T> submitNewBatch(Batch batch, boolean raiseOnError, Optional<BatchOptions> options, GlideExceptionCheckedFunction<ResponseOuterClass.Response, T> responseHandler) {
        CommandRequestOuterClass.CommandRequest.Builder command = this.prepareCommandRequest(batch, raiseOnError, options);
        boolean expectUtf8Response = !batch.isBinaryOutput();
        return this.submitBatchToJni(command, responseHandler, expectUtf8Response);
    }

    public <T> CompletableFuture<T> submitScript(Script script, List<GlideString> keys, List<GlideString> args, GlideExceptionCheckedFunction<ResponseOuterClass.Response, T> responseHandler) {
        if (!this.coreClient.isConnected()) {
            CompletableFuture errorFuture = new CompletableFuture();
            errorFuture.completeExceptionally(new ClosingException("Client closed: Unable to submit script."));
            return errorFuture;
        }
        try {
            byte[][] keyArgs = CommandManager.toByteMatrix(keys);
            byte[][] argArgs = CommandManager.toByteMatrix(args);
            boolean expectUtf8Response = script.getBinaryOutput() == null || script.getBinaryOutput() == false;
            CompletableFuture<Object> jniFuture = this.coreClient.executeScriptAsync(script.getHash(), keyArgs, argArgs, false, 0, null, expectUtf8Response);
            return ((CompletableFuture)((CompletableFuture)jniFuture.thenApply(result -> this.createDirectResponse(result, expectUtf8Response))).thenApply(responseHandler::apply)).exceptionally(this::exceptionHandler);
        }
        catch (Exception e) {
            CompletableFuture errorFuture = new CompletableFuture();
            errorFuture.completeExceptionally(e);
            return errorFuture;
        }
    }

    public <T> CompletableFuture<T> submitScript(Script script, List<GlideString> args, RequestRoutingConfiguration.Route route, GlideExceptionCheckedFunction<ResponseOuterClass.Response, T> responseHandler) {
        if (!this.coreClient.isConnected()) {
            CompletableFuture errorFuture = new CompletableFuture();
            errorFuture.completeExceptionally(new ClosingException("Client closed: Unable to submit script."));
            return errorFuture;
        }
        try {
            byte[][] keyArgs = GlideCoreClient.EMPTY_2D_BYTE_ARRAY;
            byte[][] argArgs = CommandManager.toByteMatrix(args);
            boolean expectUtf8Response = script.getBinaryOutput() == null || script.getBinaryOutput() == false;
            ScriptRouteArgs routeArgs = this.computeScriptRouteArgs(route);
            CompletableFuture<Object> jniFuture = this.coreClient.executeScriptAsync(script.getHash(), keyArgs, argArgs, routeArgs.hasRoute, routeArgs.routeType, routeArgs.routeParam, expectUtf8Response);
            return ((CompletableFuture)((CompletableFuture)jniFuture.thenApply(result -> this.createDirectResponse(result, expectUtf8Response))).thenApply(responseHandler::apply)).exceptionally(this::exceptionHandler);
        }
        catch (Exception e) {
            CompletableFuture errorFuture = new CompletableFuture();
            errorFuture.completeExceptionally(e);
            return errorFuture;
        }
    }

    private ScriptRouteArgs computeScriptRouteArgs(RequestRoutingConfiguration.Route route) {
        if (route == null) {
            return new ScriptRouteArgs(false, 0, null);
        }
        if (route instanceof RequestRoutingConfiguration.SimpleMultiNodeRoute) {
            return new ScriptRouteArgs(true, ((RequestRoutingConfiguration.SimpleMultiNodeRoute)route).getOrdinal(), null);
        }
        if (route instanceof RequestRoutingConfiguration.SimpleSingleNodeRoute) {
            return new ScriptRouteArgs(true, ((RequestRoutingConfiguration.SimpleSingleNodeRoute)route).getOrdinal(), null);
        }
        if (route instanceof RequestRoutingConfiguration.SlotKeyRoute) {
            int routeType = ((RequestRoutingConfiguration.SlotKeyRoute)route).getSlotType().ordinal();
            String routeParam = ((RequestRoutingConfiguration.SlotKeyRoute)route).getSlotKey();
            return new ScriptRouteArgs(true, routeType, routeParam);
        }
        if (route instanceof RequestRoutingConfiguration.SlotIdRoute) {
            int routeType = ((RequestRoutingConfiguration.SlotIdRoute)route).getSlotType().ordinal();
            String routeParam = Integer.toString(((RequestRoutingConfiguration.SlotIdRoute)route).getSlotId());
            return new ScriptRouteArgs(true, routeType, routeParam);
        }
        if (route instanceof RequestRoutingConfiguration.ByAddressRoute) {
            String hostPort = ((RequestRoutingConfiguration.ByAddressRoute)route).getHost() + ":" + ((RequestRoutingConfiguration.ByAddressRoute)route).getPort();
            return new ScriptRouteArgs(true, -1, hostPort);
        }
        throw new RequestException(String.format("Unsupported route type for script invocation: %s", route.getClass().getSimpleName()));
    }

    public <T> CompletableFuture<T> submitNewBatch(ClusterBatch batch, boolean raiseOnError, Optional<ClusterBatchOptions> options, GlideExceptionCheckedFunction<ResponseOuterClass.Response, T> responseHandler) {
        CommandRequestOuterClass.CommandRequest.Builder command = this.prepareCommandRequest(batch, raiseOnError, options);
        boolean expectUtf8Response = !batch.isBinaryOutput();
        return this.submitBatchToJni(command, responseHandler, expectUtf8Response);
    }

    private static byte[][] toByteMatrix(List<GlideString> values) {
        if (values == null || values.isEmpty()) {
            return GlideCoreClient.EMPTY_2D_BYTE_ARRAY;
        }
        byte[][] result = new byte[values.size()][];
        for (int i = 0; i < values.size(); ++i) {
            GlideString value = values.get(i);
            result[i] = value != null ? value.getBytes() : null;
        }
        return result;
    }

    public <T> CompletableFuture<T> submitClusterScan(ClusterScanCursor cursor, @NonNull ScanOptions options, GlideExceptionCheckedFunction<ResponseOuterClass.Response, T> responseHandler) {
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        return this.submitClusterScanToJni(cursor, options, responseHandler, true);
    }

    public <T> CompletableFuture<T> submitClusterScanToJni(ClusterScanCursor cursor, @NonNull ScanOptions options, GlideExceptionCheckedFunction<ResponseOuterClass.Response, T> responseHandler, boolean expectUtf8Response) {
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        if (!this.coreClient.isConnected()) {
            CompletableFuture errorFuture = new CompletableFuture();
            errorFuture.completeExceptionally(new ClosingException("Client closed: Unable to submit cluster scan."));
            return errorFuture;
        }
        try {
            String cursorId = this.getCursorId(cursor);
            String matchPattern = options.getMatchPattern() != null ? options.getMatchPattern().toString() : null;
            Long count = options.getCount() != null ? options.getCount() : null;
            ScanOptions.ObjectType type = options.getType();
            String objectType = null;
            if (type != null && ((objectType = type.getNativeName()) == null || objectType.isEmpty())) {
                objectType = type.name();
            }
            return ((CompletableFuture)this.coreClient.executeClusterScanAsync(cursorId, matchPattern, count != null ? count : 0L, objectType, expectUtf8Response).thenApply(result -> {
                ResponseOuterClass.Response.Builder builder = ResponseOuterClass.Response.newBuilder();
                Object[] normalized = result == null ? new Object[]{ClusterScanCursorResolver.getFinishedCursorHandleConstant(), new Object[0]} : this.normalizeScanResult(result, expectUtf8Response);
                long objectId = JniResponseRegistry.storeObject(normalized);
                builder.setRespPointer(objectId);
                Object out = responseHandler.apply(builder.build());
                if (out == null) {
                    Object[] fallback = new Object[]{ClusterScanCursorResolver.getFinishedCursorHandleConstant(), new Object[0]};
                    return fallback;
                }
                return out;
            })).exceptionally(this::exceptionHandler);
        }
        catch (Exception e) {
            CompletableFuture errorFuture = new CompletableFuture();
            errorFuture.completeExceptionally(e);
            return errorFuture;
        }
    }

    private Object normalizeScanResult(Object result, boolean expectUtf8) {
        if (!(result instanceof Object[])) {
            return result;
        }
        Object[] arr = (Object[])result;
        if (arr.length != 2) {
            return result;
        }
        Object cursorObj = arr[0];
        String cursor = cursorObj instanceof byte[] ? new String((byte[])cursorObj, StandardCharsets.UTF_8) : String.valueOf(cursorObj);
        Object itemsObj = arr[1];
        if (itemsObj instanceof Object[]) {
            Object[] items = (Object[])itemsObj;
            if (expectUtf8) {
                for (int i = 0; i < items.length; ++i) {
                    if (!(items[i] instanceof byte[])) continue;
                    items[i] = new String((byte[])items[i], StandardCharsets.UTF_8);
                }
                return new Object[]{cursor, items};
            }
            for (int i = 0; i < items.length; ++i) {
                if (!(items[i] instanceof byte[])) continue;
                items[i] = GlideString.gs((byte[])items[i]);
            }
            return new Object[]{cursor, items};
        }
        return new Object[]{cursor, itemsObj};
    }

    public <T> CompletableFuture<T> submitPasswordUpdate(Optional<String> password, boolean immediateAuth, GlideExceptionCheckedFunction<ResponseOuterClass.Response, T> responseHandler) {
        return this.coreClient.updateConnectionPassword(password.orElse(null), immediateAuth).thenApply(result -> {
            ResponseOuterClass.Response.Builder responseBuilder = ResponseOuterClass.Response.newBuilder();
            if ("OK".equals(result)) {
                responseBuilder.setConstantResponse(ResponseOuterClass.ConstantResponse.OK);
            }
            return responseHandler.apply(responseBuilder.build());
        });
    }

    public <T> CompletableFuture<T> submitRefreshIamToken(GlideExceptionCheckedFunction<ResponseOuterClass.Response, T> responseHandler) {
        return this.coreClient.refreshIamToken().thenApply(result -> {
            ResponseOuterClass.Response.Builder responseBuilder = ResponseOuterClass.Response.newBuilder();
            if ("OK".equals(result)) {
                responseBuilder.setConstantResponse(ResponseOuterClass.ConstantResponse.OK);
            }
            return responseHandler.apply(responseBuilder.build());
        });
    }

    protected <T> CompletableFuture<T> submitCommandToJni(CommandRequestOuterClass.CommandRequest.Builder command, GlideExceptionCheckedFunction<ResponseOuterClass.Response, T> responseHandler, boolean binaryMode) {
        return this.submitCommandToJni(command, responseHandler, binaryMode, !binaryMode);
    }

    protected <T> CompletableFuture<T> submitCommandToJni(CommandRequestOuterClass.CommandRequest.Builder command, GlideExceptionCheckedFunction<ResponseOuterClass.Response, T> responseHandler, boolean binaryMode, boolean expectUtf8Response) {
        if (!this.coreClient.isConnected()) {
            CompletableFuture errorFuture = new CompletableFuture();
            errorFuture.completeExceptionally(new ClosingException("Client closed: Unable to submit command."));
            return errorFuture;
        }
        try {
            byte[] requestBytes = command.build().toByteArray();
            CompletableFuture<Object> jniFuture = expectUtf8Response ? this.coreClient.executeCommandAsync(requestBytes) : this.coreClient.executeBinaryCommandAsync(requestBytes);
            return ((CompletableFuture)jniFuture.thenApply(result -> {
                ResponseOuterClass.Response.Builder builder = ResponseOuterClass.Response.newBuilder();
                Object toStore = result;
                if (result == null) {
                    builder.setRespPointer(0L);
                } else if ("OK".equals(result)) {
                    builder.setConstantResponse(ResponseOuterClass.ConstantResponse.OK);
                } else {
                    if (result instanceof ByteBuffer) {
                        toStore = this.normalizeDirectBuffer((ByteBuffer)result, expectUtf8Response);
                    }
                    long objectId = JniResponseRegistry.storeObject(toStore);
                    builder.setRespPointer(objectId);
                }
                return responseHandler.apply(builder.build());
            })).exceptionally(this::exceptionHandler);
        }
        catch (Exception e) {
            CompletableFuture errorFuture = new CompletableFuture();
            errorFuture.completeExceptionally(e);
            return errorFuture;
        }
    }

    private Object normalizeDirectBuffer(ByteBuffer buffer, boolean expectUtf8Response) {
        ByteBuffer dup = buffer.duplicate();
        dup.rewind();
        if (dup.remaining() == 0) {
            return expectUtf8Response ? "" : GlideString.gs(new byte[0]);
        }
        byte marker = dup.get();
        dup.rewind();
        if (marker == 42) {
            return this.deserializeByteBufferArray(dup, expectUtf8Response);
        }
        if (marker == 37) {
            return this.deserializeByteBufferMap(dup, expectUtf8Response);
        }
        if (expectUtf8Response) {
            return BufferUtils.decodeUtf8(dup);
        }
        byte[] bytes = new byte[dup.remaining()];
        dup.get(bytes);
        return GlideString.gs(bytes);
    }

    private LinkedHashMap<Object, Object> deserializeByteBufferMap(ByteBuffer buffer, boolean expectUtf8) {
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.rewind();
        byte marker = buffer.get();
        if (marker != 37) {
            throw new IllegalArgumentException("Expected map marker '%', got: " + (char)marker);
        }
        int count = buffer.getInt();
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(Math.max(16, count));
        for (int i = 0; i < count; ++i) {
            Object val;
            Object key;
            int klen = buffer.getInt();
            if (expectUtf8) {
                key = BufferUtils.decodeUtf8(buffer, klen);
            } else {
                byte[] kbytes = new byte[klen];
                buffer.get(kbytes);
                key = GlideString.gs(kbytes);
            }
            int vlen = buffer.getInt();
            if (expectUtf8) {
                val = BufferUtils.decodeUtf8(buffer, vlen);
            } else {
                byte[] vbytes = new byte[vlen];
                buffer.get(vbytes);
                val = GlideString.gs(vbytes);
            }
            map.put(key, val);
        }
        return map;
    }

    protected <T> CompletableFuture<T> submitBatchToJni(CommandRequestOuterClass.CommandRequest.Builder command, GlideExceptionCheckedFunction<ResponseOuterClass.Response, T> responseHandler, boolean expectUtf8Response) {
        if (!this.coreClient.isConnected()) {
            CompletableFuture errorFuture = new CompletableFuture();
            errorFuture.completeExceptionally(new ClosingException("Client closed: Unable to submit batch."));
            return errorFuture;
        }
        try {
            byte[] requestBytes = command.build().toByteArray();
            return ((CompletableFuture)((CompletableFuture)this.coreClient.executeBatchAsync(requestBytes, expectUtf8Response).thenApply(result -> this.convertJniToProtobufResponse(result, expectUtf8Response))).thenApply(responseHandler::apply)).exceptionally(this::exceptionHandler);
        }
        catch (Exception e) {
            CompletableFuture errorFuture = new CompletableFuture();
            errorFuture.completeExceptionally(e);
            return errorFuture;
        }
    }

    private String getCursorId(ClusterScanCursor cursor) {
        if (cursor instanceof ClusterScanCursorDetail) {
            return ((ClusterScanCursorDetail)cursor).getCursorId();
        }
        if (!cursor.isFinished()) {
            return null;
        }
        return null;
    }

    private ResponseOuterClass.Response convertJniToProtobufResponse(Object jniResult, boolean expectUtf8Response) {
        ResponseOuterClass.Response.Builder builder = ResponseOuterClass.Response.newBuilder();
        if (jniResult == null) {
            builder.setRespPointer(0L);
        } else if ("OK".equals(jniResult)) {
            builder.setConstantResponse(ResponseOuterClass.ConstantResponse.OK);
        } else if (jniResult instanceof ByteBuffer) {
            Object toStore;
            ByteBuffer buffer = (ByteBuffer)jniResult;
            ByteBuffer dup = buffer.duplicate();
            dup.rewind();
            if (dup.remaining() > 0) {
                byte marker = dup.get();
                if (marker == 42) {
                    dup.rewind();
                    toStore = this.deserializeByteBufferArray(dup, expectUtf8Response);
                } else if (marker == 37) {
                    dup.rewind();
                    toStore = this.deserializeByteBufferMap(dup, expectUtf8Response);
                } else {
                    dup.rewind();
                    if (expectUtf8Response) {
                        toStore = BufferUtils.decodeUtf8(dup);
                    } else {
                        byte[] bytes = new byte[dup.remaining()];
                        dup.get(bytes);
                        toStore = GlideString.gs(bytes);
                    }
                }
            } else {
                toStore = expectUtf8Response ? "" : GlideString.gs(new byte[0]);
            }
            long objectId = JniResponseRegistry.storeObject(toStore);
            builder.setRespPointer(objectId);
        } else {
            long objectId = JniResponseRegistry.storeObject(jniResult);
            builder.setRespPointer(objectId);
        }
        return builder.build();
    }

    private ResponseOuterClass.Response createDirectResponse(Object jniResult, boolean expectUtf8Response) {
        ResponseOuterClass.Response.Builder builder = ResponseOuterClass.Response.newBuilder();
        if (jniResult == null) {
            builder.setRespPointer(0L);
        } else if ("OK".equals(jniResult)) {
            builder.setConstantResponse(ResponseOuterClass.ConstantResponse.OK);
        } else if (jniResult instanceof ByteBuffer) {
            Object toStore;
            ByteBuffer buffer = (ByteBuffer)jniResult;
            ByteBuffer dup = buffer.duplicate();
            dup.rewind();
            if (dup.remaining() > 0) {
                byte marker = dup.get();
                if (marker == 42) {
                    dup.rewind();
                    toStore = this.deserializeByteBufferArray(dup, expectUtf8Response);
                } else if (marker == 37) {
                    dup.rewind();
                    toStore = this.deserializeByteBufferMap(dup, expectUtf8Response);
                } else {
                    dup.rewind();
                    if (expectUtf8Response) {
                        toStore = BufferUtils.decodeUtf8(dup);
                    } else {
                        byte[] bytes = new byte[dup.remaining()];
                        dup.get(bytes);
                        toStore = GlideString.gs(bytes);
                    }
                }
            } else {
                toStore = expectUtf8Response ? "" : GlideString.gs(new byte[0]);
            }
            long objectId = JniResponseRegistry.storeObject(toStore);
            builder.setRespPointer(objectId);
        } else {
            long objectId = JniResponseRegistry.storeObject(jniResult);
            builder.setRespPointer(objectId);
        }
        return builder.build();
    }

    private Object[] deserializeByteBufferArray(ByteBuffer buffer, boolean expectUtf8Response) {
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.rewind();
        byte marker = buffer.get();
        if (marker != 42) {
            throw new IllegalArgumentException("Expected array marker '*', got: " + (char)marker);
        }
        int count = buffer.getInt();
        Object[] result = new Object[count];
        block6: for (int i = 0; i < count; ++i) {
            byte typeMarker = buffer.get();
            switch (typeMarker) {
                case 36: {
                    int bulkLen = buffer.getInt();
                    if (bulkLen == -1) {
                        result[i] = null;
                        continue block6;
                    }
                    if (expectUtf8Response) {
                        result[i] = BufferUtils.decodeUtf8(buffer, bulkLen);
                        continue block6;
                    }
                    byte[] data = new byte[bulkLen];
                    buffer.get(data);
                    result[i] = GlideString.gs(data);
                    continue block6;
                }
                case 43: {
                    int simpleLen = buffer.getInt();
                    String simpleString = BufferUtils.decodeUtf8(buffer, simpleLen);
                    result[i] = simpleString.equalsIgnoreCase("ok") ? "OK" : simpleString;
                    continue block6;
                }
                case 58: {
                    long intValue = buffer.getLong();
                    result[i] = intValue;
                    continue block6;
                }
                case 35: {
                    int complexLen = buffer.getInt();
                    if (expectUtf8Response) {
                        result[i] = BufferUtils.decodeUtf8(buffer, complexLen);
                        continue block6;
                    }
                    byte[] complexData = new byte[complexLen];
                    buffer.get(complexData);
                    result[i] = GlideString.gs(complexData);
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type marker: " + (char)typeMarker);
                }
            }
        }
        return result;
    }

    private <T> T exceptionHandler(Throwable e) {
        if (e instanceof ClosingException) {
            this.coreClient.close();
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    protected CommandRequestOuterClass.CommandRequest.Builder prepareCommandRequest(CommandRequestOuterClass.RequestType requestType, String[] arguments, RequestRoutingConfiguration.Route route) {
        CommandRequestOuterClass.Command.Builder commandBuilder = CommandRequestOuterClass.Command.newBuilder();
        CommandManager.populateCommandWithArgs(arguments, commandBuilder);
        long spanPtr = 0L;
        if (OpenTelemetry.isInitialized() && OpenTelemetry.shouldSample()) {
            spanPtr = OpenTelemetryResolver.createLeakedOtelSpan(requestType.name());
        }
        CommandRequestOuterClass.CommandRequest.Builder builder = CommandRequestOuterClass.CommandRequest.newBuilder().setSingleCommand(commandBuilder.setRequestType(requestType).build());
        if (spanPtr != 0L) {
            builder.setRootSpanPtr(spanPtr);
        }
        return this.prepareCommandRequestRoute(builder, route);
    }

    protected CommandRequestOuterClass.CommandRequest.Builder prepareCommandRequest(CommandRequestOuterClass.RequestType requestType, GlideString[] arguments, RequestRoutingConfiguration.Route route) {
        CommandRequestOuterClass.Command.Builder commandBuilder = CommandRequestOuterClass.Command.newBuilder();
        CommandManager.populateCommandWithArgs(arguments, commandBuilder);
        long spanPtr = 0L;
        if (OpenTelemetry.isInitialized() && OpenTelemetry.shouldSample()) {
            spanPtr = OpenTelemetryResolver.createLeakedOtelSpan(requestType.name());
        }
        CommandRequestOuterClass.CommandRequest.Builder builder = CommandRequestOuterClass.CommandRequest.newBuilder().setSingleCommand(commandBuilder.setRequestType(requestType).build());
        if (spanPtr != 0L) {
            builder.setRootSpanPtr(spanPtr);
        }
        return this.prepareCommandRequestRoute(builder, route);
    }

    protected CommandRequestOuterClass.CommandRequest.Builder prepareCommandRequest(Batch batch, boolean raiseOnError, Optional<BatchOptions> options) {
        CommandRequestOuterClass.CommandRequest.Builder builder = CommandRequestOuterClass.CommandRequest.newBuilder();
        long spanPtr = 0L;
        if (OpenTelemetry.isInitialized() && OpenTelemetry.shouldSample()) {
            spanPtr = OpenTelemetryResolver.createLeakedOtelSpan("Batch");
        }
        if (spanPtr != 0L) {
            builder.setRootSpanPtr(spanPtr);
        }
        if (options.isPresent()) {
            BatchOptions opts = options.get();
            CommandRequestOuterClass.Batch.Builder batchBuilder = this.prepareCommandRequestBatchOptions(batch.getProtobufBatch(), opts);
            builder.setBatch(batchBuilder.setRaiseOnError(raiseOnError).build());
        } else {
            builder.setBatch(batch.getProtobufBatch().setRaiseOnError(raiseOnError).build());
        }
        return builder;
    }

    protected CommandRequestOuterClass.CommandRequest.Builder prepareCommandRequest(ClusterBatch batch, boolean raiseOnError, Optional<ClusterBatchOptions> options) {
        CommandRequestOuterClass.CommandRequest.Builder builder = CommandRequestOuterClass.CommandRequest.newBuilder();
        long spanPtr = 0L;
        if (OpenTelemetry.isInitialized() && OpenTelemetry.shouldSample()) {
            spanPtr = OpenTelemetryResolver.createLeakedOtelSpan("Batch");
        }
        if (spanPtr != 0L) {
            builder.setRootSpanPtr(spanPtr);
        }
        if (options.isPresent()) {
            ClusterBatchOptions opts = options.get();
            CommandRequestOuterClass.Batch.Builder batchBuilder = this.prepareCommandRequestBatchOptions(batch.getProtobufBatch(), opts);
            if (opts.getRetryStrategy() != null) {
                if (batchBuilder.getIsAtomic()) {
                    throw new RequestException("Retry strategy is not supported for atomic batches.");
                }
                batchBuilder.setRetryServerError(opts.getRetryStrategy().isRetryServerError());
                batchBuilder.setRetryConnectionError(opts.getRetryStrategy().isRetryConnectionError());
            }
            builder.setBatch(batchBuilder.setRaiseOnError(raiseOnError).build());
            if (opts.getRoute() != null) {
                return this.prepareCommandRequestRoute(builder, opts.getRoute());
            }
        } else {
            builder.setBatch(batch.getProtobufBatch().setRaiseOnError(raiseOnError).build());
        }
        return builder;
    }

    protected CommandRequestOuterClass.CommandRequest.Builder prepareCursorRequest(@NonNull ClusterScanCursor cursor, @NonNull ScanOptions options) {
        if (cursor == null) {
            throw new NullPointerException("cursor is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        long spanPtr = 0L;
        if (OpenTelemetry.isInitialized() && OpenTelemetry.shouldSample()) {
            spanPtr = OpenTelemetryResolver.createLeakedOtelSpan("ClusterScan");
        }
        CommandRequestOuterClass.ClusterScan.Builder clusterScanBuilder = CommandRequestOuterClass.ClusterScan.newBuilder();
        if (cursor != ClusterScanCursor.INITIAL_CURSOR_INSTANCE) {
            if (cursor instanceof ClusterScanCursorDetail) {
                clusterScanBuilder.setCursor(((ClusterScanCursorDetail)cursor).getCursorHandle());
            } else {
                throw new IllegalArgumentException("Illegal cursor submitted.");
            }
        }
        if (options.getMatchPattern() != null) {
            clusterScanBuilder.setMatchPattern(ByteString.copyFrom(options.getMatchPattern().getBytes()));
        }
        if (options.getCount() != null) {
            clusterScanBuilder.setCount(options.getCount());
        }
        if (options.getType() != null) {
            clusterScanBuilder.setObjectType(options.getType().getNativeName());
        }
        if (options.getAllowNonCoveredSlots() != null) {
            clusterScanBuilder.setAllowNonCoveredSlots(options.getAllowNonCoveredSlots());
        }
        CommandRequestOuterClass.CommandRequest.Builder builder = CommandRequestOuterClass.CommandRequest.newBuilder().setClusterScan(clusterScanBuilder.build());
        if (spanPtr != 0L) {
            builder.setRootSpanPtr(spanPtr);
        }
        return builder;
    }

    protected CommandRequestOuterClass.CommandRequest.Builder prepareCommandRequest(CommandRequestOuterClass.RequestType requestType, String[] arguments) {
        CommandRequestOuterClass.Command.Builder commandBuilder = CommandRequestOuterClass.Command.newBuilder();
        CommandManager.populateCommandWithArgs(arguments, commandBuilder);
        long spanPtr = 0L;
        if (OpenTelemetry.isInitialized() && OpenTelemetry.shouldSample()) {
            spanPtr = OpenTelemetryResolver.createLeakedOtelSpan(requestType.name());
        }
        CommandRequestOuterClass.CommandRequest.Builder builder = CommandRequestOuterClass.CommandRequest.newBuilder().setSingleCommand(commandBuilder.setRequestType(requestType).build());
        if (spanPtr != 0L) {
            builder.setRootSpanPtr(spanPtr);
        }
        return builder;
    }

    protected CommandRequestOuterClass.CommandRequest.Builder prepareCommandRequest(CommandRequestOuterClass.RequestType requestType, GlideString[] arguments) {
        CommandRequestOuterClass.Command.Builder commandBuilder = CommandRequestOuterClass.Command.newBuilder();
        CommandManager.populateCommandWithArgs(arguments, commandBuilder);
        long spanPtr = 0L;
        if (OpenTelemetry.isInitialized() && OpenTelemetry.shouldSample()) {
            spanPtr = OpenTelemetryResolver.createLeakedOtelSpan(requestType.name());
        }
        CommandRequestOuterClass.CommandRequest.Builder builder = CommandRequestOuterClass.CommandRequest.newBuilder().setSingleCommand(commandBuilder.setRequestType(requestType).build());
        if (spanPtr != 0L) {
            builder.setRootSpanPtr(spanPtr);
        }
        return builder;
    }

    private CommandRequestOuterClass.Batch.Builder prepareCommandRequestBatchOptions(CommandRequestOuterClass.Batch.Builder batchBuilder, BaseBatchOptions options) {
        if (options.getTimeout() != null) {
            batchBuilder.setTimeout(options.getTimeout());
        }
        return batchBuilder;
    }

    private CommandRequestOuterClass.CommandRequest.Builder prepareCommandRequestRoute(CommandRequestOuterClass.CommandRequest.Builder builder, RequestRoutingConfiguration.Route route) {
        if (route instanceof RequestRoutingConfiguration.SimpleMultiNodeRoute) {
            builder.setRoute(CommandRequestOuterClass.Routes.newBuilder().setSimpleRoutes(CommandRequestOuterClass.SimpleRoutes.forNumber(((RequestRoutingConfiguration.SimpleMultiNodeRoute)route).getOrdinal())).build());
        } else if (route instanceof RequestRoutingConfiguration.SimpleSingleNodeRoute) {
            builder.setRoute(CommandRequestOuterClass.Routes.newBuilder().setSimpleRoutes(CommandRequestOuterClass.SimpleRoutes.forNumber(((RequestRoutingConfiguration.SimpleSingleNodeRoute)route).getOrdinal())).build());
        } else if (route instanceof RequestRoutingConfiguration.SlotIdRoute) {
            builder.setRoute(CommandRequestOuterClass.Routes.newBuilder().setSlotIdRoute(CommandRequestOuterClass.SlotIdRoute.newBuilder().setSlotId(((RequestRoutingConfiguration.SlotIdRoute)route).getSlotId()).setSlotType(CommandRequestOuterClass.SlotTypes.forNumber(((RequestRoutingConfiguration.SlotIdRoute)route).getSlotType().ordinal()))));
        } else if (route instanceof RequestRoutingConfiguration.SlotKeyRoute) {
            builder.setRoute(CommandRequestOuterClass.Routes.newBuilder().setSlotKeyRoute(CommandRequestOuterClass.SlotKeyRoute.newBuilder().setSlotKey(((RequestRoutingConfiguration.SlotKeyRoute)route).getSlotKey()).setSlotType(CommandRequestOuterClass.SlotTypes.forNumber(((RequestRoutingConfiguration.SlotKeyRoute)route).getSlotType().ordinal()))));
        } else if (route instanceof RequestRoutingConfiguration.ByAddressRoute) {
            builder.setRoute(CommandRequestOuterClass.Routes.newBuilder().setByAddressRoute(CommandRequestOuterClass.ByAddressRoute.newBuilder().setHost(((RequestRoutingConfiguration.ByAddressRoute)route).getHost()).setPort(((RequestRoutingConfiguration.ByAddressRoute)route).getPort())));
        } else {
            throw new RequestException(String.format("Unknown type of route: %s", route.getClass().getSimpleName()));
        }
        return builder;
    }

    public static <ArgType> void populateCommandWithArgs(ArgType[] arguments, CommandRequestOuterClass.Command.Builder outputBuilder) {
        CommandRequestOuterClass.Command.ArgsArray.Builder commandArgs = CommandRequestOuterClass.Command.ArgsArray.newBuilder();
        for (ArgType value : arguments) {
            CommandManager.appendArgument(commandArgs, value);
        }
        outputBuilder.setArgsArray(commandArgs);
    }

    private static void populateCommandWithArgs(GlideString[] arguments, CommandRequestOuterClass.Command.Builder outputBuilder) {
        CommandRequestOuterClass.Command.ArgsArray.Builder commandArgs = CommandRequestOuterClass.Command.ArgsArray.newBuilder();
        for (GlideString argument : arguments) {
            if (argument == null) {
                throw new NullPointerException("Argument cannot be null");
            }
            commandArgs.addArgs(UnsafeByteOperations.unsafeWrap(argument.getBytes()));
        }
        outputBuilder.setArgsArray(commandArgs);
    }

    private static void appendArgument(CommandRequestOuterClass.Command.ArgsArray.Builder commandArgs, Object value) {
        if (value instanceof GlideString) {
            commandArgs.addArgs(UnsafeByteOperations.unsafeWrap(((GlideString)value).getBytes()));
        } else if (value instanceof byte[]) {
            commandArgs.addArgs(UnsafeByteOperations.unsafeWrap((byte[])value));
        } else if (value instanceof String) {
            commandArgs.addArgs(ByteString.copyFromUtf8((String)value));
        } else {
            if (value == null) {
                throw new NullPointerException("Argument cannot be null");
            }
            commandArgs.addArgs(ByteString.copyFromUtf8(value.toString()));
        }
    }

    @Generated
    public CommandManager(GlideCoreClient coreClient) {
        this.coreClient = coreClient;
    }

    private static final class ScriptRouteArgs {
        final boolean hasRoute;
        final int routeType;
        final String routeParam;

        ScriptRouteArgs(boolean hasRoute, int routeType, String routeParam) {
            this.hasRoute = hasRoute;
            this.routeType = routeType;
            this.routeParam = routeParam;
        }
    }

    public static interface ClusterScanCursorDetail
    extends ClusterScanCursor {
        public String getCursorHandle();

        public String getCursorId();
    }
}

