/*
 * Decompiled with CFR 0.152.
 */
package glide.managers;

import connection_request.ConnectionRequestOuterClass;
import glide.api.models.GlideString;
import glide.api.models.configuration.AdvancedBaseClientConfiguration;
import glide.api.models.configuration.BackoffStrategy;
import glide.api.models.configuration.BaseClientConfiguration;
import glide.api.models.configuration.BaseSubscriptionConfiguration;
import glide.api.models.configuration.ClusterSubscriptionConfiguration;
import glide.api.models.configuration.GlideClientConfiguration;
import glide.api.models.configuration.GlideClusterClientConfiguration;
import glide.api.models.configuration.IamAuthConfig;
import glide.api.models.configuration.ServerCredentials;
import glide.api.models.configuration.ServiceType;
import glide.api.models.configuration.StandaloneSubscriptionConfiguration;
import glide.api.models.configuration.TlsAdvancedConfiguration;
import glide.api.models.exceptions.ClosingException;
import glide.api.models.exceptions.ConfigurationError;
import glide.com.google.protobuf.ByteString;
import glide.internal.AsyncRegistry;
import glide.internal.GlideCoreClient;
import glide.internal.GlideNativeBridge;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import lombok.Generated;

public class ConnectionManager {
    private static final String DEFAULT_LIB_NAME = "GlideJava";
    private long nativeClientHandle = 0L;
    private int maxInflightRequests = 0;
    private int requestTimeoutMs = 5000;
    private ServerCredentials credentials;
    private volatile boolean isClosed = false;

    public CompletableFuture<Void> connectToValkey(BaseClientConfiguration configuration) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                byte[] rootCerts;
                GlideClusterClientConfiguration clusterConfig;
                String[] addresses = (String[])configuration.getAddresses().stream().map(addr -> addr.getHost() + ":" + addr.getPort()).toArray(String[]::new);
                this.credentials = configuration.getCredentials() != null ? configuration.getCredentials() : null;
                boolean isCluster = configuration instanceof GlideClusterClientConfiguration;
                this.maxInflightRequests = configuration.getInflightRequestsLimit() != null ? configuration.getInflightRequestsLimit() : GlideNativeBridge.getGlideCoreDefaultMaxInflightRequests();
                this.requestTimeoutMs = configuration.getRequestTimeout() != null ? configuration.getRequestTimeout() : (int)GlideNativeBridge.getGlideCoreDefaultRequestTimeoutMs();
                boolean insecureTls = ConnectionManager.resolveInsecureTls(configuration);
                int connectionTimeoutMs = ConnectionManager.resolveConnectionTimeout(configuration);
                String protocolName = configuration.getProtocol() != null ? configuration.getProtocol().name() : null;
                BackoffStrategy reconnectStrategy = configuration.getReconnectStrategy();
                int reconnectNumRetries = reconnectStrategy != null && reconnectStrategy.getNumOfRetries() != null ? reconnectStrategy.getNumOfRetries() : 0;
                int reconnectFactor = reconnectStrategy != null && reconnectStrategy.getFactor() != null ? reconnectStrategy.getFactor() : 0;
                int reconnectExponentBase = reconnectStrategy != null && reconnectStrategy.getExponentBase() != null ? reconnectStrategy.getExponentBase() : 0;
                int reconnectJitterPercent = reconnectStrategy != null && reconnectStrategy.getJitterPercent() != null ? reconnectStrategy.getJitterPercent() : -1;
                byte[][] subExact = GlideCoreClient.EMPTY_2D_BYTE_ARRAY;
                byte[][] subPattern = GlideCoreClient.EMPTY_2D_BYTE_ARRAY;
                byte[][] subSharded = GlideCoreClient.EMPTY_2D_BYTE_ARRAY;
                if (configuration.getSubscriptionConfiguration() != null) {
                    BaseSubscriptionConfiguration sc = configuration.getSubscriptionConfiguration();
                    try {
                        Set pattern;
                        Set exact;
                        Object subs;
                        if (sc instanceof StandaloneSubscriptionConfiguration) {
                            subs = ((StandaloneSubscriptionConfiguration)sc).getSubscriptions();
                            exact = (Set)subs.get(StandaloneSubscriptionConfiguration.PubSubChannelMode.EXACT);
                            pattern = (Set)subs.get(StandaloneSubscriptionConfiguration.PubSubChannelMode.PATTERN);
                            if (exact != null) {
                                subExact = (byte[][])exact.stream().map(GlideString::getBytes).toArray(x$0 -> new byte[x$0][]);
                            }
                            if (pattern != null) {
                                subPattern = (byte[][])pattern.stream().map(GlideString::getBytes).toArray(x$0 -> new byte[x$0][]);
                            }
                        } else if (sc instanceof ClusterSubscriptionConfiguration) {
                            subs = ((ClusterSubscriptionConfiguration)sc).getSubscriptions();
                            exact = (Set)subs.get(ClusterSubscriptionConfiguration.PubSubClusterChannelMode.EXACT);
                            pattern = (Set)subs.get(ClusterSubscriptionConfiguration.PubSubClusterChannelMode.PATTERN);
                            Set sharded = (Set)subs.get(ClusterSubscriptionConfiguration.PubSubClusterChannelMode.SHARDED);
                            if (exact != null) {
                                subExact = (byte[][])exact.stream().map(GlideString::getBytes).toArray(x$0 -> new byte[x$0][]);
                            }
                            if (pattern != null) {
                                subPattern = (byte[][])pattern.stream().map(GlideString::getBytes).toArray(x$0 -> new byte[x$0][]);
                            }
                            if (sharded != null) {
                                subSharded = (byte[][])sharded.stream().map(GlideString::getBytes).toArray(x$0 -> new byte[x$0][]);
                            }
                        }
                    }
                    catch (Throwable subs) {
                        // empty catch block
                    }
                }
                ConnectionRequestOuterClass.ConnectionRequest.Builder requestBuilder = ConnectionRequestOuterClass.ConnectionRequest.newBuilder();
                for (String addr2 : addresses) {
                    String[] parts = addr2.split(":");
                    if (parts.length != 2) continue;
                    requestBuilder.addAddresses(ConnectionRequestOuterClass.NodeAddress.newBuilder().setHost(parts[0]).setPort(Integer.parseInt(parts[1])).build());
                }
                if (configuration.isUseTLS()) {
                    if (insecureTls) {
                        requestBuilder.setTlsMode(ConnectionRequestOuterClass.TlsMode.InsecureTls);
                    } else {
                        requestBuilder.setTlsMode(ConnectionRequestOuterClass.TlsMode.SecureTls);
                    }
                } else {
                    requestBuilder.setTlsMode(ConnectionRequestOuterClass.TlsMode.NoTls);
                }
                if (this.credentials != null) {
                    ConnectionRequestOuterClass.AuthenticationInfo.Builder authBuilder = ConnectionRequestOuterClass.AuthenticationInfo.newBuilder();
                    if (this.credentials.getUsername() != null) {
                        authBuilder.setUsername(this.credentials.getUsername());
                    }
                    if (this.credentials.getPassword() != null) {
                        authBuilder.setPassword(this.credentials.getPassword());
                    }
                    if (this.credentials.getIamConfig() != null) {
                        IamAuthConfig iamConfig = this.credentials.getIamConfig();
                        ConnectionRequestOuterClass.IamCredentials.Builder iamBuilder = ConnectionRequestOuterClass.IamCredentials.newBuilder();
                        iamBuilder.setClusterName(iamConfig.getClusterName());
                        iamBuilder.setRegion(iamConfig.getRegion());
                        if (iamConfig.getService() == ServiceType.ELASTICACHE) {
                            iamBuilder.setServiceType(ConnectionRequestOuterClass.ServiceType.ELASTICACHE);
                        } else if (iamConfig.getService() == ServiceType.MEMORYDB) {
                            iamBuilder.setServiceType(ConnectionRequestOuterClass.ServiceType.MEMORYDB);
                        }
                        if (iamConfig.getRefreshIntervalSeconds() != null) {
                            iamBuilder.setRefreshIntervalSeconds(iamConfig.getRefreshIntervalSeconds());
                        }
                        authBuilder.setIamCredentials(iamBuilder.build());
                    }
                    requestBuilder.setAuthenticationInfo(authBuilder.build());
                }
                requestBuilder.setClusterModeEnabled(isCluster);
                if (isCluster && (clusterConfig = (GlideClusterClientConfiguration)configuration).getAdvancedConfiguration() != null) {
                    requestBuilder.setRefreshTopologyFromInitialNodes(clusterConfig.getAdvancedConfiguration().isRefreshTopologyFromInitialNodes());
                }
                requestBuilder.setRequestTimeout(this.requestTimeoutMs);
                requestBuilder.setConnectionTimeout(connectionTimeoutMs);
                requestBuilder.setInflightRequestsLimit(this.maxInflightRequests);
                String readFromName = configuration.getReadFrom().name();
                if ("PRIMARY".equals(readFromName)) {
                    requestBuilder.setReadFrom(ConnectionRequestOuterClass.ReadFrom.Primary);
                } else if ("PREFER_REPLICA".equals(readFromName)) {
                    requestBuilder.setReadFrom(ConnectionRequestOuterClass.ReadFrom.PreferReplica);
                } else if ("AZ_AFFINITY".equals(readFromName)) {
                    requestBuilder.setReadFrom(ConnectionRequestOuterClass.ReadFrom.AZAffinity);
                } else if ("AZ_AFFINITY_PREFER_PRIMARY".equals(readFromName)) {
                    requestBuilder.setReadFrom(ConnectionRequestOuterClass.ReadFrom.AZAffinityReplicasAndPrimary);
                }
                if (configuration.getClientAZ() != null) {
                    requestBuilder.setClientAz(configuration.getClientAZ());
                }
                if (configuration.getClientName() != null) {
                    requestBuilder.setClientName(configuration.getClientName());
                }
                if (configuration.getLibName() != null) {
                    requestBuilder.setLibName(configuration.getLibName());
                } else {
                    requestBuilder.setLibName(DEFAULT_LIB_NAME);
                }
                requestBuilder.setLazyConnect(configuration.isLazyConnect());
                if (configuration.getDatabaseId() != null) {
                    requestBuilder.setDatabaseId(configuration.getDatabaseId());
                }
                if (protocolName != null) {
                    if ("RESP2".equals(protocolName)) {
                        requestBuilder.setProtocol(ConnectionRequestOuterClass.ProtocolVersion.RESP2);
                    } else if ("RESP3".equals(protocolName)) {
                        requestBuilder.setProtocol(ConnectionRequestOuterClass.ProtocolVersion.RESP3);
                    }
                }
                if (reconnectNumRetries > 0 || reconnectFactor > 0 || reconnectExponentBase > 0) {
                    ConnectionRequestOuterClass.ConnectionRetryStrategy.Builder retryBuilder = ConnectionRequestOuterClass.ConnectionRetryStrategy.newBuilder();
                    retryBuilder.setNumberOfRetries(reconnectNumRetries);
                    retryBuilder.setFactor(reconnectFactor);
                    retryBuilder.setExponentBase(reconnectExponentBase);
                    if (reconnectJitterPercent >= 0) {
                        retryBuilder.setJitterPercent(reconnectJitterPercent);
                    }
                    requestBuilder.setConnectionRetryStrategy(retryBuilder.build());
                }
                if ((rootCerts = ConnectionManager.extractRootCertificates(configuration)) != null) {
                    requestBuilder.addRootCerts(ByteString.copyFrom(rootCerts));
                }
                if (subExact.length > 0 || subPattern.length > 0 || subSharded.length > 0) {
                    ConnectionRequestOuterClass.PubSubSubscriptions.Builder subBuilder = ConnectionRequestOuterClass.PubSubSubscriptions.newBuilder();
                    if (subExact.length > 0) {
                        ConnectionRequestOuterClass.PubSubChannelsOrPatterns.Builder exactBuilder = ConnectionRequestOuterClass.PubSubChannelsOrPatterns.newBuilder();
                        for (byte[] channel : subExact) {
                            exactBuilder.addChannelsOrPatterns(ByteString.copyFrom(channel));
                        }
                        subBuilder.putChannelsOrPatternsByType(ConnectionRequestOuterClass.PubSubChannelType.Exact.getNumber(), exactBuilder.build());
                    }
                    if (subPattern.length > 0) {
                        ConnectionRequestOuterClass.PubSubChannelsOrPatterns.Builder patternBuilder = ConnectionRequestOuterClass.PubSubChannelsOrPatterns.newBuilder();
                        for (byte[] pattern : subPattern) {
                            patternBuilder.addChannelsOrPatterns(ByteString.copyFrom(pattern));
                        }
                        subBuilder.putChannelsOrPatternsByType(ConnectionRequestOuterClass.PubSubChannelType.Pattern.getNumber(), patternBuilder.build());
                    }
                    if (isCluster && subSharded.length > 0) {
                        ConnectionRequestOuterClass.PubSubChannelsOrPatterns.Builder shardedBuilder = ConnectionRequestOuterClass.PubSubChannelsOrPatterns.newBuilder();
                        for (byte[] sharded : subSharded) {
                            shardedBuilder.addChannelsOrPatterns(ByteString.copyFrom(sharded));
                        }
                        subBuilder.putChannelsOrPatternsByType(ConnectionRequestOuterClass.PubSubChannelType.Sharded.getNumber(), shardedBuilder.build());
                    }
                    requestBuilder.setPubsubSubscriptions(subBuilder.build());
                }
                ConnectionRequestOuterClass.ConnectionRequest request = requestBuilder.build();
                byte[] requestBytes = request.toByteArray();
                this.nativeClientHandle = GlideNativeBridge.createClient(requestBytes);
                if (this.nativeClientHandle == 0L) {
                    throw new ClosingException("Failed to create client - Connection refused");
                }
                return null;
            }
            catch (Exception e) {
                if (e instanceof ClosingException) {
                    throw e;
                }
                throw new RuntimeException("Failed to create client", e);
            }
        });
    }

    public Future<Void> closeConnection() {
        return CompletableFuture.supplyAsync(() -> {
            if (!this.isClosed && this.nativeClientHandle != 0L) {
                try {
                    AsyncRegistry.cleanupClient(this.nativeClientHandle);
                    GlideNativeBridge.closeClient(this.nativeClientHandle);
                }
                finally {
                    this.isClosed = true;
                    this.nativeClientHandle = 0L;
                }
            }
            return null;
        });
    }

    public void closeConnectionSync() {
        if (this.isClosed) {
            return;
        }
        try {
            this.isClosed = true;
            AsyncRegistry.cleanupClient(this.nativeClientHandle);
            if (this.nativeClientHandle != 0L) {
                GlideNativeBridge.closeClient(this.nativeClientHandle);
                this.nativeClientHandle = 0L;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to close client", e);
        }
    }

    public long getNativeClientHandle() {
        return this.nativeClientHandle;
    }

    public int getMaxInflightRequests() {
        return this.maxInflightRequests;
    }

    public int getRequestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean isConnected() {
        if (this.isClosed || this.nativeClientHandle == 0L) {
            return false;
        }
        try {
            return GlideNativeBridge.isConnected(this.nativeClientHandle);
        }
        catch (Exception e) {
            return false;
        }
    }

    public ServerCredentials getCredentials() {
        return this.credentials;
    }

    public void updateStoredPassword(String password) {
        if (this.credentials == null) {
            return;
        }
        this.credentials = ServerCredentials.builder().username(this.credentials.getUsername()).password(password != null ? password : "").build();
    }

    public String getClientInfo() {
        if (this.isClosed || this.nativeClientHandle == 0L) {
            throw new IllegalStateException("Client is closed");
        }
        return GlideNativeBridge.getClientInfo(this.nativeClientHandle);
    }

    private static int resolveConnectionTimeout(BaseClientConfiguration configuration) {
        AdvancedBaseClientConfiguration advanced = ConnectionManager.extractAdvancedConfiguration(configuration);
        if (advanced != null && advanced.getConnectionTimeout() != null) {
            return advanced.getConnectionTimeout();
        }
        return (int)GlideNativeBridge.getGlideCoreDefaultConnectionTimeoutMs();
    }

    private static boolean resolveInsecureTls(BaseClientConfiguration configuration) {
        AdvancedBaseClientConfiguration advanced = ConnectionManager.extractAdvancedConfiguration(configuration);
        if (advanced == null) {
            return false;
        }
        TlsAdvancedConfiguration tlsConfig = advanced.getTlsAdvancedConfiguration();
        if (tlsConfig != null && tlsConfig.isUseInsecureTLS()) {
            if (!configuration.isUseTLS()) {
                throw new ConfigurationError("`useInsecureTLS` cannot be enabled when `useTLS` is disabled.");
            }
            return true;
        }
        return false;
    }

    private static byte[] extractRootCertificates(BaseClientConfiguration configuration) {
        AdvancedBaseClientConfiguration advanced = ConnectionManager.extractAdvancedConfiguration(configuration);
        if (advanced == null) {
            return null;
        }
        TlsAdvancedConfiguration tlsConfig = advanced.getTlsAdvancedConfiguration();
        if (tlsConfig == null) {
            return null;
        }
        return tlsConfig.getRootCertificates();
    }

    private static AdvancedBaseClientConfiguration extractAdvancedConfiguration(BaseClientConfiguration configuration) {
        if (configuration instanceof GlideClientConfiguration) {
            return ((GlideClientConfiguration)configuration).getAdvancedConfiguration();
        }
        if (configuration instanceof GlideClusterClientConfiguration) {
            return ((GlideClusterClientConfiguration)configuration).getAdvancedConfiguration();
        }
        return null;
    }

    @Generated
    public ConnectionManager() {
    }
}

