/*
 * Decompiled with CFR 0.152.
 */
package glide.managers;

import glide.api.BaseClient;
import glide.api.models.exceptions.GlideException;
import glide.ffi.resolvers.OpenTelemetryResolver;
import glide.managers.GlideExceptionCheckedFunction;
import lombok.Generated;
import response.ResponseOuterClass;

public class BaseResponseResolver
implements GlideExceptionCheckedFunction<ResponseOuterClass.Response, Object> {
    private GlideExceptionCheckedFunction<Long, Object> respPointerResolver;

    @Override
    public Object apply(ResponseOuterClass.Response response) throws GlideException {
        assert (!response.hasClosingError()) : "Unhandled response closing error";
        assert (!response.hasRequestError()) : "Unhandled response request error";
        if (response.hasRootSpanPtr() && response.getRootSpanPtr() != 0L) {
            OpenTelemetryResolver.dropOtelSpan(response.getRootSpanPtr());
        }
        if (response.hasConstantResponse()) {
            return BaseClient.OK;
        }
        if (response.hasRespPointer()) {
            return this.respPointerResolver.apply(response.getRespPointer());
        }
        return null;
    }

    @Generated
    public BaseResponseResolver(GlideExceptionCheckedFunction<Long, Object> respPointerResolver) {
        this.respPointerResolver = respPointerResolver;
    }
}

