/*
 * Decompiled with CFR 0.152.
 */
package glide.internal;

import glide.api.models.exceptions.ClosingException;
import glide.api.models.exceptions.ExecAbortException;
import glide.api.models.exceptions.GlideException;
import glide.api.models.exceptions.RequestException;
import glide.api.models.exceptions.TimeoutException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class AsyncRegistry {
    private static final ConcurrentHashMap<Long, CompletableFuture<Object>> activeFutures = new ConcurrentHashMap(AsyncRegistry.estimateInitialCapacity());
    private static final ConcurrentHashMap<Long, AtomicInteger> clientInflightCounts = new ConcurrentHashMap();
    private static final AtomicLong nextId = new AtomicLong(1L);
    private static final Thread shutdownHook = new Thread(AsyncRegistry::shutdown, "AsyncRegistry-Shutdown");

    private static int estimateInitialCapacity() {
        String prop;
        String env = System.getenv("GLIDE_MAX_INFLIGHT_REQUESTS");
        if (env != null) {
            try {
                int v = Integer.parseInt(env.trim());
                if (v > 0) {
                    return Math.max(16, v * 2);
                }
            }
            catch (NumberFormatException v) {
                // empty catch block
            }
        }
        if ((prop = System.getProperty("glide.maxInflightRequests")) != null) {
            try {
                int v = Integer.parseInt(prop.trim());
                if (v > 0) {
                    return Math.max(16, v * 2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 2000;
    }

    public static <T> long register(CompletableFuture<T> future, int maxInflightRequests, long clientHandle) {
        if (future == null) {
            throw new IllegalArgumentException("Future cannot be null");
        }
        if (maxInflightRequests > 0) {
            clientInflightCounts.compute(clientHandle, (key, counter) -> {
                AtomicInteger value = counter != null ? counter : new AtomicInteger(0);
                int updated = value.incrementAndGet();
                if (updated > maxInflightRequests) {
                    value.decrementAndGet();
                    throw new RequestException("Client reached maximum inflight requests");
                }
                return value;
            });
        }
        long correlationId = nextId.getAndIncrement();
        CompletableFuture<T> originalFuture = future;
        activeFutures.put(correlationId, originalFuture);
        originalFuture.whenComplete((result, throwable) -> {
            activeFutures.remove(correlationId);
            if (maxInflightRequests > 0) {
                clientInflightCounts.compute(clientHandle, (key, counter) -> {
                    if (counter == null) {
                        return null;
                    }
                    int remaining = counter.decrementAndGet();
                    return remaining <= 0 ? null : counter;
                });
            }
        });
        return correlationId;
    }

    public static boolean completeCallback(long correlationId, Object result) {
        CompletableFuture<Object> future = activeFutures.get(correlationId);
        if (future == null) {
            return false;
        }
        boolean completed = future.complete(result);
        return completed;
    }

    public static boolean completeCallbackWithErrorCode(long correlationId, int errorTypeCode, String errorMessage) {
        GlideException ex;
        CompletableFuture<Object> future = activeFutures.get(correlationId);
        if (future == null) {
            return false;
        }
        String msg = errorMessage == null || errorMessage.isBlank() ? "Unknown error from native code" : errorMessage;
        switch (errorTypeCode) {
            case 2: {
                ex = new TimeoutException(msg);
                break;
            }
            case 3: {
                ex = new ClosingException(msg);
                break;
            }
            case 1: {
                ex = new ExecAbortException(msg);
                break;
            }
            default: {
                ex = new RequestException(msg);
            }
        }
        return future.completeExceptionally(ex);
    }

    public static int getPendingCount() {
        return activeFutures.size();
    }

    public static void shutdown() {
        activeFutures.values().forEach(future -> {
            if (!future.isDone()) {
                future.cancel(true);
            }
        });
        activeFutures.clear();
        clientInflightCounts.clear();
    }

    public static void cleanupClient(long clientHandle) {
        clientInflightCounts.remove(clientHandle);
    }

    public static void reset() {
        activeFutures.clear();
        clientInflightCounts.clear();
        nextId.set(1L);
    }

    public static void removeShutdownHook() {
        try {
            Runtime.getRuntime().removeShutdownHook(shutdownHook);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    static {
        if (!"false".equalsIgnoreCase(System.getProperty("glide.autoShutdownHook", "true"))) {
            Runtime.getRuntime().addShutdownHook(shutdownHook);
        }
    }
}

