/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.configuration;

import glide.api.models.configuration.IamAuthConfig;
import lombok.Generated;

public class ServerCredentials {
    private final String password;
    private final String username;
    private final IamAuthConfig iamConfig;

    private ServerCredentials(String password, String username, IamAuthConfig iamConfig) {
        if (password != null && iamConfig != null) {
            throw new IllegalArgumentException("password and iamConfig are mutually exclusive. Use either password-based or IAM authentication, not both.");
        }
        if (iamConfig != null && username == null) {
            throw new IllegalArgumentException("username is required for IAM authentication.");
        }
        this.password = password;
        this.username = username;
        this.iamConfig = iamConfig;
    }

    @Generated
    public static ServerCredentialsBuilder builder() {
        return new ServerCredentialsBuilder();
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public IamAuthConfig getIamConfig() {
        return this.iamConfig;
    }

    @Generated
    public static class ServerCredentialsBuilder {
        @Generated
        private String password;
        @Generated
        private String username;
        @Generated
        private IamAuthConfig iamConfig;

        @Generated
        ServerCredentialsBuilder() {
        }

        @Generated
        public ServerCredentialsBuilder password(String password) {
            this.password = password;
            return this;
        }

        @Generated
        public ServerCredentialsBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public ServerCredentialsBuilder iamConfig(IamAuthConfig iamConfig) {
            this.iamConfig = iamConfig;
            return this;
        }

        @Generated
        public ServerCredentials build() {
            return new ServerCredentials(this.password, this.username, this.iamConfig);
        }

        @Generated
        public String toString() {
            return "ServerCredentials.ServerCredentialsBuilder(password=" + this.password + ", username=" + this.username + ", iamConfig=" + String.valueOf(this.iamConfig) + ")";
        }
    }
}

