/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.configuration;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import glide.api.models.configuration.BackoffStrategy;
import glide.api.models.configuration.BaseSubscriptionConfiguration;
import glide.api.models.configuration.NodeAddress;
import glide.api.models.configuration.ProtocolVersion;
import glide.api.models.configuration.ReadFrom;
import glide.api.models.configuration.ServerCredentials;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;

@SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Lombok-generated builder validates inputs and throws before object escapes")
public abstract class BaseClientConfiguration {
    private final List<NodeAddress> addresses;
    private final boolean useTLS;
    @NonNull
    private final ReadFrom readFrom;
    private final ServerCredentials credentials;
    private final Integer requestTimeout;
    private final String clientName;
    private final String libName;
    private final ProtocolVersion protocol;
    private final Integer inflightRequestsLimit;
    private final String clientAZ;
    private final BackoffStrategy reconnectStrategy;
    private final Integer databaseId;
    private final boolean lazyConnect;

    public abstract BaseSubscriptionConfiguration getSubscriptionConfiguration();

    public List<NodeAddress> getAddresses() {
        return List.copyOf(this.addresses);
    }

    @Generated
    private static boolean $default$useTLS() {
        return false;
    }

    @Generated
    private static ReadFrom $default$readFrom() {
        return ReadFrom.PRIMARY;
    }

    @Generated
    private static boolean $default$lazyConnect() {
        return false;
    }

    @Generated
    protected BaseClientConfiguration(BaseClientConfigurationBuilder<?, ?> b) {
        List<Object> addresses;
        switch (b.addresses == null ? 0 : b.addresses.size()) {
            case 0: {
                addresses = Collections.emptyList();
                break;
            }
            case 1: {
                addresses = Collections.singletonList(b.addresses.get(0));
                break;
            }
            default: {
                addresses = Collections.unmodifiableList(new ArrayList<NodeAddress>(b.addresses));
            }
        }
        this.addresses = addresses;
        this.useTLS = b.useTLS$set ? b.useTLS$value : BaseClientConfiguration.$default$useTLS();
        this.readFrom = b.readFrom$set ? b.readFrom$value : BaseClientConfiguration.$default$readFrom();
        if (this.readFrom == null) {
            throw new NullPointerException("readFrom is marked non-null but is null");
        }
        this.credentials = b.credentials;
        this.requestTimeout = b.requestTimeout;
        this.clientName = b.clientName;
        this.libName = b.libName;
        this.protocol = b.protocol;
        this.inflightRequestsLimit = b.inflightRequestsLimit;
        this.clientAZ = b.clientAZ;
        this.reconnectStrategy = b.reconnectStrategy;
        this.databaseId = b.databaseId;
        this.lazyConnect = b.lazyConnect$set ? b.lazyConnect$value : BaseClientConfiguration.$default$lazyConnect();
    }

    @Generated
    public boolean isUseTLS() {
        return this.useTLS;
    }

    @NonNull
    @Generated
    public ReadFrom getReadFrom() {
        return this.readFrom;
    }

    @Generated
    public ServerCredentials getCredentials() {
        return this.credentials;
    }

    @Generated
    public Integer getRequestTimeout() {
        return this.requestTimeout;
    }

    @Generated
    public String getClientName() {
        return this.clientName;
    }

    @Generated
    public String getLibName() {
        return this.libName;
    }

    @Generated
    public ProtocolVersion getProtocol() {
        return this.protocol;
    }

    @Generated
    public Integer getInflightRequestsLimit() {
        return this.inflightRequestsLimit;
    }

    @Generated
    public String getClientAZ() {
        return this.clientAZ;
    }

    @Generated
    public BackoffStrategy getReconnectStrategy() {
        return this.reconnectStrategy;
    }

    @Generated
    public Integer getDatabaseId() {
        return this.databaseId;
    }

    @Generated
    public boolean isLazyConnect() {
        return this.lazyConnect;
    }

    @Generated
    public static abstract class BaseClientConfigurationBuilder<C extends BaseClientConfiguration, B extends BaseClientConfigurationBuilder<C, B>> {
        @Generated
        private ArrayList<NodeAddress> addresses;
        @Generated
        private boolean useTLS$set;
        @Generated
        private boolean useTLS$value;
        @Generated
        private boolean readFrom$set;
        @Generated
        private ReadFrom readFrom$value;
        @Generated
        private ServerCredentials credentials;
        @Generated
        private Integer requestTimeout;
        @Generated
        private String clientName;
        @Generated
        private String libName;
        @Generated
        private ProtocolVersion protocol;
        @Generated
        private Integer inflightRequestsLimit;
        @Generated
        private String clientAZ;
        @Generated
        private BackoffStrategy reconnectStrategy;
        @Generated
        private Integer databaseId;
        @Generated
        private boolean lazyConnect$set;
        @Generated
        private boolean lazyConnect$value;

        @Generated
        public B address(NodeAddress address) {
            if (this.addresses == null) {
                this.addresses = new ArrayList();
            }
            this.addresses.add(address);
            return this.self();
        }

        @Generated
        public B addresses(Collection<? extends NodeAddress> addresses) {
            if (addresses == null) {
                throw new NullPointerException("addresses cannot be null");
            }
            if (this.addresses == null) {
                this.addresses = new ArrayList();
            }
            this.addresses.addAll(addresses);
            return this.self();
        }

        @Generated
        public B clearAddresses() {
            if (this.addresses != null) {
                this.addresses.clear();
            }
            return this.self();
        }

        @Generated
        public B useTLS(boolean useTLS) {
            this.useTLS$value = useTLS;
            this.useTLS$set = true;
            return this.self();
        }

        @Generated
        public B readFrom(@NonNull ReadFrom readFrom) {
            if (readFrom == null) {
                throw new NullPointerException("readFrom is marked non-null but is null");
            }
            this.readFrom$value = readFrom;
            this.readFrom$set = true;
            return this.self();
        }

        @Generated
        public B credentials(ServerCredentials credentials) {
            this.credentials = credentials;
            return this.self();
        }

        @Generated
        public B requestTimeout(Integer requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this.self();
        }

        @Generated
        public B clientName(String clientName) {
            this.clientName = clientName;
            return this.self();
        }

        @Generated
        public B libName(String libName) {
            this.libName = libName;
            return this.self();
        }

        @Generated
        public B protocol(ProtocolVersion protocol) {
            this.protocol = protocol;
            return this.self();
        }

        @Generated
        public B inflightRequestsLimit(Integer inflightRequestsLimit) {
            this.inflightRequestsLimit = inflightRequestsLimit;
            return this.self();
        }

        @Generated
        public B clientAZ(String clientAZ) {
            this.clientAZ = clientAZ;
            return this.self();
        }

        @Generated
        public B reconnectStrategy(BackoffStrategy reconnectStrategy) {
            this.reconnectStrategy = reconnectStrategy;
            return this.self();
        }

        @Generated
        public B databaseId(Integer databaseId) {
            this.databaseId = databaseId;
            return this.self();
        }

        @Generated
        public B lazyConnect(boolean lazyConnect) {
            this.lazyConnect$value = lazyConnect;
            this.lazyConnect$set = true;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "BaseClientConfiguration.BaseClientConfigurationBuilder(addresses=" + String.valueOf(this.addresses) + ", useTLS$value=" + this.useTLS$value + ", readFrom$value=" + String.valueOf((Object)this.readFrom$value) + ", credentials=" + String.valueOf(this.credentials) + ", requestTimeout=" + this.requestTimeout + ", clientName=" + this.clientName + ", libName=" + this.libName + ", protocol=" + String.valueOf((Object)this.protocol) + ", inflightRequestsLimit=" + this.inflightRequestsLimit + ", clientAZ=" + this.clientAZ + ", reconnectStrategy=" + String.valueOf(this.reconnectStrategy) + ", databaseId=" + this.databaseId + ", lazyConnect$value=" + this.lazyConnect$value + ")";
        }
    }
}

